/*****************************************************************************        
*
*   Module:     list1.c
*               
*   Author:     Mike Hibbett 
*                                                                  
*   Version:    0.1 29/10/07                                                  
*
*               Demonstrates a very simple user interface
*               This code can be turned into a .hex file
*               by simply opening it in MPLAB and selecting
*               'Project' then 'QuickBuild List1.asm'
*
*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include <xlcd.h>
#include <delays.h>

/* Set the configuration registers as we want them */
#pragma config WDT=OFF, OSC=INTIO7, LVP=OFF
#pragma config MCLRE = OFF, PBADEN = OFF

/* Useful names for constants used in the program */
#define ADC_OFF_VAL 0x0F

/* Forward declarations, as required by 'C' */
void initHardware( void );
void lockDoor( void );
void unlockDoor( void );
void displayLocked( void );
void displayUnlocked( void );
void getKey( void );
void openDelay( void );
void UIWait10ms(unsigned char );



/*****************************************************************************
*
*   Function : main
*              The entry point to our C program
*
*   Input:     None.
*
*****************************************************************************/
void main(void)
{
	initHardware();
	
	/* loop round applictaion, forever */
	do {
		
		lockDoor();
		displayLocked();
		getKey();
		displayUnlocked();
		unlockDoor();
		openDelay();
		
	} while (1);
	
}



/*****************************************************************************
*
*   Function : initHardware
*              Configures the speed of the on-board oscillator,
*              sets up the I/O ports and initialises the LCD
*
*   Input:     None.
*
*****************************************************************************/
void initHardware()
{
	/* Set oscillator to 8MHz. */
	OSCCON = 0x73; 

    /* Allow PORTB pins to be set to digital I/O */
    ADCON1 = ADC_OFF_VAL;

	/* Make PORTB output, for driving LCD 
	PORTB = 0xFF;
	TRISB = 0;*/
	
	/* First, delay for 1/2s for things to settle */
	UIWait10ms(50);
	
	/* Make port RC inputs, for the keys */
	TRISC=0xFF;
		
	/* Initialise the LCD */
	OpenXLCD( FOUR_BIT & LINES_5X7 );
	while( BusyXLCD() );
	WriteCmdXLCD(BLINK_OFF & CURSOR_OFF);
	
}



/*****************************************************************************
*
*   Function : lockDoor
*              Turn the door lock solenoid on, locking the door.
*              (Just a stub routine in this example - it is not important)
*
*   Input:     None
*
*****************************************************************************/
void lockDoor( void )
{
	
}



/*****************************************************************************
*
*   Function : unlockDoor
*              Turn the door lock solenoid off, unlocking the door.
*              (Just a stub routine in this example - it is not important)
*
*   Input:     None
*
*****************************************************************************/
void unlockDoor( void )
{
	
}



/*****************************************************************************
*
*   Function : displayLocked
*              Displays the message "Door Locked  " on the LCD
*
*   Input:     None
*
*****************************************************************************/
void displayLocked( void )
{
	while( BusyXLCD() );
	SetDDRamAddr( 0 );
	putrsXLCD( "Door Locked  " );
}



/*****************************************************************************
*
*   Function : displayUnlocked
*              Displays the message "Door Unlocked" on the LCD
*
*   Input:     None
*
*****************************************************************************/
void displayUnlocked( void )
{
	while( BusyXLCD() );
	SetDDRamAddr( 0 );
	putrsXLCD( "Door Unlocked" );
}



/*****************************************************************************
*
*   Function : getKey
*              Waits for a key to be pressed, and then released
*              The key is on RC0
*
*   Input:     None
*
*****************************************************************************/
void getKey( void )
{
	unsigned char keyValue;

	/* Wait for the key to be pressed */	
	do {
		do {
			keyValue = PORTC & 0x01;
		} while ( keyValue );
		
		UIWait10ms(2);
		
		keyValue = PORTC & 0x01;
	} while ( keyValue );


	/* Wait for the key to be released */	
	do {
		do {
			keyValue = PORTC & 0x01;
		} while ( !keyValue );
		
		UIWait10ms(2);
		
		keyValue = PORTC & 0x01;
	} while ( !keyValue );
}



/*****************************************************************************
*
*   Function : openDelay
*              Waits for a few seconds ( 5s, to allow the door to be pulled 
*              open )
*
*   Input:     None
*
*****************************************************************************/
void openDelay( void )
{
	UIWait10ms(250);	
	UIWait10ms(250);	
}



/*****************************************************************************
*
*   Function : UIWait10ms
*              delays for a multiple of 10ms
*              sets up the I/O ports and initialises the LCD
*
*   Input:     multiple of 10ms, 1 .. 255
*
*****************************************************************************/
void UIWait10ms(unsigned char num)
{
	do {
		DelayXLCD();
		DelayXLCD();		
	} while (--num);
	
}



/*****************************************************************
*
*  The routines below are needed for the C-Library's LCD display
*  routines to work. The effectively implement the 'target' 
*  specific requirements, such as delay routines. The C-library
*  does not know how fast your processor is running, for example!
*
*****************************************************************/


void DelayFor18TCY(void)
{
	// Delay for 18 clock cycles
	_asm
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	_endasm
}


void DelayXLCD(void)
{
	// delay for 5 ms	
    // Cycles = (TimeDelay * Fosc) / 4
    // Cycles = (5ms * 8MHz) / 4
    // Cycles = 100,000}
	Delay1KTCYx(10); 
}

void DelayPORXLCD(void)
{
	// Delay for 15ms
	DelayXLCD();
	DelayXLCD();
	DelayXLCD();
}

