VERSION 5.00
Begin VB.Form Magnetometer 
   Caption         =   "EPE Magnetometer and Earth Resistivity Logger  V1.5  27OCT03"
   ClientHeight    =   6375
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6675
   Icon            =   "Magnetometer.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6375
   ScaleWidth      =   6675
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton GridBars 
      BackColor       =   &H0000FFFF&
      Caption         =   "3D Graph"
      Height          =   495
      Left            =   2760
      Style           =   1  'Graphical
      TabIndex        =   138
      Top             =   3360
      Width           =   855
   End
   Begin VB.OptionButton MagOption 
      Caption         =   "Magnetometer"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   4560
      TabIndex        =   137
      ToolTipText     =   "For use with the magnetometer, which  is a project to be published in EPE in the future - date not yet known"
      Top             =   840
      Width           =   1815
   End
   Begin VB.OptionButton EarthResOption 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Resistivity"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   195
      Left            =   4560
      TabIndex        =   136
      ToolTipText     =   "Use for the Earth Resistivity Logger - published in EPE Apr/May 2003"
      Top             =   600
      Width           =   1815
   End
   Begin VB.CommandButton ViewOrig 
      BackColor       =   &H00FFFF00&
      Caption         =   "View Orig as Text"
      Height          =   495
      Left            =   3240
      Style           =   1  'Graphical
      TabIndex        =   130
      ToolTipText     =   "Calls in orig 2-byte data for viewing via Notepad/Wordpad"
      Top             =   1200
      Width           =   855
   End
   Begin VB.CommandButton ViewOCXnotes 
      BackColor       =   &H00FFFF00&
      Caption         =   "Please Read"
      Height          =   375
      Left            =   4920
      Style           =   1  'Graphical
      TabIndex        =   129
      ToolTipText     =   "An important note you should read"
      Top             =   1320
      Width           =   1095
   End
   Begin VB.CommandButton ViewData 
      BackColor       =   &H00FFFF00&
      Caption         =   "View Data as Text "
      Height          =   495
      Left            =   2280
      Style           =   1  'Graphical
      TabIndex        =   128
      ToolTipText     =   "Calls in loaded data for viewing via Notepad/Wordpad"
      Top             =   1200
      Width           =   855
   End
   Begin VB.CommandButton Command2 
      BackColor       =   &H00FFFF00&
      Caption         =   "Circuit"
      Height          =   495
      Left            =   5520
      Style           =   1  'Graphical
      TabIndex        =   127
      ToolTipText     =   $"Magnetometer.frx":0442
      Top             =   2880
      Width           =   855
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00FFFF00&
      Caption         =   "Text"
      Height          =   495
      Left            =   4560
      Style           =   1  'Graphical
      TabIndex        =   126
      ToolTipText     =   $"Magnetometer.frx":04E7
      Top             =   2880
      Width           =   855
   End
   Begin VB.CommandButton FullGraph 
      BackColor       =   &H0000FFFF&
      Caption         =   "Full Graph"
      Height          =   495
      Left            =   3240
      Style           =   1  'Graphical
      TabIndex        =   124
      ToolTipText     =   "Shows graph of full 128 x 128 site"
      Top             =   2760
      Width           =   855
   End
   Begin VB.CommandButton FullGrid 
      BackColor       =   &H0000FFFF&
      Caption         =   "Full Grid"
      Height          =   495
      Left            =   2280
      Style           =   1  'Graphical
      TabIndex        =   123
      ToolTipText     =   "Shows grid of full 128 x 128 site"
      Top             =   2760
      Width           =   855
   End
   Begin VB.CommandButton SerialInput 
      BackColor       =   &H0000FFFF&
      Caption         =   "Download Data "
      Height          =   495
      Left            =   2280
      Style           =   1  'Graphical
      TabIndex        =   122
      TabStop         =   0   'False
      ToolTipText     =   "Calls up PIC data download screen"
      Top             =   600
      Width           =   855
   End
   Begin VB.CommandButton Directory 
      BackColor       =   &H0000FF00&
      Caption         =   "Directory"
      Height          =   495
      Left            =   3240
      Style           =   1  'Graphical
      TabIndex        =   1
      TabStop         =   0   'False
      ToolTipText     =   "Calls up file selection screen"
      Top             =   600
      Width           =   855
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   7
      Left            =   0
      TabIndex        =   135
      Top             =   0
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   6
      Left            =   0
      TabIndex        =   134
      Top             =   0
      Width           =   255
   End
   Begin VB.Shape Shape6 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      Height          =   1455
      Left            =   2160
      Shape           =   4  'Rounded Rectangle
      Top             =   4200
      Width           =   4335
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   "Loaded Disk File"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   3000
      TabIndex        =   9
      Top             =   4320
      Width           =   2655
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   "Data Type"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   4680
      TabIndex        =   10
      Top             =   240
      Width           =   1575
   End
   Begin VB.Shape Shape5 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      Height          =   1815
      Left            =   4440
      Shape           =   4  'Rounded Rectangle
      Top             =   120
      Width           =   2055
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      Caption         =   "Data Display"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   375
      Left            =   2400
      TabIndex        =   133
      Top             =   2280
      Width           =   1575
   End
   Begin VB.Shape Shape4 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      Height          =   1815
      Left            =   2160
      Shape           =   4  'Rounded Rectangle
      Top             =   2160
      Width           =   2055
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Data Access"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   2400
      TabIndex        =   132
      Top             =   240
      Width           =   1575
   End
   Begin VB.Shape Shape3 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      Height          =   1815
      Left            =   2160
      Shape           =   4  'Rounded Rectangle
      Top             =   120
      Width           =   2055
   End
   Begin VB.Shape Shape1 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      Height          =   6135
      Left            =   240
      Shape           =   4  'Rounded Rectangle
      Top             =   120
      Width           =   1695
   End
   Begin VB.Label Label16 
      Alignment       =   2  'Center
      Caption         =   " Earth Resistivity Experiment"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   495
      Left            =   4560
      TabIndex        =   131
      ToolTipText     =   "A Resistivity experiment you can do - read the text!"
      Top             =   2280
      Width           =   1815
   End
   Begin VB.Shape Shape2 
      BorderColor     =   &H00C00000&
      BorderWidth     =   2
      Height          =   1335
      Left            =   4440
      Shape           =   4  'Rounded Rectangle
      Top             =   2160
      Width           =   2055
   End
   Begin VB.Label Label14 
      Alignment       =   2  'Center
      Caption         =   " Processing data - Please wait"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   495
      Left            =   2160
      TabIndex        =   125
      Top             =   5760
      Visible         =   0   'False
      Width           =   4335
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   36
      Left            =   1440
      TabIndex        =   121
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   35
      Left            =   1440
      TabIndex        =   120
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   34
      Left            =   1440
      TabIndex        =   119
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   33
      Left            =   1440
      TabIndex        =   118
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   32
      Left            =   1440
      TabIndex        =   117
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   31
      Left            =   1440
      TabIndex        =   116
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   30
      Left            =   1440
      TabIndex        =   115
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   29
      Left            =   1440
      TabIndex        =   114
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   28
      Left            =   1440
      TabIndex        =   113
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   27
      Left            =   1440
      TabIndex        =   112
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   26
      Left            =   1440
      TabIndex        =   111
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   25
      Left            =   1440
      TabIndex        =   110
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   24
      Left            =   1440
      TabIndex        =   109
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   23
      Left            =   1440
      TabIndex        =   108
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   22
      Left            =   1440
      TabIndex        =   107
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   21
      Left            =   1440
      TabIndex        =   106
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   20
      Left            =   1440
      TabIndex        =   105
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   19
      Left            =   1440
      TabIndex        =   104
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   18
      Left            =   1440
      TabIndex        =   103
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   17
      Left            =   1440
      TabIndex        =   102
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   16
      Left            =   1440
      TabIndex        =   101
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   15
      Left            =   1440
      TabIndex        =   100
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   14
      Left            =   1440
      TabIndex        =   99
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   13
      Left            =   1440
      TabIndex        =   98
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   12
      Left            =   1440
      TabIndex        =   97
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   11
      Left            =   1440
      TabIndex        =   96
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   10
      Left            =   1440
      TabIndex        =   95
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   9
      Left            =   1440
      TabIndex        =   94
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   8
      Left            =   1440
      TabIndex        =   93
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   7
      Left            =   1440
      TabIndex        =   92
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   6
      Left            =   1440
      TabIndex        =   91
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   5
      Left            =   1440
      TabIndex        =   90
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   4
      Left            =   1440
      TabIndex        =   89
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   3
      Left            =   1440
      TabIndex        =   88
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   2
      Left            =   1440
      TabIndex        =   87
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   1
      Left            =   1440
      TabIndex        =   86
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColShade 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   0
      Left            =   1440
      TabIndex        =   85
      Top             =   5640
      Width           =   255
   End
   Begin VB.Label ColourBlock8 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   7
      Left            =   1440
      TabIndex        =   84
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColourBlock8 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   6
      Left            =   1440
      TabIndex        =   83
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColourBlock8 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   5
      Left            =   1440
      TabIndex        =   82
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColourBlock8 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   4
      Left            =   1440
      TabIndex        =   81
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColourBlock8 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   3
      Left            =   1440
      TabIndex        =   80
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColourBlock8 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   2
      Left            =   1440
      TabIndex        =   79
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColourBlock8 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   1
      Left            =   1440
      TabIndex        =   78
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColourBlock8 
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   0
      Left            =   1440
      TabIndex        =   77
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   36
      Left            =   1320
      TabIndex        =   76
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   35
      Left            =   1320
      TabIndex        =   75
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   34
      Left            =   1320
      TabIndex        =   74
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   33
      Left            =   1320
      TabIndex        =   73
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   32
      Left            =   1320
      TabIndex        =   72
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   31
      Left            =   1320
      TabIndex        =   71
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   30
      Left            =   1320
      TabIndex        =   70
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   29
      Left            =   1320
      TabIndex        =   69
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   28
      Left            =   1320
      TabIndex        =   68
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   27
      Left            =   1320
      TabIndex        =   67
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   26
      Left            =   1320
      TabIndex        =   66
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   25
      Left            =   1320
      TabIndex        =   65
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   24
      Left            =   1320
      TabIndex        =   64
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   23
      Left            =   1320
      TabIndex        =   63
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   22
      Left            =   1320
      TabIndex        =   62
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   21
      Left            =   1320
      TabIndex        =   61
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   20
      Left            =   1320
      TabIndex        =   60
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   19
      Left            =   1320
      TabIndex        =   59
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   18
      Left            =   1320
      TabIndex        =   58
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   15
      Index           =   17
      Left            =   1320
      TabIndex        =   57
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   16
      Left            =   1320
      TabIndex        =   56
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   15
      Left            =   1320
      TabIndex        =   55
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   14
      Left            =   1320
      TabIndex        =   54
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   13
      Left            =   1320
      TabIndex        =   53
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   12
      Left            =   1320
      TabIndex        =   52
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   11
      Left            =   1320
      TabIndex        =   51
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   10
      Left            =   1320
      TabIndex        =   50
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   9
      Left            =   1320
      TabIndex        =   49
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   8
      Left            =   1320
      TabIndex        =   48
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   7
      Left            =   1320
      TabIndex        =   47
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   6
      Left            =   1320
      TabIndex        =   46
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   5
      Left            =   1320
      TabIndex        =   45
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   4
      Left            =   1320
      TabIndex        =   44
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   3
      Left            =   1320
      TabIndex        =   43
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   2
      Left            =   1320
      TabIndex        =   42
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   1
      Left            =   1320
      TabIndex        =   41
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label GreyBlock 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   0
      Left            =   1320
      TabIndex        =   40
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   36
      Left            =   1560
      TabIndex        =   39
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   35
      Left            =   1560
      TabIndex        =   38
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   34
      Left            =   1560
      TabIndex        =   37
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   33
      Left            =   1560
      TabIndex        =   36
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   32
      Left            =   1560
      TabIndex        =   35
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   31
      Left            =   1560
      TabIndex        =   34
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   30
      Left            =   1560
      TabIndex        =   33
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   29
      Left            =   1560
      TabIndex        =   32
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   28
      Left            =   1560
      TabIndex        =   31
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   27
      Left            =   1560
      TabIndex        =   30
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   26
      Left            =   1560
      TabIndex        =   29
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   25
      Left            =   1560
      TabIndex        =   28
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   24
      Left            =   1560
      TabIndex        =   27
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   23
      Left            =   1560
      TabIndex        =   26
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   22
      Left            =   1560
      TabIndex        =   25
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   21
      Left            =   1560
      TabIndex        =   24
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   20
      Left            =   1560
      TabIndex        =   23
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   19
      Left            =   1560
      TabIndex        =   22
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   18
      Left            =   1560
      TabIndex        =   21
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   17
      Left            =   1560
      TabIndex        =   20
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   16
      Left            =   1560
      TabIndex        =   19
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   15
      Left            =   1560
      TabIndex        =   18
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   14
      Left            =   1560
      TabIndex        =   17
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   13
      Left            =   1560
      TabIndex        =   16
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   12
      Left            =   1560
      TabIndex        =   15
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   11
      Left            =   1560
      TabIndex        =   14
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   10
      Left            =   1560
      TabIndex        =   13
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   9
      Left            =   1560
      TabIndex        =   12
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   8
      Left            =   1560
      TabIndex        =   11
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   5
      Left            =   1560
      TabIndex        =   8
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   4
      Left            =   1560
      TabIndex        =   7
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   3
      Left            =   1560
      TabIndex        =   6
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   2
      Left            =   1560
      TabIndex        =   5
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   1
      Left            =   1560
      TabIndex        =   4
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label ColBlock32 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   135
      Index           =   0
      Left            =   1560
      TabIndex        =   3
      Top             =   5400
      Width           =   255
   End
   Begin VB.Label Label6 
      Alignment       =   2  'Center
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   855
      Left            =   2280
      TabIndex        =   2
      Top             =   4680
      Width           =   4095
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      Caption         =   "Colour Charts"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   360
      TabIndex        =   0
      Top             =   240
      Width           =   1455
   End
End
Attribute VB_Name = "Magnetometer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'Magnetometer & Earth Resistivity 13APR04

Private Sub Form_Load()

Mode = 0: Mode2 = 0: GraphFlag = 0: Zoom = 1: DownloadOkFlag = 0
OCXport = 1
MagnetometerOCX.Option1(OCXport - 1).Value = True
GraphVert = 0: GraphHoriz = 0: ZoomerVal = 0.6: Plotit3D = 0
ColBlack = 0

For A = 0 To 25
MagnetometerSelect.ColumnOn(A).Value = 1
Next

Col(1, 36) = vbBlack
Col(1, 35) = &H80&: ' dark red
Col(1, 34) = &HC0&
Col(1, 33) = &HFF&
Col(1, 32) = &H8080FF
Col(1, 31) = &HC0C0FF: ' light red

Col(1, 30) = &H4080&: ' dark orange
Col(1, 29) = &H40C0&
Col(1, 28) = &H80FF&
Col(1, 27) = &H80C0FF
Col(1, 26) = &HC0E0FF: ' light orange

Col(1, 25) = &H8080&: ' dark yellow
Col(1, 24) = &HC0C0&
Col(1, 23) = &HFFFF&
Col(1, 22) = &H80FFFF
Col(1, 21) = &HC0FFFF: ' light yellow

Col(1, 20) = &H8000&: ' dark green
Col(1, 19) = &HC000&
Col(1, 18) = &HFF00&
Col(1, 17) = &H80FF80
Col(1, 16) = &HC0FFC0: ' light green

Col(1, 15) = &H808000: ' dark cyan
Col(1, 14) = &HC0C000
Col(1, 13) = &HFFFF00
Col(1, 12) = &HFFFF80
Col(1, 11) = &HFFFFC0: ' light cyan

Col(1, 10) = &H800000: ' dark blue
Col(1, 9) = &HC00000
Col(1, 8) = &HFF0000
Col(1, 7) = &HFF8080
Col(1, 6) = &HFFC0C0: ' light blue

Col(1, 5) = &H800080: ' dark magenta
Col(1, 4) = &HC000C0
Col(1, 3) = &HFF00FF
Col(1, 2) = &HFF80FF
Col(1, 1) = &HFFC0FF: ' light magenta

Col(1, 0) = vbWhite

Col(3, 7) = vbBlack
Col(3, 6) = vbRed
Col(3, 5) = vbGreen
Col(3, 4) = vbYellow

Col(3, 3) = vbBlue
Col(3, 2) = vbMagenta
Col(3, 1) = vbCyan
Col(3, 0) = vbWhite

Col(0, 37) = vbGrayText
Col(1, 37) = vbGrayText
Col(2, 37) = vbGrayText
Col(3, 37) = vbGrayText

Month$(1) = "Jan": Month$(2) = "Feb": Month$(3) = "Mar": Month$(4) = "Apr"
Month$(5) = "May": Month$(6) = "Jun": Month$(7) = "Jul": Month$(8) = "Aug"
Month$(9) = "Sep": Month$(10) = "Oct": Month$(11) = "Nov": Month$(12) = "Dec"

MagnetometerFullGraph.Show
MagnetometerFullGraph.Refresh
Magnetometer.Show
Magnetometer.Refresh

OpenFile = "An unknown problem exists right at the start of loading Magnetometer.EXE"
On Error GoTo FatalError: 'set error handler

newuser = 0:
ErrorMessage$ = "This error has been intercepted by the PC System, not by the Earth Resistivity program."
ErrorMessage$ = ErrorMessage$ & "If the problem persists please report its details and circumstances of it occurring to John Becker at EPE"
defaulterror$ = ErrorMessage$
tempA$ = "No File Selected Yet"
InputFile(0) = tempA$: NamedFile(0) = tempA$: InputSize(0) = 0
InputFile(1) = tempA$: NamedFile(1) = tempA$: InputSize(1) = 0

DefaultDrive = "C:\"
DirComboText = "C:\"
MagnetometerDir.Combo1.Text = DirComboText

If MagOption.Value = True Then
PicPath = 1
Else
PicPath = 0
End If

PrevPicPath = 2

On Error GoTo HistoryError
OpenFile = "Cannot find MagnetometerHistory.txt"
Open "MagnetometerHistory.txt" For Input As #1: Close

On Error GoTo SettingsError
OpenFile = "Cannot find MagnetometerSettings.txt"
Open "MagnetometerSettings.txt" For Input As #1: Close

GetSettings:

Open "MagnetometerSettings.txt" For Input As #1

Line Input #1, tempA$: ' previously Port0 = Val(tempA$): Port1 = Port0 + 1: Port3 = Port0 + 3: Port5 = Port0 + 5

Line Input #1, tempA$: DriveC$ = tempA$:
Line Input #1, tempA$: DirComboText = tempA$
Line Input #1, tempA$: InputFile(0) = tempA$
Line Input #1, tempA$: NamedFile(0) = tempA$
Line Input #1, tempA$: InputFile(1) = tempA$
Line Input #1, tempA$: NamedFile(1) = tempA$
Line Input #1, tempA$: PicPath = Val(tempA$)
Line Input #1, tempA$: ' previously SerialVersion = Val(tempA$)
Line Input #1, tempA$: OCXport = Val(tempA$)
If OCXport = 0 Then OCXport = 1
MagnetometerOCX.Option1(OCXport - 1).Value = True
Close

On Error GoTo showerror
OpenFile = "Problem trying to allocate default drive path"

Label6.Caption = NamedFile(PicPath)

DefaultDrive = DriveC$: Drive1 = DriveC$

If UCase$(Left$(DriveC$, 3)) <> DefaultDrive Then DriveC$ = DefaultDrive

OpenFile = "Cannot correctly access Directory Default Drive path  " & DefaultDrive

MagnetometerDir.Drive1.Drive = DefaultDrive
OpenFile = "Cannot correctly access Directory (Drive C$) path  " & DriveC$
MagnetometerDir.Dir1.Path = DriveC$

HistoryQ = 0:
OpenFile = "Cannot find MagnetometerHistory.txt file, or its data is corrupted"
Open "MagnetometerHistory.txt" For Input As #1
getit3: If EOF(1) = 0 Then
  Line Input #1, tempA$
  If tempA$ <> "" And tempA$ <> History(HistoryQ) Then
  HistoryQ = HistoryQ + 1: History(HistoryQ) = tempA$
  MagnetometerDir.Combo1.AddItem tempA$
  End If
GoTo getit3
End If
OpenFile = ""
MagnetometerDir.Combo1.Text = DirComboText
MagnetometerDirPath(PicPath) = DirComboText
Close

On Error GoTo NewUserError: 'set error handler used to check if prog has been run before
Open "ClearMagnetometer.txt" For Input As #1: Close

On Error GoTo 0

X = 140 + 240: Y = 500 + 40: bc = 255
For A = 0 To 36
bd$ = Hex$(bc): bd$ = Right$("000" & bd$, 2)
tempA$ = "&h00" & bd$ & bd$ & bd$ & "&": bc = bc - 5
GreyBlock(A).Visible = False
GreyBlock(A).BackColor = Val(tempA$)
GreyBlock(A).Left = X: GreyBlock(A).Top = Y: GreyBlock(A).Width = 300
GreyBlock(A).ToolTipText = "Grid scale value = " & A
Col(0, A) = Val(tempA$): Y = Y + 150
GreyBlock(A).Visible = True
Next

X = 480 + 240: Y = 500 + 40
For A = 0 To 36
ColBlock32(A).Visible = False
ColBlock32(A).BackColor = Col(1, A)
ColBlock32(A).Top = Y: ColBlock32(A).Left = X: ColBlock32(A).Width = 300
ColBlock32(A).ToolTipText = "Grid scale value = " & A
ColBlock32(A).Visible = True
Y = Y + 150
Next

X = 840 + 240: Y = 500 + 40: bc = 255
For A = 0 To 36
bd$ = Hex$(bc): bd$ = Right$("000" & bd$, 2)
tempA$ = "&h00" & "00" & bd$ & "00" & "&": bc = bc - 5
ColShade(A).Visible = False
ColShade(A).BackColor = (Val(tempA$) + Val(&HC0))
ColShade(A).Left = X: ColShade(A).Top = Y: ColShade(A).Width = 300
ColShade(A).ToolTipText = "Grid scale value = " & A
Col(2, A) = (Val(tempA$) + Val(&HC0)): Y = Y + 150
ColShade(A).Visible = True
Next

X = 1200 + 240: Y = 500 + 40
For A = 0 To 7
ColourBlock8(A).Visible = False
ColourBlock8(A).Top = Y: ColourBlock8(A).Left = X: ColourBlock8(A).Width = 300
ColourBlock8(A).ToolTipText = "Grid scale value = " & A
ColourBlock8(A).BackColor = Col(3, A)
ColourBlock8(A).Visible = True
Y = Y + 150
Next

LoadingFlag = 1
If PicPath = 0 Then EarthResOption.Value = True Else MagOption.Value = True
LoadingFlag = 0

For C = 0 To 127
MagnetometerSelect.Label4(C).BackColor = Col(3, C And 7)
Next
B = 0: For C = 130 To 259
MagnetometerSelect.Label4(C).BackColor = Col(3, B And 7): B = B + 1
Next

Exit Sub

'.............

NewUserError:
Close: Open "ClearMagnetomter.txt" For Output As #2
Print #2, "Magnetometer first loaded " & Date$ & " " & Time$: Close
DriveC$ = "C:\": newuser = 1
Close:
Open "MagnetometerHistory.txt" For Output As #2: Print #2, "C:\": Close
Call SaveDefaults
MagnetometerDir.Combo1.Text = DirComboText: MagnetometerDirPath(PicPath) = DirComboText
Resume Next

SettingsError:
Close: Call SaveDefaults
Resume Next

HistoryError:
Close: Open "MagnetometerHistory.txt" For Output As #2: Print #2, "C:\": Close
MagnetometerDir.Combo1.Text = DirComboText: MagnetometerDirPath(PicPath) = DirComboText
Resume Next

showerror:
Close: Magnetometer.Hide: Call MagnetometerShowError.waitresponse
Resume enderror
enderror:
Exit Sub

FatalError:
Beep
tempB$ = "A non-recoverable error has occurred during program loading and involves the following Earth Resistivity generated statement:"
tempB$ = tempB$ & Chr(13) & Chr(13) & OpenFile
tempB$ = tempB$ & Chr(13) & Chr(13) & "Please check that all the Earth Resistivity files are in the same folder (directory) as the program you are now trying to run. The folder must be on the Hard Drive."
tempB$ = tempB$ & Chr(13) & Chr(13) & "If the data is corrupted re-copy the file of the same name from your original disk or FTP download."
tempB$ = tempB$ & Chr(13) & Chr(13) & "If you cannot resolve the problem please advise John Becker of the details via the EPE Editorial Office (not via the Chat Zone)."
tempB$ = tempB$ & Chr(13) & Chr(13) & "The loading has been aborted and you will be returned to the previous screen."
MsgBox tempB$, vbCritical
End

End Sub

Public Sub FullGraph_Click()

fname = InputFile(PicPath)
If fname = "No File Selected Yet" Then
Beep
MsgBox fname, vbExclamation
Exit Sub
End If

Plotit3D = 0
MagnetometerFullGraph.Rotate.Visible = True
MagnetometerFullGraph.Inverter.Visible = True

MagnetometerFullGraph.Show
Call MagnetometerFullGraph.PlotIt_Click
End Sub

Private Sub FullGrid_Click()

fname = InputFile(PicPath)
If fname = "No File Selected Yet" Then
Beep
MsgBox fname, vbExclamation
Exit Sub
End If

MagnetometerFullGrid.Show
Call MagnetometerFullGrid.PlotIt_Click
End Sub

Private Sub GridBars_Click()
Plotit3D = 1
MagnetometerFullGraph.Rotate.Visible = False
MagnetometerFullGraph.Inverter.Visible = False

MagnetometerFullGraph.Show
Call MagnetometerFullGraph.MagBarPlotIt
End Sub

Private Sub Label6_dblClick()
End
End Sub

Private Sub MagOption_Click()
PicPath = 1
If NamedFile(PicPath) <> "No File Selected Yet" Then
Call InputSamples
Label6.Caption = NamedFile(1)
Call SaveDefaults
Else
Label6.Caption = "No File Selected Yet"
End If
MagnetometerDir.PrefixLabel = "Prefixed 'EarthMag '"

MagnetometerFullGrid.Resist.Visible = False
MagnetometerFullGraph.Resist.Visible = False
MagnetometerFullGraph.BlanksFill.Visible = False
MagnetometerFullGraph.Picture1.Cls
MagnetometerFullGraph.GPSvalues.Visible = True
MagnetometerFullGraph.Text1.Text = "0"

End Sub

Public Sub SaveDefaults()
Close: Open "MagnetometerSettings.txt" For Output As #2
If Len(DriveC$) <> 3 Then DriveC$ = "C:\"

Print #2, "": ' previously "&h" & Hex$(Port0)
Print #2, DriveC$
Print #2, MagnetometerDir.Combo1.Text
Print #2, InputFile(0): Print #2, NamedFile(0)
Print #2, InputFile(1): Print #2, NamedFile(1)
Print #2, PicPath
Print #2, "": ' previously SerialVersion & " Version 0 = standard serial path, 1 = enhanced OCX serial path"
Print #2, OCXport & " OCX port value"
Close
End Sub

Private Sub Drive1_Change()
PicPath = 0: FileName = "*.TXT":
DefaultDrive = UCase$(Drive1.Drive) & "\"
DriveC$ = DefaultDrive
MagnetometerDir.Combo1.AddItem DriveC$
MagnetometerDir.Drive1.Drive = Drive1.Drive
MagnetometerDir.Dir1.Path = DriveC$
PrevPicPath = 0
Call SaveDefaults
PicPath = 0: FileName = DriveC$ & "*.TXT":
MagnetometerDir.Show
Call MagnetometerDir.dirshow
Label9.Caption = NamedFile(PicPath)
End Sub

Private Sub Directory_Click()
Shape1.Refresh
On Error GoTo showerror

FileName = "*.TXT"
If MagnetometerDir.Combo1.ListCount = 0 Then
MagnetometerDir.Combo1.Clear
For A = 1 To HistoryQ: MagnetometerDir.Combo1.AddItem History(A): Next
MagnetometerDir.Combo1.Text = DirComboText
End If

If MagnetometerDirPath(PicPath) = "" Then MagnetometerDirPath(PicPath) = DefaultDrive
OpenFile = MagnetometerDirPath(PicPath)

MagnetometerDir.Show
If PicPath <> PrevPicPath Then
If MagnetometerDirPath(PicPath) <> DefaultDrive Then MagnetometerDir.Dir1.Path = MagnetometerDirPath(PicPath)
Call MagnetometerDir.dirshow
PrevPicPath = PicPath: FilePath = InputFile(PicPath)
End If
Exit Sub

showerror:
If Err.Number = 68 Or Err.Number = 71 Or Err.Number = 76 Then
ErrorMessage = "Drive not ready for" & Chr(13) & OpenFile
Style = vbRetryCancel + vbExclamation
response = MsgBox(ErrorMessage, Style)
  If response = vbCancel Then
  MagnetometerDirPath(PicPath) = DefaultDrive
  OpenFile = MagnetometerDirPath(PicPath)
  Resume here
here:   Exit Sub
  End If

Resume
  Beep
  End If

MagnetometerShowError.Show
Call MagnetometerShowError.waitresponse
Resume enderror
enderror:
MagnetometerDir.Hide

End Sub

Private Sub AllFilesDir_Click()
MagnetometerDir.Show
End Sub

Private Sub SerialInput_Click()
DownloadFlag2 = 0

MagnetometerOCX.ProgressBar1.Value = 0
MagnetometerOCX.Show

End Sub

Private Sub ViewOrig_Click()
On Error GoTo showerror

fname = InputFile(PicPath)
If fname = "No File Selected Yet" Then
Beep
MsgBox fname, vbExclamation
Exit Sub
End If
tempB$ = Right$(fname, 29): tempB$ = Left$(tempB$, 8) & "ORIGDATA" & Right$(fname, 20)
tempB$ = Left$(fname, Len(fname) - 29) & tempB$
OpenFile = tempB$
fname = tempB$
Open fname For Input As #1: Close
processid = Shell("Notepad " & fname, vbNormalFocus)
OpenFile = ""

Exit Sub

showerror:
If Err.Number = 53 Then
Beep
MsgBox "Original data file and TX current values not created for this survey"
Resume enderror
End If

MagnetometerShowError.Show
Call MagnetometerShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub ViewData_Click()
On Error GoTo showerror

fname = InputFile(PicPath)
If fname = "No File Selected Yet" Then
Beep
MsgBox fname, vbExclamation
Exit Sub
End If

OpenFile = fname

Open fname For Input As #1: Close
processid = Shell("Notepad " & fname, vbNormalFocus)
OpenFile = ""

Exit Sub

showerror:
MagnetometerShowError.Show
Call MagnetometerShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub Command1_Click()
On Error GoTo showerror

nameit$ = "C:\program files\accessories\wordpad.exe "

fname = "EarthResExperiment.txt"

OpenFile = nameit$ & fname

Open fname For Input As #1: Close
processid = Shell("Notepad " & fname, vbNormalFocus)
OpenFile = ""
Exit Sub

showerror:
MagnetometerShowError.Show
Call MagnetometerShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub Command2_Click()
On Error GoTo showerror

nameit$ = "C:\program files\accessories\MSpaint.exe "

fname = "EarthResExperiment.bmp"

OpenFile = nameit$ & fname

Open fname For Input As #1: Close
processid = Shell(nameit$ & fname, vbNormalFocus)
OpenFile = ""
Exit Sub

showerror:
MagnetometerShowError.Show
Call MagnetometerShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub Form_Unload(Cancel As Integer)
End
End Sub


Private Sub EarthResOption_Click()
PicPath = 0
If NamedFile(PicPath) <> "No File Selected Yet" Then
Call InputSamples
Label6.Caption = NamedFile(0)
Call SaveDefaults
Else
Label6.Caption = "No File Selected Yet"
End If
MagnetometerDir.PrefixLabel = "Prefixed 'EarthRes '"

MagnetometerFullGrid.Resist.Visible = True
MagnetometerFullGraph.Resist.Visible = True
MagnetometerFullGraph.BlanksFill.Visible = True
MagnetometerFullGraph.Picture1.Cls
MagnetometerFullGraph.GPSvalues.Visible = False
MagnetometerFullGraph.Text1.Text = "0"

End Sub

Public Sub ViewOCXnotes_Click()

fname = InputFile(PicPath)
fname = "MagnetometerOCXnotes.txt"
OpenFile = fname
Open fname For Input As #1: Close
processid = Shell("Notepad " & fname, vbNormalFocus)
OpenFile = ""

Exit Sub

showerror:
MagnetometerShowError.Show
Call MagnetometerShowError.waitresponse
Resume enderror
enderror:

End Sub

Public Sub InputSamples()
If InputFile(PicPath) = "No File Selected Yet" Then
Label6.Caption = "No File Selected Yet"
Label14.Visible = False
Call SaveDefaults
Exit Sub
End If

Label14.Visible = True
Label14.Refresh
Screen.MousePointer = vbHourglass
OrigMaxValue = 0
On Error GoTo showerror
For F = 0 To 127: For D = 0 To 127
FileSamples(0, F, D) = 0: FileSamples(1, F, D) = 0:
Next: Next

For F = 0 To FileDataQty(0): FileData(0, F) = 0: Next
MagnetometerFullGraph.Text1.Text = "0"

OpenFile = InputFile(PicPath): W = 0: ADCmax = 1024: v1 = 5000 / ADCmax:
R1 = 10: Current = 0
MaxLineLen(0) = 0: MaxLineLen(1) = 0
Open InputFile(PicPath) For Input As #1: L = LOF(1)
If L = 0 Then
Beep
Screen.MousePointer = vbDefault
Label14.Visible = False
Label6.Caption = "No File Selected Yet"
InputFile(PicPath) = "No File Selected Yet"
For A = 0 To 20: FileData(0, A) = 0: FileData(1, A) = 0: FileData(2, A) = 0: Next
FileDataQty(0) = 0: FileDataQty(1) = 0: FileDataQty(2) = 0: Text1.Text = 0
MsgBox "This file seems to be empty and input has been aborted", vbExclamation

Close
Exit Sub
End If

splitit = 0
Line Input #1, tempA$
For C = 1 To Len(tempA$): If Mid$(tempA$, C, 1) = "," Then splitit = C: Exit For
Next
Close

A = 0
If PicPath = 1 Then gpslen = 56 + 9 + 9 - 8 Else gpslen = 0

Open InputFile(PicPath) For Input As #1
Min = 65536
getit2: If EOF(1) Then Close: GoTo 50
Line Input #1, tempA$: tempB$ = ""
If splitit <> 6 Then
tempB$ = "": tempA$ = tempA$ & ","
E = 1: For C = 1 To Len(tempA$)
If Mid$(tempA$, C, 1) = "," Then
V = Val(Mid$(tempA$, E)):
tempB$ = tempB$ & Right$("     " & V, 5) & ","
E = C + 1
End If
Next
tempA$ = tempB$
End If

L = Len(tempA$)
If L > gpslen Then
FileData(0, A) = Left$(tempA$, L - gpslen)
FileData(2, A) = Right$(tempA$, gpslen)
If PicPath = 1 Then
tempB$ = Right$(tempA$, gpslen)
If Left$(tempB$, 3) = "aaa" Then tempB$ = "No GPS recorded" & Right$(tempB$, 10)
MagnetometerFullGraph.GPSlist.AddItem A & " " & tempB$
End If
For C = 1 To Len(FileData(0, A)) - 6 Step 6
V = Val(Mid$(FileData(0, A), C, 6))
If V < Min Then Min = V

Next

End If


A = A + 1
If L > MaxLineLen(0) Then MaxLineLen(0) = L
GoTo getit2

50: FileDataQty(0) = A - 1:
If FileDataQty(0) < 1 Then FileDataQty(0) = 1
FileDataQty(2) = A
B = 0

For C = 1 To MaxLineLen(0) Step 6: tempB$ = ""
For A = 0 To FileDataQty(0): tempA$ = FileData(0, A)
If C < Len(tempA$) Then tempC$ = Mid$(tempA$, C, 6) Else tempC$ = "******"
tempB$ = tempB$ & tempC$: Next
FileData(1, B) = tempB$
B = B + 1: L = Len(tempB$): If L > MaxLineLen(1) Then MaxLineLen(1) = L
Next

FileDataQty(1) = B - 1

If PicPath = 1 Then
MagnetometerFullGrid.Text1.Text = Min

sp$ = "                "
End If

Label14.Visible = False
Label14.Refresh
Screen.MousePointer = vbDefault

Exit Sub

showerror:
Screen.MousePointer = vbDefault
Label14.Visible = False
Label14.Refresh
If Err.Number = 6 Then
Beep
Close
tempA$ = "You have found a very large number of " & V & Chr(10) & Chr(13) & Chr(13)
tempA$ = tempA$ & "Are you sure you are loading a true EPE Earth Resistivity or Magnetometer file?" & Chr(10) & Chr(13)
tempA$ = tempA$ & "These have values that are less than 65536 and are separated by commas."
tempA$ = tempA$ & Chr(10) & Chr(13) & Chr(13)
tempA$ = tempA$ & "This file plot has been aborted" & Chr(10) & Chr(13) & Chr(13)
tempA$ = tempA$ & "You may examine the file via the View Data as Text button."
MsgBox tempA$, vbCritical
Resume here
End If

If Err.Number = 68 Or Err.Number = 71 Or Err.Number = 76 Then
ErrorMessage = "Drive not ready for" & Chr(13) & OpenFile
Style = vbRetryCancel + vbExclamation
response = MsgBox(ErrorMessage, Style)
  If response = vbCancel Then
  MagnetometerDirPath(PicPath) = DefaultDrive
  OpenFile = MagnetometerDirPath(PicPath)
  Resume here
here:   Exit Sub
  End If

Resume
  Beep
  End If

MagnetometerShowError.Show
Call MagnetometerShowError.waitresponse
Resume enderror
enderror:
End Sub


