VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{DAD6819A-EF7C-43D3-ADFC-CD12675BD473}#10.0#0"; "EPESERALIO.OCX"
Begin VB.Form Radar 
   Caption         =   "EPE PIC Ultrasonic Radar  V1.0 04AUG04"
   ClientHeight    =   8250
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11880
   DrawWidth       =   2
   Icon            =   "Radar.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   8250
   ScaleMode       =   0  'User
   ScaleWidth      =   12000.61
   StartUpPosition =   2  'CenterScreen
   Begin VB.ListBox List1 
      Height          =   1620
      Left            =   10680
      TabIndex        =   25
      Top             =   4560
      Visible         =   0   'False
      Width           =   1215
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Test"
      Height          =   615
      Left            =   10680
      TabIndex        =   37
      Top             =   6600
      Visible         =   0   'False
      Width           =   495
   End
   Begin VB.Frame Frame4 
      BorderStyle     =   0  'None
      Caption         =   "Frame4"
      Height          =   3015
      Left            =   10680
      TabIndex        =   29
      Top             =   840
      Width           =   735
      Begin VB.OptionButton Option5 
         BackColor       =   &H000000FF&
         Height          =   255
         Index           =   6
         Left            =   120
         TabIndex        =   36
         ToolTipText     =   "Select this colour for scan trace"
         Top             =   2520
         Width           =   255
      End
      Begin VB.OptionButton Option5 
         BackColor       =   &H00000000&
         Height          =   255
         Index           =   5
         Left            =   120
         TabIndex        =   35
         ToolTipText     =   "Select this colour for scan trace"
         Top             =   2160
         Width           =   255
      End
      Begin VB.OptionButton Option5 
         BackColor       =   &H0000FFFF&
         Height          =   255
         Index           =   4
         Left            =   120
         TabIndex        =   34
         ToolTipText     =   "Select this colour for scan trace"
         Top             =   1800
         Width           =   255
      End
      Begin VB.OptionButton Option5 
         BackColor       =   &H0000FF00&
         Height          =   255
         Index           =   3
         Left            =   120
         TabIndex        =   33
         ToolTipText     =   "Select this colour for scan trace"
         Top             =   1440
         Width           =   255
      End
      Begin VB.OptionButton Option5 
         BackColor       =   &H00FFFF00&
         Height          =   255
         Index           =   2
         Left            =   120
         TabIndex        =   32
         ToolTipText     =   "Select this colour for scan trace"
         Top             =   1080
         Width           =   255
      End
      Begin VB.OptionButton Option5 
         BackColor       =   &H00FF0000&
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   31
         ToolTipText     =   "Select this colour for scan trace"
         Top             =   720
         Value           =   -1  'True
         Width           =   255
      End
      Begin VB.OptionButton Option5 
         BackColor       =   &H00FF00FF&
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   30
         ToolTipText     =   "Select this colour for scan trace"
         Top             =   360
         Width           =   255
      End
   End
   Begin MSComctlLib.Slider Slider2 
      Height          =   2655
      Left            =   1560
      TabIndex        =   28
      ToolTipText     =   "Sets scan angle max & min extremes"
      Top             =   4680
      Width           =   630
      _ExtentX        =   1111
      _ExtentY        =   4683
      _Version        =   393216
      Orientation     =   1
      Max             =   24
      TickStyle       =   2
      TickFrequency   =   4
   End
   Begin VB.Frame Frame3 
      BorderStyle     =   0  'None
      Height          =   615
      Left            =   1080
      TabIndex        =   23
      Top             =   1920
      Width           =   1335
      Begin VB.OptionButton Option4 
         Caption         =   "Graph"
         ForeColor       =   &H00C00000&
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   26
         ToolTipText     =   "Displays data as scope waveforms"
         Top             =   360
         Width           =   975
      End
      Begin VB.OptionButton Option4 
         Caption         =   "Circular"
         ForeColor       =   &H00C00000&
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   24
         ToolTipText     =   "Displays scan data as a spoked circle"
         Top             =   120
         Value           =   -1  'True
         Width           =   1095
      End
   End
   Begin VB.Frame Frame2 
      BorderStyle     =   0  'None
      Height          =   705
      Left            =   1080
      TabIndex        =   20
      Top             =   1440
      Width           =   1215
      Begin VB.OptionButton Option3 
         Caption         =   "96 Steps"
         ForeColor       =   &H00C00000&
         Height          =   195
         Index           =   1
         Left            =   120
         TabIndex        =   22
         ToolTipText     =   "Select this option for 96-step motor (3.75 degrees)"
         Top             =   240
         Width           =   975
      End
      Begin VB.OptionButton Option3 
         Caption         =   "48 Steps"
         ForeColor       =   &H00C00000&
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   21
         ToolTipText     =   "Select this option for 48-step motor (7.5 degrees)"
         Top             =   0
         Value           =   -1  'True
         Width           =   975
      End
   End
   Begin VB.Frame Frame1 
      BorderStyle     =   0  'None
      Height          =   615
      Left            =   1200
      TabIndex        =   17
      Top             =   720
      Width           =   1215
      Begin VB.OptionButton Option2 
         Caption         =   "9600 Baud"
         ForeColor       =   &H00C00000&
         Height          =   255
         Index           =   0
         Left            =   0
         TabIndex        =   19
         ToolTipText     =   "Select 9600 Baud rate"
         Top             =   120
         Value           =   -1  'True
         Width           =   1215
      End
      Begin VB.OptionButton Option2 
         Caption         =   "19200 Baud"
         ForeColor       =   &H00C00000&
         Height          =   255
         Index           =   1
         Left            =   0
         TabIndex        =   18
         ToolTipText     =   "Select 19200 Baud rate"
         Top             =   360
         Width           =   1215
      End
   End
   Begin MSComctlLib.Slider Slider1 
      Height          =   7095
      Left            =   360
      TabIndex        =   5
      ToolTipText     =   "Deducts set value from scan value"
      Top             =   840
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   12515
      _Version        =   393216
      Orientation     =   1
      LargeChange     =   1
      Max             =   50
      TickFrequency   =   5
   End
   Begin VB.Timer Timer2 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   10440
      Top             =   120
   End
   Begin VB.CommandButton ScanInput 
      BackColor       =   &H0000FFFF&
      Caption         =   "Input Scan "
      Height          =   495
      Left            =   240
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   "Scan mode start/stop"
      Top             =   240
      Width           =   735
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Port COM 1"
      ForeColor       =   &H00C00000&
      Height          =   255
      Index           =   0
      Left            =   1200
      TabIndex        =   2
      ToolTipText     =   "Selects port COM1 address"
      Top             =   240
      Value           =   -1  'True
      Width           =   1215
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Port COM 2"
      ForeColor       =   &H00C00000&
      Height          =   255
      Index           =   1
      Left            =   1200
      TabIndex        =   1
      ToolTipText     =   "Selects port COM2 address"
      Top             =   480
      Width           =   1215
   End
   Begin EPESerialControl.EPESerial EPESerial1 
      Left            =   11040
      Top             =   120
      _ExtentX        =   926
      _ExtentY        =   926
   End
   Begin VB.PictureBox Picture1 
      Height          =   8000
      Index           =   0
      Left            =   2640
      ScaleHeight     =   1188.764
      ScaleMode       =   0  'User
      ScaleWidth      =   1478.138
      TabIndex        =   0
      Top             =   120
      Width           =   7920
      Begin VB.Line Line1 
         BorderColor     =   &H00404040&
         Index           =   13
         Visible         =   0   'False
         X1              =   473.907
         X2              =   473.907
         Y1              =   17.978
         Y2              =   53.933
      End
      Begin VB.Line Line1 
         Index           =   12
         Visible         =   0   'False
         X1              =   451.34
         X2              =   451.34
         Y1              =   17.978
         Y2              =   71.91
      End
      Begin VB.Line Line1 
         Index           =   11
         Visible         =   0   'False
         X1              =   428.773
         X2              =   428.773
         Y1              =   17.978
         Y2              =   71.91
      End
      Begin VB.Line Line1 
         Index           =   10
         Visible         =   0   'False
         X1              =   406.206
         X2              =   406.206
         Y1              =   17.978
         Y2              =   71.91
      End
      Begin VB.Line Line1 
         Index           =   9
         Visible         =   0   'False
         X1              =   383.639
         X2              =   383.639
         Y1              =   17.978
         Y2              =   89.888
      End
      Begin VB.Line Line1 
         Index           =   8
         Visible         =   0   'False
         X1              =   361.072
         X2              =   361.072
         Y1              =   35.955
         Y2              =   89.888
      End
      Begin VB.Line Line1 
         Index           =   7
         Visible         =   0   'False
         X1              =   338.505
         X2              =   338.505
         Y1              =   35.955
         Y2              =   89.888
      End
      Begin VB.Line Line1 
         Index           =   6
         Visible         =   0   'False
         X1              =   315.938
         X2              =   315.938
         Y1              =   35.955
         Y2              =   125.843
      End
      Begin VB.Line Line1 
         Index           =   5
         Visible         =   0   'False
         X1              =   270.804
         X2              =   270.804
         Y1              =   35.955
         Y2              =   89.888
      End
      Begin VB.Line Line1 
         Index           =   4
         Visible         =   0   'False
         X1              =   225.67
         X2              =   225.67
         Y1              =   0
         Y2              =   341.573
      End
      Begin VB.Line Line1 
         Index           =   3
         Visible         =   0   'False
         X1              =   203.103
         X2              =   203.103
         Y1              =   35.955
         Y2              =   395.506
      End
      Begin VB.Line Line1 
         Index           =   2
         Visible         =   0   'False
         X1              =   157.969
         X2              =   157.969
         Y1              =   0
         Y2              =   395.506
      End
      Begin VB.Line Line1 
         Index           =   1
         Visible         =   0   'False
         X1              =   112.835
         X2              =   112.835
         Y1              =   0
         Y2              =   377.528
      End
      Begin VB.Line Line1 
         Index           =   0
         Visible         =   0   'False
         X1              =   67.701
         X2              =   67.701
         Y1              =   17.978
         Y2              =   215.73
      End
   End
   Begin VB.Shape Shape3 
      BorderColor     =   &H00C0C0C0&
      Height          =   1095
      Left            =   1320
      Shape           =   3  'Circle
      Top             =   3360
      Width           =   975
   End
   Begin VB.Shape Shape2 
      BorderColor     =   &H00800000&
      Height          =   615
      Left            =   1200
      Shape           =   4  'Rounded Rectangle
      Top             =   2640
      Width           =   1215
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      Caption         =   " Markers 2ms approx apart"
      ForeColor       =   &H00C00000&
      Height          =   495
      Left            =   1320
      TabIndex        =   27
      Top             =   2760
      Width           =   975
   End
   Begin VB.Shape Shape1 
      BorderColor     =   &H00C00000&
      BorderWidth     =   2
      Height          =   8055
      Left            =   120
      Shape           =   4  'Rounded Rectangle
      Top             =   120
      Width           =   2415
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   615
      Left            =   1080
      TabIndex        =   4
      Top             =   7320
      Width           =   1335
   End
   Begin VB.Label Label3 
      Caption         =   "50"
      Height          =   255
      Index           =   10
      Left            =   840
      TabIndex        =   16
      Top             =   3360
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "45"
      Height          =   255
      Index           =   9
      Left            =   840
      TabIndex        =   15
      Top             =   3120
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "40"
      Height          =   255
      Index           =   8
      Left            =   840
      TabIndex        =   14
      Top             =   2880
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "35"
      Height          =   255
      Index           =   7
      Left            =   840
      TabIndex        =   13
      Top             =   2640
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "30"
      Height          =   255
      Index           =   6
      Left            =   840
      TabIndex        =   12
      Top             =   2400
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "25"
      Height          =   255
      Index           =   5
      Left            =   840
      TabIndex        =   11
      Top             =   2160
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "20"
      Height          =   255
      Index           =   4
      Left            =   840
      TabIndex        =   10
      Top             =   1920
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "15"
      Height          =   255
      Index           =   3
      Left            =   840
      TabIndex        =   9
      Top             =   1680
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "10"
      Height          =   255
      Index           =   2
      Left            =   840
      TabIndex        =   8
      Top             =   1440
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "5"
      Height          =   255
      Index           =   1
      Left            =   840
      TabIndex        =   7
      Top             =   1200
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "0"
      Height          =   255
      Index           =   0
      Left            =   840
      TabIndex        =   6
      Top             =   960
      Width           =   135
   End
End
Attribute VB_Name = "Radar"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' PIC ULTRASONIC RADAR 04AUG04
' this is experimental software and you are encouraged to experiment with the display

Private Sub Form_Load()

OCXport = 1: Option1(OCXport - 1).Value = True
BaudRate = 0: Option2(BaudRate) = True
StepAngle = 0: Option3(StepAngle) = True
B = Slider1.Top + 100: C = Slider1.Left + Slider1.Width

D = 670
For A = 0 To 10: Label3(A).Top = B: Label3(A).Left = C: B = B + D: Next

For A = 0 To 6
If Option5(A).Value = True Then ColourTrace = Option5(A).BackColor: Exit For
Next

Radar.Show

Picture1(0).Cls
Picture1(0).Width = 8000
Picture1(0).ScaleWidth = 2000
Picture1(0).ScaleHeight = 2000
T = Picture1(0).ScaleHeight \ 2
B = 80
For A = 0 To 12
Picture1(0).Circle (T, T), (A + 1) * B, vbBlack
Next

Picture1(0).Line (T, T)-(T, 2 * T), vbBlack

B = 170
For A = 0 To 12
Line1(A).Visible = False
Line1(A).X1 = (A + 1) * B
Line1(A).X2 = (A + 1) * B
Line1(A).Y1 = 0
Line1(A).Y2 = Picture1(0).Height
Next

OpenFile = "An unknown problem exists right at the start of loading Radar.EXE"
On Error GoTo FatalError: 'set error handler

newuser = 0:
ErrorMessage$ = "This error has been intercepted by the PC System, not by the Radar program."
ErrorMessage$ = ErrorMessage$ & "If the problem persists please report its details and circumstances of it occurring to John Becker at EPE"
DefaultError$ = ErrorMessage$

On Error GoTo SettingsError
OpenFile = "Cannot find RadarSettings.txt"
Open "RadarSettings.txt" For Input As #1: Close

GetSettings:

Open "RadarSettings.txt" For Input As #1
Line Input #1, tempA$: ' current directory - info not used in prog
Line Input #1, tempA$: OCXport = Val(tempA$)
Line Input #1, tempA$: BaudRate = Val(tempA$)
Line Input #1, tempA$: StepAngle = Val(tempA$)

If OCXport = 0 Then OCXport = 1
Option1(OCXport - 1).Value = True
Option2(BaudRate).Value = True
Option3(StepAngle).Value = True

Select Case StepAngle
Case 0: MotorSteps = 48: Slider2.Value = 24
Case 1: MotorSteps = 96: Slider2.Value = 48
End Select

Close

On Error GoTo NewUserError: 'set error handler used to check if prog has been run before
Open "ClearRadar.txt" For Input As #1: Close
On Error GoTo 0

Exit Sub

'.............

NewUserError:
Close: Open "ClearRadar.txt" For Output As #2
Print #2, "Radar first loaded " & Date$ & " " & Time$: Close
newuser = 1
Close:

Call SaveDefaults

SettingsError:
Close: Call SaveDefaults
Resume Next

showerror:
Close: Call RadarShowError.waitresponse
Resume enderror
enderror:
Exit Sub

FatalError:
Beep
tempB$ = "A non-recoverable error has occurred during program loading and involves the following Earth Resistivity generated statement:"
tempB$ = tempB$ & Chr(13) & Chr(13) & OpenFile
tempB$ = tempB$ & Chr(13) & Chr(13) & "Please check that all the Radar files are in the same folder (directory) as the program you are now trying to run. The folder must be on the Hard Drive."
tempB$ = tempB$ & Chr(13) & Chr(13) & "If the data is corrupted re-copy the file of the same name from your original disk or FTP download."
tempB$ = tempB$ & Chr(13) & Chr(13) & "If you cannot resolve the problem please advise John Becker of the details via the EPE Editorial Office (not via the Chat Zone)."
tempB$ = tempB$ & Chr(13) & Chr(13) & "The loading has been aborted and you will be returned to the previous screen."
MsgBox tempB$, vbCritical
End

End Sub

Public Sub SaveDefaults()
Close: Open "RadarSettings.txt" For Output As #2
Print #2, CurDir
Print #2, OCXport & " OCX port value"
Print #2, BaudRate & " Baud Rate index"
Print #2, StepAngle & " Step Angle index"
Close
End Sub


Private Sub Option1_Click(Index As Integer)
OCXport = Index + 1
Call SaveDefaults
End Sub

Private Sub Option2_Click(Index As Integer)
BaudRate = Index
Call SaveDefaults
End Sub

Private Sub Option3_Click(Index As Integer)
StepAngle = Index
Select Case StepAngle
Case 0: MotorSteps = 48: Slider2.Value = 0: Slider2.Max = 24: Slider2.Value = 24
Case 1: MotorSteps = 96: Slider2.Value = 0: Slider2.Max = 48: Slider2.Value = 48
End Select

For A = 0 To 128: For B = 0 To 98
PlotVal(A, B) = 0: Next: Next

Call SaveDefaults
End Sub

Private Sub Option4_Click(Index As Integer)
DisplayArea = Index

For A = 0 To 128: For B = 0 To 98
PlotVal(A, B) = 0: Next: Next

Select Case DisplayArea

Case 0:
Picture1(0).Cls
Picture1(0).Width = 8000
Picture1(0).ScaleWidth = 2000
Picture1(0).ScaleHeight = 2000
T = Picture1(0).ScaleHeight \ 2
Frame4.Visible = True
For A = 0 To 12: Line1(A).Visible = False: Next
Picture1(0).Refresh

Picture1(0).Line (T, T)-(T, 2 * T), black

B = 80
For A = 0 To 12: Picture1(0).Circle (T, T), (A + 1) * B, vbBlack: Next

Case 1:
Picture1(0).Cls
Picture1(0).Width = 9200
Picture1(0).ScaleWidth = 2000
Picture1(0).ScaleHeight = 2000
T = Picture1(0).ScaleHeight \ 2
Frame4.Visible = False
For A = 0 To 12: Line1(A).Visible = True: Next
End Select

End Sub

Private Sub Option5_Click(Index As Integer)
ColourTrace = Option5(Index).BackColor
Call Slider2_Change
End Sub

Private Sub ScanInput_Click()
If Timer2.Enabled = False Then
PI = 22 / 7: Angle = 0

List1.Clear
Select Case DisplayArea

Case 0:
Picture1(0).Cls
Picture1(0).Width = 8000
Picture1(0).ScaleWidth = 2000
Picture1(0).ScaleHeight = 2000
T = Picture1(0).ScaleHeight \ 2
Slider2.Visible = False

For A = 0 To 12: Line1(A).Visible = False: Next
Picture1(0).Refresh

Picture1(0).Line (T, T)-(T, 2 * T), black

B = 80
For A = 0 To 12: Picture1(0).Circle (T, T), (A + 1) * B, vbBlack: Next

Case 1:
Picture1(0).Cls
Picture1(0).Width = 9200
Picture1(0).ScaleWidth = 2000
Picture1(0).ScaleHeight = 2000
T = Picture1(0).ScaleHeight \ 2
For A = 0 To 12: Line1(A).Visible = True: Next
Slider2.Visible = False

End Select

ScanInput.Caption = "Stop"

If Option1(0).Value = False Then Option1(0).Enabled = False
If Option1(1).Value = False Then Option1(1).Enabled = False
If Option2(0).Value = False Then Option2(0).Enabled = False
If Option2(1).Value = False Then Option2(1).Enabled = False
If Option3(0).Value = False Then Option3(0).Enabled = False
If Option3(1).Value = False Then Option3(1).Enabled = False
If Option4(0).Value = False Then Option4(0).Enabled = False
If Option4(1).Value = False Then Option4(1).Enabled = False

Label1.Caption = ""
Refresh
Call StartTest

Else

ScanInput.Caption = "Wait"
ScanInput.BackColor = &HFF&
ScanInput.Refresh
Timer2.Enabled = False

A = Timer + 3
100: If Timer < A Then GoTo 100: ' 3 secs pause to allow PIC to reach time-out

ScanInput.BackColor = &HFFFF&
ScanInput.Caption = "Input Scan "

Option1(0).Enabled = True
Option1(1).Enabled = True
Option2(0).Enabled = True
Option2(1).Enabled = True
Option3(0).Enabled = True
Option3(1).Enabled = True
Option4(0).Enabled = True
Option4(1).Enabled = True
Slider2.Visible = True

End If

End Sub

Public Sub StartTest()
    On Error GoTo ErrorHandler
    Dim bError                          As Boolean
    Dim sDataBlock                      As String
    Dim A, B, C, D, E, F, L As Long

    bError = False
    
    With EPESerial1
        .RxBlockSize = 1
        .RxMode = sioBlockMode
        .ComPort = OCXport
        .Speed = sio9600       ' Setup the COM port parameters
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False       ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 2            ' PIC must always respond within 2 second
        .ClearReceiveBuffer     ' Always do this after we open the port to make sure the buffer is really empty
   
        .PortStatus = sioPortOpen

        tempA$ = Chr((StepAngle + 4))
        .SendText tempA$

sDataBlock = .ReceiveText
        tempA$ = Chr((Slider2.Value * 8 + 7))
        tempB$ = tempA$
        .SendText tempA$

sDataBlock = .ReceiveText
tempc$ = sDataBlock

        tempA$ = Chr(BaudRate)
        .SendText tempA$
sDataBlock = .ReceiveText
        
        .ClearReceiveBuffer
        Select Case BaudRate
        Case 0: .Speed = sio9600
        Case 1: .Speed = sio19200
        End Select

        .PortStatus = sioPortClosed

Timer2.Enabled = True

End With
   
   With EPESerial1
        .RxBlockSize = 98
        .RxMode = sioBlockMode
        .ComPort = OCXport
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False       ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 2            ' PIC must always respond within 2 second
        .ClearReceiveBuffer     ' Always do this after we open the port to make sure the buffer is really empty
        Exit Sub
        
ErrorHandler:
        Close
        Beep
    tempA$ = "A data exchange error has occured" & Chr(10) & Chr(13) & "Check your interconnections and try again"
    MsgBox tempA$, vbOKOnly + vbCritical
    On Error Resume Next ' We don't want to know about any further errors
    EPESerial1.PortStatus = sioPortClosed
    ScanInput.Caption = "Input Scan "
    Timer2.Enabled = False
Option1(0).Enabled = True
Option1(1).Enabled = True
Option2(0).Enabled = True
Option2(1).Enabled = True
Option3(0).Enabled = True
Option3(1).Enabled = True
Option4(0).Enabled = True
Option4(1).Enabled = True
    
End With

End Sub

Private Sub Slider1_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
ScanInput.SetFocus
End Sub

Private Sub Slider2_Change()
PI = 22 / 7

F = Shape3.Height / 2
X1 = Shape3.Left + (Shape3.Width / 2)
Y1 = Shape3.Top + (Shape3.Height / 2)
For C = 180 To 1 Step -1 '-0.5
E = Slider2.Max / (Slider2.Value + 0.001)
E = 180 / E
Angle = C
D = Int(Angle) \ 90
H = F - 2
A = Angle
A = A - 90
B = Sin(A * (PI / 180)): Y = B * H
X = (Sqr((H ^ 2) - (Y ^ 2)))
If D = 2 Or D = 3 Then X = -X
If E < C Then ColB = &H8000000F Else ColB = ColourTrace ' vbRed

Line (X1, Y1)-(X1 + X, Y1 + Y), ColB
Line (X1, Y1)-(X1 - X, Y1 + Y), ColB
Next
Line (X1, Y1)-(X1, Y1 + Y), ColourTrace

End Sub


Private Sub Timer2_Timer()
Select Case DisplayArea
Case 0: Call ReceiveCircleData
Case 1: Call ReceiveGraphData
End Select

End Sub

Private Sub Form_Unload(Cancel As Integer)
Close: End
End Sub

Private Sub Command2_Click()
FName = "Store.txt"
processid = Shell("Notepad " & FName, vbNormalFocus)
End Sub

Private Sub ReceiveCircleData()
   With EPESerial1
        .PortStatus = sioPortOpen
        .SendText "G" ' Go ' Tell the PIC to send next
   sDataBlock = .ReceiveText
        .PortStatus = sioPortClosed
   If sDataBlock <> "" Then
   GoSub Showgraph
       If ConnectionFlag = 1 Then
   Label1.Caption = ""
   ConnectionFlag = 0
   End If

   Else
If ConnectionFlag = 0 Then
   Label1.Caption = "Data lost at " & Time$
   Label1.Visible = True
   ConnectionFlag = 1
   Call ScanInput_Click
   Exit Sub
   End If
End If
   End With
Exit Sub
    
Showgraph:
 
If Timer2.Enabled = False Then Exit Sub

V = 1 * (PI / 180): ' Y = B * H
V = Abs(V) '* 3

For C = 1 To 97
If Asc(Mid$(sDataBlock, C, 1)) = 255 Then
sDataBlock = Mid$(sDataBlock, C + 1) & Left$(sDataBlock, C - 1): Exit For
End If
Next

Angle = Asc(Mid$(sDataBlock, 1, 1))
If Slider2.Value = 0 Then Angle = (MotorSteps - 2) / 2

F = (Picture1(0).ScaleWidth / 95) / 2

For C = 2 To 97: ' clear prev trace
H = C * F
A = Angle * (360 / MotorSteps)
G = A * (PI / 180)
A = A - 90 + 7 '3.5
B = Sin(A * (PI / 180)): Y = B * H
X = Sqr((H ^ 2) - (Y ^ 2))
If A < 90 Or A > 270 Then X = -X

D = PlotVal(Angle, C)

'****** orig line
If D > 0 Then Picture1(0).Line (T + X - D, T - Y - D)-(T + X + D, T - Y + D), &H8000000F, BF
' ******

'****** alternative lines maybe worth experimenting with
'If D > 0 Then Picture1(0).Circle (T + X, T - Y), D, &H8000000F ', G + (V * 0.2), G + V
'If D > 0 Then Picture1(0).Circle (T + X, T - Y), D, &H8000000F, G + (V * 0.2), G + V
' *******

Next

' *************

For C = 2 To 97: ' draw new trace
A1 = (Asc(Mid$(sDataBlock, C, 1)) - Slider1.Value)
H = C * F
A = Angle * (360 / MotorSteps):
G = A * (PI / 180)

A = A - 90 + 7
B = Sin(A * (PI / 180)): Y = B * H:
X = Sqr((H ^ 2) - (Y ^ 2))
If A < 90 Or A > 270 Then X = -X

If A1 < 0 Then A1 = 0
If A1 > 15 Then A1 = 15

' ******** orig line
If A1 > 0 Then Picture1(0).Line (T + X - A1, T - Y - A1)-(T + X + A1, T - Y + A1), ColourTrace, BF
' ***********

'****** alternative lines maybe worth experimenting with
'If A1 > 0 Then Picture1(0).Circle (T + X, T - Y), A1, vbRed', G + (V * (A1 / 10)), G + V
'If A1 > 0 Then Picture1(0).Circle (T + X, T - Y), A1, vbRed, G + (V * (A1 / 10)), G + V
' **********

PlotVal(Angle, C) = A1 ' store current value for use when clearing previous
Next

Picture1(0).Line (T, T)-(T, 2 * T), vbBlack

B = 80
For A = 0 To 12: Picture1(0).Circle (T, T), (A + 1) * B, vbBlack: Next

Return

End Sub

Private Sub ReceiveGraphData()

   With EPESerial1
        .PortStatus = sioPortOpen
        .SendText "G" ' Go ' Tell the PIC to send next
   sDataBlock = .ReceiveText
        .PortStatus = sioPortClosed
   If sDataBlock <> "" Then
   GoSub Showgraph
       If ConnectionFlag = 1 Then
   Label1.Caption = ""
   ConnectionFlag = 0
   End If

   Else
If ConnectionFlag = 0 Then
   Label1.Caption = "Data lost at " & Time$
   Label1.Visible = True
   ConnectionFlag = 1
   End If
End If
   End With
Exit Sub
    
Showgraph:
 
If Timer2.Enabled = False Then Exit Sub
F = (Picture1(0).ScaleWidth / 95)

For C = 1 To 97
If Asc(Mid$(sDataBlock, C, 1)) = 255 Then
sDataBlock = Mid$(sDataBlock, C + 1) & Left$(sDataBlock, C - 1): Exit For
End If
Next

Angle = Asc(Mid$(sDataBlock, 1, 1))
V = (Angle + 2) * (Picture1(0).ScaleHeight \ (MotorSteps + 2))

Picture1(0).PSet (0, V), &H8000000F: H = 0
For C = 2 To 97: ' clear prev trace
D = PlotVal(Angle, C): Picture1(0).Line -(H, D), &H8000000F
H = H + F
Next

Picture1(0).PSet (0, V), ColourTrace: H = 0
For C = 2 To 97: ' draw new trace
A1 = Asc(Mid$(sDataBlock, C, 1)) - Slider1.Value
Picture1(0).Line -(H, V - A1), ColourTrace
H = H + F: PlotVal(Angle, C) = V - A1
Next

For A = 0 To 12: Line1(A).Refresh: Next
Return

End Sub

Private Sub Command1_Click()
V = 1 * (PI / 180)
V = Abs(V) * 3

List1.Clear
List1.AddItem V
Picture1(0).Cls

For Angle = 1 To 360 Step (360 / 48)
A = Angle:
B = (A * (PI / 180))
T = Picture1(0).ScaleHeight \ 2
B = Abs(B)
Picture1(0).Circle (T, T), 200, vbRed, B + (V * 0.2), B + V
Next

End Sub

