; TK3TUT40.ASM 29DEC02 - JOHN BECKER - EPE PIC TUTOR V2
                 
; EEPROM USE DETAILS  - PIC16F87x FAMILY

; THIS PROGRAM IS INCAPABLE OF BEING RUN AS IT STANDS
; IT NEEDS OTHER ROUTINES TO ACCESS IT
             
; it just shows the codes needed for eeprom data write and read
               
; obligatory initialisation of variables for eeprom read/write operation:

PIR1     EQU H'0C'  ; Bank 0
EEDATA   EQU H'1A'  ; Bank 1
EEADR    EQU H'1B'  ; Bank 1
EECON1   EQU H'1C'  ; Bank 1
EECON2   EQU H'1D'  ; Bank 1

WREN     EQU 2      ; EECON1 reg EEPROM write enable flag
EEIF     EQU 7      ; PIR2 reg
RD       EQU 0      ; EECON1 reg EEPROM read enable flag
WR       EQU 1      ; EECON1 reg EEPROM write initiate flag

PROMVAL  EQU H'70'  ; accessed via Bank 0 and Bank 1

; Note that PROMVAL is required to be accessed via both BANK0 and BANK1.
; It needs to be EQUated to occur at a location between H'70' and H'7F'.
; These locations are automatically accessible via any of four BANKs,
; unlike the "normal" locations between H'20' and H'6F' (see Figure 4.3 in
; the PIC16F62x data sheet).

; WRITE DATA TO EEPROM ROUTINE:

; This routine is entered with W holding the EEPROM byte address at which
; data is to be stored. The data to be stored is held in PROMVAL, which is
; located in both Banks at or above H'70'

SETPRM  BANK1
        MOVWF EEADR     ; copy W into EEADR to set EEPROM address
        MOVF PROMVAL,W  ; get data value from PROMVAL and hold in W
        MOVWF EEDATA    ; copy W into EEPROM data byte register
        BSF EECON1,WREN ; enable write flag

MANUAL  MOVLW H'55'     ; these lines cause the action required by
        MOVWF EECON2    ; by the EEPROM to store the data in EEDATA
        MOVLW 'AA'      ; at the address held by EEADR.
        MOVWF EECON2
        BSF EECON1,WR   ; set the ``perform write'' flag
        BANK0

CHKWRT  BTFSS PIR1,EEIF ; wait until bit 4 of PIR2 is set
        GOTO CHKWRT
        BCF PIR1,EEIF   ; clear bit 4 of PIR2
        RETURN

; READING FROM DATA EEPROM ROUTINE

; This routine is entered with W holding the EEPROM byte address to be read.
; The read-back value is then held in W on exit.

GETPRM  BANK1
        MOVWF EEADR     ; copy W into EEADR to set EEPROM address
        BSF EECON1,RD   ; enable read flag
        MOVF EEDATA,W   ; read EEPROM data now in EEDATA into W
        BANK0
        RETURN


