; TK3TUT39.ASM 29DEC02 - JOHN BECKER - EPE PIC TUTOR V2
                 
; EEPROM USE DETAILS  - PIC16F87x FAMILY

; THIS PROGRAM IS INCAPABLE OF BEING RUN AS IT STANDS
; IT NEEDS OTHER ROUTINES TO ACCESS IT
             
; it just shows the codes needed for eeprom data write and read
               
; obligatory initialisation of variables for eeprom read/write operation:

EEDATA          EQU H'0C'  ; Bank 2
EECON1          EQU H'0C'  ; Bank 3
PIR2            EQU H'0D'  ; Bank 0
EEADR           EQU H'0D'  ; Bank 2
EECON2          EQU H'0D'  ; Bank 3
STATUS          EQU 3      ; STATUS register
W               EQU 0      ; Working register flag
RP0             EQU 5      ; STATUS bank reg
RP1             EQU 6      ; STATUS bank reg
RD              EQU 0      ; EECON1 reg
EEPGD           EQU 7      ; EECON1 reg
EEIF            EQU 4      ; PIR2 reg
WR              EQU 1      ; EECON1 reg
WREN            EQU 2      ; EECON1 reg
STORE1          EQU H'20'  ; or any convenient address

; WRITE DATA TO EEPROM ROUTINE:
                 
; This routine is entered with W holding the eeprom byte address at which
; data is to be stored. The data to be stored is held in STORE1.

SETPRM   BSF STATUS,RP1   ; set for Bank 2
         BCF STATUS,RP0
         MOVWF EEADR      ; copy W into EEADR to set EEPROM address
         BCF STATUS,RP1   ; set for Bank 0
         MOVF STORE1,W    ; get data value from STORE1 and hold in W
         BSF STATUS,RP1   ; set for Bank 2
         MOVWF EEDATA     ; copy W into EEPROM data byte register
         BSF STATUS,RP0   ; set for Bank 3
         BCF EECON1,EEPGD ; point to Data memory
         BSF EECON1,WREN  ; enable write flag

MANUAL   MOVLW H'55'      ; these lines cause the action required by
         MOVWF EECON2     ; by the EEPROM to store the data in EEDATA
         MOVLW H'AA'      ; at the address held by EEADR.
         MOVWF EECON2
         BSF EECON1,WR    ; set the ``perform write'' flag
         BCF STATUS,RP1   ; set for Bank 0
         BCF STATUS,RP0

CHKWRT   BTFSS PIR2,EEIF ; wait until bit 4 of PIR2 is set
         GOTO CHKWRT
         BCF PIR2,EEIF   ; clear bit 4 of PIR2
         RETURN

; READING FROM DATA EEPROM ROUTINE

; This routine is entered with W holding the EEPROM byte address to be read.
; The read-back value is then held in W on exit.

PRMGET   BSF STATUS,RP1   ; set for Bank 2
         BCF STATUS,RP0
         MOVWF EEADR      ; copy W into EEADR to set EEPROM address
         BSF STATUS,RP0   ; set for Bank 3
         BCF EECON1,EEPGD ; point to data memory
         BSF EECON1,RD    ; enable read flag
         BCF STATUS,RP0   ; set for Bank 2
         MOVF EEDATA,W    ; read EEPROM data now in EEDATA into W
         BCF STATUS,RP1   ; set for Bank 0
         RETURN
