; TK3TUTADC.INC 15FEB03 - JOHN BECKER - EPE PIC TUTOR V2
; illustrating use of ADC

#DEFINE CHAN0 iorlw B'00000000'
#DEFINE CHAN1 iorlw B'00001000'
#DEFINE CHAN2 iorlw B'00010000'
#DEFINE CHAN3 iorlw B'00011000'
#DEFINE CHAN4 iorlw B'00100000'
#DEFINE CHAN5 iorlw B'00101000'
#DEFINE CHAN6 iorlw B'00110000'
#DEFINE CHAN7 iorlw B'00111000'
                 
        CBLOCK
ADCMSB
ADCLSB
        ENDC

; *********** EXAMPLE OF SETTING PORTA FOR ANALOGUE ***********

                BLOCK0
                BANK1
                clrf TRISB              ; PORTB as output
                clrf TRISC              ; PORTC as output
                clrf TRISD              ; PORTD as output
                clrf TRISE              ; PORTE as output
                movlw B'10000100'       ; set RHS justify, RA0, RA1, RA3 as analog inputs
                movwf ADCON1            ; with RA, RE digital, ref to +VE and 0V
                movlw B'11011011'       ; RA0, RA1, RA3, RA4 as input, RA2, RA5 as output
                movwf TRISA
                movlw B'10000110'       ; timer 1:64 (1/50th sec), pull-ups on
                movwf OPTION_REG        ; (light pull-ups off - bit 7 high)
                BANK0

; *********** EXAMPLE OF SETTING ADC CHANNEL AND READING ITS VALUE *****

                movlw B'10000001'       ; set AD on, Fosc/32
                CHAN0                   ; set for CHAN0 - RA0
                movwf ADCON0
                call DELAYB             ; short delay following channel change
                bsf ADCON0,GO           ; start data conversion
                call GETADC             ; get ADC value
                return

; ******** GET ADC VALUE FROM SELECTED PORT PIN *****

GETADC          btfsc ADCON0,GO
                goto GETADC
                movf ADRESH,W           ; get ADC MSB val
                movwf ADCMSB            ; store it into ADCMSB
                BANK1
                movf ADRESL,W           ; get ADC LSB val
                BANK0
                movwf ADCLSB            ; store it into ADCLSB
                return

; ******* SHORT DELAY SUITABLE FOR 4MHz OPERATION *******

DELAYB:         nop
                nop
                nop
                nop
                nop
                nop
                nop
                return
