; TK3TUT7.ASM 22DEC02 - JOHN BECKER - EPE PIC TUTOR V2
                 
; the use of loops while checking zero status
; illustrating both down and up counts

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
                 
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
COUNT           EQU H'20'               ; name location H'20' as variable called COUNT

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5
                 
                clrf PORTA              ; clear Port A data register
                clrf PORTB              ; clear Port B data register
                BANK1                   ; BANK 1
                clrf TRISA              ; Port A direction register for output
                clrf TRISB              ; Port B direction register for output
                BANK0                   ; BANK 0

BEGIN           clrf COUNT              ; set COUNT to zero

					; UP COUNT
LOOP1           movf COUNT,W            ; load the value of COUNT into Working register
                movwf PORTB             ; set Port B to the value of COUNT
                incfsz COUNT,F          ; increment (add 1 to) the value of COUNT and check
                                        ; if it has reached zero (rolled over from 255 to 0)
                goto LOOP1              ; this command is actioned only if COUNT is not yet 0
                                        ; the program jumping back to the address called LOOP1
                                        ; if COUNT has reached zero, the next routine starting
                                        ; at address LOOP2 is begun
                 
                                        ; DOWN COUNT
LOOP2           movf COUNT,W            ; load the value of COUNT into Working register
                movwf PORTB             ; set Port B to the value of COUNT
                decfsz COUNT,F          ; decrement (subtract 1 from) the value of COUNT and
                                        ; check if it has reached zero
                goto LOOP2              ; this command is actioned only if COUNT is not yet 0
                                        ; the program jumping back to address LOOP2
                goto LOOP1              ; this command is actioned only if COUNT has become
                                        ; zero, in which case the program jumps back to LOOP1
                 
                end                     ; final statement
