; TK3TUT44.ASM 29DEC02 - JOHN BECKER - EPE PIC TUTOR V2
; illustrating use of ADC, decimal conversion and output to LCD

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
#DEFINE BLOCK0 BCF STATUS,7             ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF STATUS,7             ; set   STATUS bit 7 (IRP)

        List P = PIC16F877, R=DEC; 
        __CONFIG   h'3F31'

INDF            EQU H'00'               ; Bank 0, 1, 2, 3
TMR0            EQU H'01'               ; Bank 0, 2
OPTION_REG      EQU H'01'               ; Bank 1, 3
PCL             EQU H'02'               ; Bank 0, 1, 2, 3
STATUS          EQU H'03'               ; Bank 0, 1, 2, 3
FSR             EQU H'04'               ; Bank 0, 1, 2, 3

PORTA           EQU H'05'               ; Bank 0
TRISA           EQU H'05'               ; Bank 1
PORTB           EQU H'06'               ; Bank 0, 2
TRISB           EQU H'06'               ; Bank 1, 3
PORTC           EQU H'07'               ; Bank 0
TRISC           EQU H'07'               ; Bank 1
PORTD           EQU H'08'               ; Bank 0
TRISD           EQU H'08'               ; Bank 1
PORTE           EQU H'09'               ; Bank 0
TRISE           EQU H'09'               ; Bank 1

PCLATH          EQU H'0A'               ; Bank 0, 1, 2, 3
INTCON          EQU H'0B'               ; Bank 0, 1, 2, 3
PIR1            EQU H'0C'               ; Bank 0
PIE1            EQU H'0C'               ; Bank 1
EEDATA          EQU H'0C'               ; Bank 2
EECON1          EQU H'0C'               ; Bank 3
PIR2            EQU H'0D'               ; Bank 0
EEADR           EQU H'0D'               ; Bank 2
EECON2          EQU H'0D'               ; Bank 3
TMR1L           EQU H'0E'               ; Bank 0
TMR1H           EQU H'0F'               ; Bank 0
T1CON           EQU H'10'               ; Bank 0
CCP1CON         EQU H'17'               ; Bank 0

RCSTA           EQU H'18'               ; Bank 0
TXSTA           EQU H'18'               ; Bank 1
TXREG           EQU H'19'               ; Bank 0
SPBRG           EQU H'19'               ; Bank 1
ADRESH          EQU H'1E'               ; Bank 0
ADRESL          EQU H'1E'               ; Bank 1
ADCON0          EQU H'1F'               ; Bank 0
ADCON1          EQU H'1F'               ; Bank 1
                 
LOOP            EQU H'20'               ; loop counter 1 - general
LOOPA           EQU H'21'               ; loop counter 2 - LCD use only
CLKCNT          EQU H'22'               ; 1/25 secs counter
STORE           EQU H'23'               ; general store
RSLINE          EQU H'24'               ; bit 4 RS line flag for LCD

COUNT0          EQU H'28'               ; lsb of binary value to be converted
COUNT1          EQU H'29'               ; nsb of binary value to be converted
COUNT2          EQU H'2A'               ; msb of binary value to be converted
DIGIT1          EQU H'2B'               ; lsd digital conversion
DIGIT2          EQU H'2C'
DIGIT3          EQU H'2D'
DIGIT4          EQU H'2E'
DIGIT5          EQU H'2F'
DIGIT6          EQU H'30'
DIGIT7          EQU H'31'
DIGIT8          EQU H'32'               ; msd digital conversion
BITCNT          EQU H'33'               ; counter for the number of bits processed
DIGCNT          EQU H'34'               ; counter for the number of digits processed
ADCMSB          EQU H'35'
ADCLSB          EQU H'36'
CLKADD		EQU H'37'
CHAN0           EQU H'38'
CHAN1           EQU H'39'
CHAN2           EQU H'3A'
CHAN3           EQU H'3B'
CHAN4           EQU H'3C'
CHAN5           EQU H'3D'
CHAN6           EQU H'3E'
CHAN7           EQU H'3F'
STORE1          EQU H'40'


W               EQU 0
F               EQU 1
C               EQU 0
DC              EQU 1 
Z               EQU 2
GO              EQU 2                   ; ADCON0 reg

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                clrf PORTC
                clrf PORTD
                clrf PORTE

                BLOCK0
                BANK1
                clrf TRISB              ; PORTB as output
                clrf TRISC              ; PORTC as output
                clrf TRISD              ; PORTD as output
                clrf TRISE              ; PORTE as output
                movlw B'10000100'       ; set RHS justify, RA0, RA1, RA3 as analog inputs
                movwf ADCON1            ; with RA, RE digital, ref to +VE and 0V
                movlw B'11011011'       ; RA0, RA1, RA3, RA4 as input, RA2, RA5 as output
                movwf TRISA
                movlw B'10000110'       ; timer 1:64 (1/50th sec), pull-ups on
                movwf OPTION_REG        ; (light pull-ups off - bit 7 high)
                BANK0

                goto SETUP              ; bypass tables
                 
TABLCD          addwf PCL,F             ; LCD initialisation table
                retlw B'00110011'       ; initialise lcd - first byte
                retlw B'00110011'       ; 2nd byte (repeat of first)
                retlw B'00110010'       ; set for 4-bit operation
                retlw B'00101100'       ; set for 2 lines
                retlw B'00000110'       ; set entry mode to increment each address
                retlw B'00001100'       ; set display on, cursor off, blink off
                retlw B'00000001'       ; clear display
                retlw B'00000010'       ; return home, cursor & RAM to zero
                                        ; end initialisation table

SETUP           call PAUSIT             ; perform first 1/5th sec delay
                 
LCDSET          clrf LOOP               ; clr LCD set-up loop
                clrf RSLINE             ; clear RS line for instruction send
LCDST2          movf LOOP,W             ; get table address
                call TABLCD             ; get set-up instruction
                call LCDOUT             ; perform it
                incf LOOP,F             ; inc loop
                btfss LOOP,3            ; has last LCD set-up instruction now been done?
                goto LCDST2             ; no
                call PAUSIT             ; yes, perform second 1/5th sec delay
                                        ; to allow final LCD command to occur
                                        ; (it takes longer than the rest)

                movlw B'00000000'
                movwf CHAN0
                movlw B'00001000'
                movwf CHAN1
                movlw B'00010000'
                movwf CHAN2
                movlw B'00011000'
                movwf CHAN3
                movlw B'00100000'
                movwf CHAN4
                movlw B'00101000'
                movwf CHAN5
                movlw B'00110000'
                movwf CHAN6
                movlw B'00111000'
                movwf CHAN7

MAIN            btfss INTCON,2          ; has a timer time-out been detected?
                goto MAIN               ; no
                bcf INTCON,2            ; yes

                movlw B'10000001'       ; set AD on, Fosc/32
                iorwf CHAN0,W           ; set for CHAN0 - RA0
                movwf ADCON0
	        call DELAYB
                bsf ADCON0,GO           ; start data conversion
                call GETADC
                movlw B'10000000'       ; set LCD screen address
                call LCDLIN

                call SHOWVAL

                movlw B'10000001'       ; set AD on, Fosc/32
                iorwf CHAN1,W           ; set for CHAN1 - RA1
                movwf ADCON0
	        call DELAYB
                bsf ADCON0,GO           ; start data conversion
                call GETADC
                movlw B'11000000'       ; set LCD screen address
                call LCDLIN
                call SHOWVAL
                goto MAIN

GETADC          btfsc ADCON0,GO
                goto GETADC
                movf ADRESH,W           ; get ADC MSB val
                movwf ADCMSB
                BANK1
                movf ADRESL,W           ; get ADC LSB val
                BANK0
                movwf ADCLSB
                return

SHOWVAL
                movlw ' '
                call LCDOUT
                movlw 'C'
                call LCDOUT
                movlw 'H'
                call LCDOUT
                movlw 'A'
                call LCDOUT
                movlw 'N'
                call LCDOUT
                movlw ' '
                call LCDOUT

                rrf ADCON0,W            ; divide ADCON0 by 8 to get Chan
                movwf STORE1
                rrf STORE1,F
                rrf STORE1,W
                andlw 15
                iorlw 48
                call LCDOUT

                movf ADCMSB,W
                movwf COUNT1
                movf ADCLSB,W
                movwf COUNT0
		clrf COUNT2

                call BIN2DEC

                movf DIGIT8,W           ; show decimal value
                call LCDOUT
                movf DIGIT7,W
                call LCDOUT
                movf DIGIT6,W
                call LCDOUT
                movf DIGIT5,W
                call LCDOUT
                movf DIGIT4,W
                call LCDOUT
                movf DIGIT3,W
                call LCDOUT
                movf DIGIT2,W
                call LCDOUT
                movf DIGIT1,W
                call LCDOUT

        	return
		
LCDLIN          bcf RSLINE,4            ; sets LCD command/line
                call LCDOUT             ; and outputs cmmand code to LCD
                bsf RSLINE,4            ; set RS flag
	        return

LCDOUT          movwf STORE             ; temp store data
                movlw 50                ; set minimum time between sending full bytes to
                movwf LOOPA             ; LCD - value of 50 seems OK for this prog with
DELAY           decfsz LOOPA,F          ; XTAL clk of upto 5MHz, possibly 5.5MHz
                goto DELAY              ; keep decrementing LOOPA until zero
                call SENDIT             ; send MSB
                call SENDIT             ; send LSB
                return 
                 
SENDIT          swapf STORE,F           ; swap data nibbles
                movf STORE,W            ; get data byte
                andlw 15                ; get nibble from byte (LSB)
                iorwf RSLINE,W          ; OR the RS bit
                movwf PORTB             ; output the byte
                bsf PORTB,5             ; set E line high
                bcf PORTB,5             ; set E line low
                return 
                 
PAUSIT          movlw 5                 ; set delay counter to 5
                movwf CLKCNT            ; (for 1/25th sec x 5)
                clrf INTCON             ; clear interupt flag
PAUSE                                   ; initial 1/5th sec wait before setting up LCD
                btfss INTCON,2          ; has a timer time-out been detected?
                goto PAUSE              ; no
                bcf INTCON,2            ; yes
                decfsz CLKCNT,F         ; dec counter, is it zero?
                goto PAUSE              ; no
                return                  ; yes


BIN2DEC: clrf   DIGIT1
        clrf    DIGIT2
        clrf    DIGIT3
        clrf    DIGIT4
        clrf    DIGIT5
        clrf    DIGIT6
        clrf    DIGIT7
        clrf    DIGIT8

        movlw   24              ; 24 bits to do
        movwf   BITCNT

BITLP:  rlf     COUNT0,F        ; Shift msb into carry
        rlf     COUNT1,F
        rlf     COUNT2,F

        movlw   DIGIT1
        movwf   FSR             ; Pointer to DIGITs
        movlw   8               ; 8 DIGITs to do
        movwf   DIGCNT
ADJLP:  rlf     INDF,F          ; Shift DIGIT 1 bit left
        movlw   10
        subwf   INDF,w          ; Check and adjust for decimal overflow
        skpnc
        movwf   INDF

        incf    FSR,F           ; Next DIGIT
        decfsz  DIGCNT,F
        goto    ADJLP
        decfsz  BITCNT,F        ; Next bit
        goto    BITLP
        movlw 48
        iorwf DIGIT1,F          ; convert to ascii numeral
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F

        movf DIGIT8,W       ; blank leading zeros
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        movf DIGIT7,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT7,4
        movf DIGIT6,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT6,4
        movf DIGIT5,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT5,4
        movf DIGIT4,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT4,4
        movf DIGIT3,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT3,4
        movf DIGIT2,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT2,4
        movf DIGIT8,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        return

DELAYB:   nop
          nop
          nop
          nop
          nop
          nop
          nop
          return


	end
