; TK3TUT29.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; illustrating use of Timer 0 and LCD set up

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

OPTION_REG      EQU 1                   ; OPTION register
PCL             EQU 2                   ; Program counter register
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag
                 
LOOP            EQU H'20'               ; loop counter 1 - general
LOOPA           EQU H'21'               ; loop counter 2 - LCD use only
CLKCNT          EQU H'22'               ; 1/25 secs counter
STORE           EQU H'23'               ; general store
RSLINE          EQU H'24'               ; bit 4 RS line flag for LCD

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                clrf TRISA              ; Port A0-A4 as output
                clrf TRISB		; PORTB as output
                movlw B'10000110'       ; move ratio value into W
                movwf OPTION_REG        ; set timer ratio to 1:128 (TMR0 rate)
                BANK0                   ; (light pull-ups off - bit 7 high)
                 
                goto SETUP              ; bypass table
                 
TABLCD          addwf PCL,F             ; LCD initialisation table
                retlw B'00110011'       ; initialise lcd - first byte
                retlw B'00110011'       ; 2nd byte (repeat of first)
                retlw B'00110010'       ; set for 4-bit operation
                retlw B'00101100'       ; set for 2 lines
                retlw B'00000110'       ; set entry mode to increment each address
                retlw B'00001100'       ; set display on, cursor off, blink off
                retlw B'00000001'       ; clear display
                retlw B'00000010'       ; return home, cursor & RAM to zero
                                        ; end initialisation table
                 
MESSAG          addwf PCL,F
                retlw 'R'
                retlw 'E'
                retlw 'A'
                retlw 'D'
                retlw ' '
                retlw 'E'
                retlw 'P'
                retlw 'E'
                 
SETUP           call PAUSIT             ; perform first 1/5th sec delay
                 
LCDSET          clrf LOOP               ; clr LCD set-up loop
                clrf RSLINE             ; clear RS line for instruction send
LCDST2          movf LOOP,W             ; get table address
                call TABLCD             ; get set-up instruction
                call LCDOUT             ; perform it
                incf LOOP,F             ; inc loop
                btfss LOOP,3            ; has last LCD set-up instruction now been done?
                goto LCDST2             ; no
                call PAUSIT             ; yes, perform second 1/5th sec delay
                                        ; to allow final LCD command to occur
                                        ; (it takes longer than the rest)
                 
LCDMSG          clrf LOOP               ; clear loop
                bsf RSLINE,4            ; set RS for data send
LCDMS2          movf LOOP,W             ; get table address
                call MESSAG             ; get message letter
                call LCDOUT             ; show it
                incf LOOP,F             ; inc loop
                btfss LOOP,3            ; has last LCD letter been sent?
                goto LCDMS2             ; no, so repeat for next one
                 
NOMORE          goto NOMORE             ; yes, so hold here ad infinitum!
                 
LCDOUT          movwf STORE             ; temp store data
                movlw 50                ; set minimum time between sending full bytes to
                movwf LOOPA             ; LCD - value of 50 seems OK for this prog with
DELAY           decfsz LOOPA,F          ; XTAL clk of upto 5MHz, possibly 5.5MHz
                goto DELAY              ; keep decrementing LOOPA until zero
                call SENDIT             ; send MSB
                call SENDIT             ; send LSB
                return 
                 
SENDIT          swapf STORE,F           ; swap data nibbles
                movf STORE,W            ; get data byte
                andlw 15                ; get nibble from byte (LSB)
                iorwf RSLINE,W          ; OR the RS bit
                movwf PORTB             ; output the byte
                bsf PORTB,5             ; set E line high
                bcf PORTB,5             ; set E line low
                return 
                 
PAUSIT          movlw 5                 ; set delay counter to 5
                movwf CLKCNT            ; (for 1/25th sec x 5)
                clrf INTCON             ; clear interupt flag
PAUSE                                   ; initial 1/5th sec wait before setting up LCD
                btfss INTCON,2          ; has a timer time-out been detected?
                goto PAUSE              ; no
                bcf INTCON,2            ; yes
                decfsz CLKCNT,F         ; dec counter, is it zero?
                goto PAUSE              ; no
                return                  ; yes
                 
                end                     ; final line
