;TOW54.asm  This programme generates a musical note on o/p PORT A0.
;port B and ports A0 and A2 are programmed as outputs.  
;(The other ports are as used in Tug of war programme) A0 also drives the 
;PULL LED and PORTS A1 and A3 are inputs (normally low active high). PORTB
;drives the LEDs and A2 drives the centre LED.
;Duration of each note is the same and is determined by number stored in
;NTEDUR register (two registers).  The tone is determined by a number
;loaded from a note table.
;************************************************************************
;
DISP    equ 0Ch ; DISPlay rewgister - contains current score
DYCTR1  equ 08h ; DelaY CounTeR1
DYCTR2  equ 09h ; DelaY CounTeR2
DYCTR3  equ 0Ah ; DelaY CounTeR3
FLAG    equ 0Bh ; FLAG register
REG     equ 0Dh ; input register 
CTR1    equ 0Eh ; holds current round score for S1
CTR2    equ 0Fh ; holds current round score for S2
;
NTDUR1  equ 10h ; holds note duration
NTDUR2  equ 11h ; holds note duration
NTEREG  equ 12h ; determines note frequency
NTEMEM  equ 13h ; holds current note frequency

       LIST P=16C54
        include "PIC.h"

;************************************************************************
;
        goto START
;************************************************************************
;NOTE TABLE

NOTE0   movlw 01h
        movwf NTEREG
        movwf NTEMEM
        goto PLAY

NOTEg1  movlw .85
        movwf NTEREG
        movwf NTEMEM                          
        goto PLAY
NOTEf1  movlw .95
        movwf NTEREG        
        movwf NTEMEM                          
        goto PLAY
NOTEe1  movlw .101
        movwf NTEREG
        movwf NTEMEM
        goto PLAY
NOTEd1  movlw .113
        movwf NTEREG
        movwf NTEMEM                          
        goto PLAY
NOTEc1  movlw .127
        movwf NTEREG        
        movwf NTEMEM                          
        goto PLAY
NOTEb   movlw .135
        movwf NTEREG
        movwf NTEMEM                      
        goto PLAY
NOTEa   movlw .152
        movwf NTEREG
        movwf NTEMEM
        goto PLAY
NOTEg   movlw .170
        movwf NTEREG
        movwf NTEMEM
        goto PLAY
NOTEf   movlw .191
        movwf NTEREG
        movwf NTEMEM
        goto PLAY
NOTEe   movlw .202
        movwf NTEREG
        movwf NTEMEM
        goto PLAY

PLAY    movlw 01h       ; i.e. 0000 0001
        xorwf PORTA     ; compliment A0
PLY2    decfsz NTDUR1
        goto PLY1
        decfsz NTDUR2
        goto PLY1
        movlw 94h
        movwf NTDUR2
        retlw 00h

PLY1    decfsz NTEREG
        goto PLY2
        movf NTEMEM,w
        movwf NTEREG
        goto PLAY

;***************************************************************
DELY    movlw 0FFh      ; DELAY SUBROUTINE
        movwf DYCTR2
D1      decfsz DYCTR2
        goto D1
        retlw 00

;***************************************************************
START   nop
;
        movlw 0Ah       ; i.e. 0000 1010
        OPTION
        goto ST3

ST3     btfsc PORTA,3
        goto S2         ; S2 is pressed
        btfsc PORTA,1
        goto S1         ; S1 is pressed
        goto ST3        ; neither is pressed

S1      movlw 1Ah       ; i.e. 0001 1010 - enable PULL LED
        goto S2A
S2      movlw 1Bh       ; i.e. 0001 1011 - disable PULL LED
S2A     tris PORTA

        movlw 00h
        tris PORTB      ; make PORTB o/p
        bsf STATUS,0    ; set Carry flag
        movlw 00h       ; clear DISP register

        movwf DISP
        movwf PORTB     ; switch port B off

        bsf PORTA,2     ; light centre LED
;
        bsf PORTA,0     ; switch off PULL LED
;
        movlw 0FFh
        movwf DYCTR2
        movf RTCC,w
        movwf DYCTR1    ; load random number into delay

        movlw 03h
        movwf DYCTR3
        movwf CTR1
        movwf CTR2

        movlw 0FFh
        movwf NTDUR1
        movwf NTDUR2
        
ST5     btfsc PORTA,1        
        goto ST5        ; A0 is high - S1 is pressed                
        btfsc PORTA,3
        goto ST5        ; S2 pressed
        
        call DELY       ; both released - BEGIN GAME
;
BEGIN   nop
        movf PORTA,w    ; read PORTA
        movwf REG
        movlw 0Ah       
        andwf REG 
        btfss STATUS,2  
        goto KEYPRS     ; button pressed
;
        decfsz DYCTR3   ; no buttons pressed
        goto BEGIN      ; Random delay not finished
        
        movlw 05h      
        movwf DYCTR3     

        decfsz DYCTR2  
        goto BEGIN      

        movf DYCTR1     
        btfss STATUS,2  
        goto BEGA       
        bcf PORTA,0     ; finished - SWITCH ON PULL LED
        bcf FLAG,0
        goto BEGIN
;
BEGA    decf DYCTR1
        goto BEGIN
;
KEYPRS  btfsc FLAG,0    ; BUTTON PRESSED - is PULL LED lit?
        goto KEY1       ; PULL LED not lit
        btfss REG,1     ; LED LIT - is S1 pressed?
        goto WIN2       ; no - S2 wins
        btfss REG,3     ; is S2 pressed?
        goto WIN1       ; no - S1 wins
        goto DISPLY

KEY1    btfss REG,1     ; PULL LED not lit - is S1 pressed?
        goto WIN1       ; no - S2 looses     
        btfss REG,3     ; is S2 pressed?
        goto WIN2       ; no - S1 looses  
                        ; both loose - go on to DISPLY

DISPLY  bcf PORTA,2     ; switch off centre LED
        btfsc STATUS,0  ; is carry flag set?
        bsf PORTA,2     ; yes - switch on centre LED
        swapf DISP,w
        movwf PORTB     ; output to PORTB

FIN     movf PORTA,w    ; read switches
        movwf REG
        movlw 0Ah      
        andwf REG 
        btfss STATUS,2 
        goto FIN        ; switches still pressed
     
        call DELY       ; switches released
        movf RTCC,w     
        movwf DYCTR1    ; load new delay
        bsf PORTA,0     ; switch off PULL LED
        bsf FLAG,0
        goto BEGIN

WIN1    RLF DISP

        btfss PORTB,7   ; is bit 0 of PORTB set? i.e. game over?
        goto DISPLY     ; no
        goto TUNE       ; yes

WIN2    RRF DISP
         
        btfss PORTB,0   ; is bit 7 of PORTB set? game over?
        goto DISPLY     ; no 
        goto TUNE       ; yes

TUNE    movlw 1Ah       ; i.e. 0001 1010
        tris PORTA      ; make A0 an output

        call NOTEc1     ; TUNE
        call NOTEb
        call NOTEc1
        call NOTEb
        call NOTEg
        call NOTEe
        call NOTEa
        call NOTEe
        call NOTE0
        
        call NOTEc1
        call NOTEd1
        call NOTEe1
        call NOTEg1
        call NOTEe1
        call NOTEa
        call NOTEb
        call NOTEa
        call NOTE0

        call NOTEa
        call NOTEg
        call NOTEa
        call NOTEg
        call NOTEf
        call NOTE0

        call NOTEf1
        call NOTEe1
        call NOTEd1
        call NOTEe1
        call NOTEd1
        call NOTE0
        
        call NOTEe1
        call NOTEc1
        call NOTEf1
        call NOTEe1
        call NOTEc1
        call NOTEf1
        call NOTEe1
        call NOTEc1
        call NOTEf1
        call NOTEe1
        call NOTEd1
        call NOTEc1
        call NOTEc1
        goto ST3
;************************************************************************
        org 1FFh
        END
