/*
 * hex2obj.c
 *
 * Converts Microchip INHX8M or INHX16 files to TASM object format.
 * (Only PIC16C84 files are supported.)
 *
 *
 * Usage: hex2obj hexfile objfile [ skip ]
 *
 *        where skip is the number of words to skip before
 *        writing objfile (default 0).
 *
 * Revision history:
 *
 * 26-Nov-1996: V-0.0; rewrite of hex2jm.c for TASM object format
 *
 * Copyright (C) 1996 David Tait.  All rights reserved.
 * Permission is granted to use, modify, or redistribute this software
 * so long as it is not sold or exploited for profit.
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED.
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include "hex.h"
#include "misc.h"

static char *pname = "hex2obj";
#ifndef LIBVERSION
char *usage = "Usage: hex2obj hexfile objfile";
#endif
static char *version = "hex2obj.c V-0.0  Copyright (C) 1996 David Tait";

static void writeobj(FILE *fp, int skip)
{
    int i;
    U16 *bp;

    bp = progbuf;

    for ( i=0; i<skip; ++i)
	bp++;

    for ( ; i < pmlast+1; ++i) {
	*bp = SWAB(*bp);
	fwrite(bp++, 2, 1, fp);
    }
}


int hex2obj(FILE *hfp, FILE *bfp, int skip)
{
    int e;

    erasehex(PSIZE, DSIZE, WSIZE);
    format = UNKNOWN;
    if ( (e = loadhex(hfp, PSIZE, DSIZE, IBASE, CBASE, DBASE)) != 0 )
	telluser(pname,"While loading hexfile:",e);
    if ( id || cf || dmlast >= 0 )
	fprintf(stderr,"%s: Some hex records ignored\n",pname);
    writeobj(bfp, skip);
    return 0;
}


#ifndef LIBVERSION

int main(int argc, char *argv[])
{
    FILE *ifp, *ofp = stdout;
    int skip = 0;

    if ( argc < 3 )
	quit(pname,usage);

    if ( argc > 3 )
	if ( (skip = atoi(argv[3])) < 0 || skip >= PSIZE )
	    quit(pname,"Illegal skip value");

    if ( (ifp = fopen(argv[1],"r")) == NULL )
	quit(pname,"Can't open hexfile file");

    if ( (ofp = fopen(argv[2],"wb")) == NULL )
	quit(pname,"Can't create objfile");

    hex2obj(ifp, ofp, skip);

    return EXIT_SUCCESS;
}

#endif  /* LIBVERSION */