        LIST    P=12C508, R=HEX	
;
	TITLE 'pest2a' - MAIN PROGRAM FOR RUNNING MAGENTA PEST SCARER MKII'
;
;	COPYRIGHT:  CICUIT DESIGN, ARTWORK, AND SOFTWARE - MAGENTA ELECTRONICS 
;
;			MAGENTA ELECTRONICS LTD. 135 HUNTER STREET,
;			BURTON ON TRENT, STAFFORDSHIRE DE14 2ST  UK.
;			TEL. 44 (0)1283 565435   FAX. 546932
;			EMAIL: MAGENTA_ELECTRONICS@COMPUSERVE.COM
;
;			FULL KITS FOR THIS PROJECT - REF 867 PRICE 19.99 (JUNE 97)
;			POSTAGE UK 3.00,  AIR MAIL 8.50
;			
;			PUBLISHED IN JULY 1997 EVERYDAY AND PRACTICAL ELECTRONICS
;
;	ASSEMBLER: MPASM v01.50
;
;
;
;	SET CHIP CONFIGURATION TO: 
;		MCLR - ENABLE,  CP - OFF,  WATCHDOG - OFF,  INT. RC OSC		
;
;	VERSION 1 RELEASED 2/6/97
;
        #DEFINE INDF    0000                    ;
        #DEFINE TMR0    0001                    ;
        #DEFINE PCL     0002                    ;
        #DEFINE STATUS  0003                    ;
        #DEFINE FSR     0004                    ;
        #DEFINE OSCCAL  0005                    ;     
	#DEFINE GPIO    0006                    ;
;
        #DEFINE RANDHI  0007                    ;RANDOM NUMBER MSD REGISTER
        #DEFINE RANDLO  0008                    ;RANDOM NUMBER LSD REGISTER
;
        #DEFINE DELAY0  0010                    ;TIMING LOOP REGISTERS
        #DEFINE DELAY1  0011                    ; ''
        #DEFINE DELAY2  0012                    ; ''
        #DEFINE CCNTU   0013                    ;CYCLE COUNTER MSD
        #DEFINE CCNTL   0014                    ;CYCLE COUNTER LSD
        #DEFINE RTMP1   0015                    ;USED IN RANDOM NUMBER GENERATOR
        #DEFINE RTMP2   0016                    ; ''
        #DEFINE MOMENT  0017                    ;TRIGGERED OPERATION BURST COUNTER
;
;       DEFINE GPIO BITS
        #DEFINE TRIG2   0006,0                  ;EXTERNAL TRIGGER 2
        #DEFINE TRIG1   0006,1                  ;EXTERNAL TRIGGER 1
        #DEFINE EXT     0006,2                 	;SPARE INPUT PIN
        #DEFINE OUTB    0006,4                  ;EXTENSION OUTPUT DRIVER
        #DEFINE OUTA    0006,5                  ;LOCAL OUTPUT DRIVER
;
;       DEFINE STATUS REGISTER
        #DEFINE CARRY   0003,0                  ;CARRY FLAG
        #DEFINE DCARRY  0003,1                  ;DECIMAL CARRY FLAG
        #DEFINE ZERO    0003,2                  ;ZERO FLAG
        #DEFINE RPAGE   0003,5                  ;REGISTER PAGE SELECT
;
	ORG	0X00
	MOVWF	OSCCAL		;LOAD CALIBRATION VALUE FOR INTERNAL OSC.
	GOTO	START		;AFTER POWER ON, OR RESET GO TO 'START'
;
	ORG	0008		;BEGIN CODE AT 0008
;
;Clear registers 10 - 20:
;
START	MOVLW	0x10		; INITIALISE FSR
	MOVWF	FSR		; 
NXREG	CLRF	INDF 		; CLEAR INDICATED REGISTER
	INCF	FSR,1 		; STEP ON TO NEXT
	BTFSC	FSR,4		; CHECK TO SEE IF COMPLETE (HEX 20 REACHED)
	GOTO	NXREG		; LOOP UNTIL ALL REGISTERS ARE CLEAR
;
;Initialise random number registers
;
	MOVLW	0X45		;SET STARTING VALUES IN RANDOM NUMBER
	MOVWF	RANDLO		;REGISTERS
	MOVLW	0X30		;
	MOVWF	RANDHI		;
;
;Set up i/o ports
;
	MOVLW	0x0		; SET UP INITIAL VALUES TO 0 IN W
	MOVWF	GPIO		; WRITE TO GPIO PORT LATCHES 
	MOVLW	B'00001111'	; SET GPIO 4, AND 5 TO OUTPUTS - OTHERS TO INPUT
	TRIS	GPIO		; WRITE TO 'TRIS' REGISTER 
;
;Set up OPTION register contents
;
	MOVLW	B'11000000'	; SET UP OPTION BITS
	OPTION			; TRANSFER TO OPTION REGISTER
;
MAIN	;MAIN PROGRAM LOOP
	BTFSC	TRIG1		;CHECK OPERATING MODE REQUIRED
	GOTO	NORMAL		;NORMAL MODE SELECTED (TRIG1 IS +) JUMP TO 'NORMAL'			
				;
				;OPTIONAL MODE SELECTED (TRIG1 IS 0) CHECK OTHER PINS	
	MOVF	MOMENT,1	;READ VALUE OF TRIGGERED SEQUENCE BURST COUNTER
	BTFSC	ZERO		;TEST TO SEE IF IT IS ZERO
	GOTO    TRIGA		;IF ZERO CHECK TRIGGER PIN AGAIN
	DECF	MOMENT,1	;IF NOT ZERO DECREMENT COUNTER
	GOTO	NORMAL		;AND DO ANOTHER BURST
				;
TRIGA	BTFSS	TRIG2		;TEST TRIGGER PIN - JUMP IF HIGH
	GOTO	MAIN		;OTHERWISE LOOP - NOT TRIGGERED (TRIG2 IS 0) SO LOOP
				;
	MOVLW	0X10		;SET NUMBER OF BURSTS IN TRIGGER SEQUENCE
	MOVWF	MOMENT		;LOAD TO COUNTER
	GOTO	MAIN		;LOOP
;	
;
NORMAL	CALL	RANDOM		;GET RANDOM NUMBER
	GOTO	BURSTA		;GENERATE LOCAL BURST OF ULTRASOUND

INTVL1	CALL	RANDOM		;GET NEXT RANDOM NUMBER
	CALL	PAUSE1		;PAUSE FOR INTERVAL BETWEEN BURSTS

	BTFSC	EXT		;TEST GP2 PIN - IF 0 - CONTINUE
	GOTO	MAIN		;IF GP2 IS + DO NOT DRIVE EXTENSION OUTPUT

	CALL    RANDOM		;GET NEXT RANDOM NUMBER
	GOTO 	BURSTB		;GENERATE BURST FOR EXTENSION OUTPUT

INTVL2	CALL	RANDOM		;GET NEXT RANDOM NUMBER
	CALL	PAUSE1		;PAUSE FOR NEXT INTERVAL
	GOTO	MAIN		;LOOP
;
;****CODE FROM 'BURSTA' DOWN TO END OF 'OFLOOP' IS CRITICAL FOR TIMING OF 32KHZ OUTPUT
;****DO NOT ALTER NUMBER OF MACHINE CYCLES
;
BURSTA	BSF	OUTA		;TURN ON POWER TRANSISTOR
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	BCF     OUTA		;TURN OFF POWER TRANSISTOR
	CALL	OFFDEL		;
;
	DECFSZ	CCNTL,1		;DECREMENT LOWER BYTE OF COUNTER
	GOTO	LNZA		;LOWER BYTE NOT YET ZERO
	DECFSZ	CCNTU,1		;DECREMENT UPPER BYTE OF COUNTER
LNZA	GOTO	BURSTA		;LOOP UNTIL ZERO
	GOTO 	INTVL1		;BURST COMPLETE - EXIT
;
BURSTB	BSF	OUTB		;TURN ON EXTENSION POWER TRANSISTOR
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	BCF     OUTB		;TURN OFF EXTENSION POWER TRANSISTOR
	CALL	OFFDEL		;
;
	DECFSZ	CCNTL,1		;DECREMENT LOWER BYTE OF COUNTER
	GOTO	LNZB		;LOWER BYTE NOT YET ZERO
	DECFSZ	CCNTU,1		;DECREMENT UPPER BYTE OF COUNTER
LNZB	GOTO	BURSTB		;LOOP UNTIL ZERO
	GOTO 	INTVL2		;EXTENSION BURST COMPLETE - EXIT;
;
OFFDEL	MOVLW	0X04		;LOAD 'OFF' TIME COUNTER
	MOVWF	DELAY0		;
OFLOOP	DECFSZ	DELAY0,1	;DECREMENT AND LOOP TO ZERO
	GOTO	OFLOOP		;
	RETURN
;
;****CODE FROM 'BURSTA' DOWN TO HERE IS CRITICAL FOR TIMING OF 32KHZ OUTPUT
;****DO NOT ALTER NUMBER OF MACHINE CYCLES.
;
RANDOM	RLF	RANDHI,0	;GENERATES RANDOM NUMBER IN RANDHI		
	XORWF	RANDHI,0	;AND RANDLO
	MOVWF	RTMP1		;SIMULATES TAPPED SHIFT REGISTER
	SWAPF	RANDHI,1	;WITH XOR FEEDBACK
	SWAPF	RANDLO,0	;THIS ROUTINE DERIVED FROM MICROCHIP DATA BOOK
	MOVWF	RTMP2		;AN617 'RANDOM16' FOR PIC16C5X.
	RLF	RTMP2,0		;
	RLF	RTMP2,1
	MOVF	RTMP2,0
	XORWF	RANDHI,0
	SWAPF	RANDHI,1
	ANDLW	0X01
	RLF	RTMP1,1
	RLF	RANDLO,1
	XORWF	RANDLO,1
	RLF	RANDHI,1	;RANDOM NUMBER NOW IN PLACE
;
	MOVLW	0XC0		;MASK UPPER TWO BITS TO MAKE 0 - 64 (DEC)
	ANDWF	RANDLO,0	;AND PLACE RESULT VIA W
	MOVWF	CCNTU		;INTO CYCLE COUNTER
	MOVLW	0X30		;ADD MINIMUM NUMBER (48 DECIMAL)
	ADDWF	CCNTU,1		;
	CLRF	CCNTL		;PUT ZERO IN CYCLE COUNTER LOWER BYTE
	RETLW	0X00		;CLEAR W AND RETURN
;
;
PAUSE1	;GENERATES INTERVAL BETWEEN BURSTS USING RANDOM NUMBER IN 'CCNTU'
	DECFSZ	CCNTL,1		;DECREMENT LOWER BYTE OF COUNTER
	GOTO	LNZC		;LOWER BYTE NOT YET ZERO
	DECFSZ	CCNTU,1		;DECREMENT UPPER BYTE OF COUNTER
LNZC	GOTO	PAUSEA		;LOOP VIA 'PAUSEA' UNTIL ZERO
	RETURN		        ;PAUSE COMPLETE - EXIT
;
PAUSEA	MOVLW	0x1F		;SET 'PAUSEA' LOOP COUNT VALUE - DETERMINES INTERVAL
	MOVWF	DELAY1		;LOAD TO REGISTER
DEL1LP	DECFSZ	DELAY1,1	;DECREMENT LOOP COUNTER 
	GOTO	DEL1LP		;LOOP UNTIL ZERO
	GOTO	PAUSE1		;RETURN WHEN COMPLETE
;
	ORG	0080
	DATA	'M'
	DATA	'A'
	DATA	'G'
	DATA	'E'
	DATA	'N'
	DATA	'T'
	DATA	'A'
;
;
;***	ORG	01FF		;***** ONLY FOR EPROM CHIP INSERT CALIBRATION CONSTANT - 
;***	DATA	0C50		;***** 0C50 RETLW #50 IN EEPROM CHIP 1
;
	ORG	0FFF		;SET UP CONFIGURATION - GIVES ERROR MESSAGE - BUT IGNORE 
	DATA	0X1A	

	END
