;***********************************************************
;MIDI PEDAL PROGRAM
;***********************************************************
;Written for PIC16C54 and Assembler MPALC V4.14
;
STATUS          EQU             03
Z               EQU             02
PORTA           EQU             05
PORTB           EQU             06
ADIR            EQU             05
CNTR            EQU             0C
		MOVLW           0E
		TRIS            PORTA           ;Set RA0 as output
		CLRF            PORTA           ;Set RA0 low initially
START           BTFSC           PORTB,0         ;Test S1
		GOTO            PED1
		GOTO            START           ;Loop until a button is pressed
;
PED1            CALL            CONCHG          ;Control change status byte
		BTFSC           PORTB,1         ;Test S2
		CALL            CONUM1          ;Control number byte (64)
		BTFSS           PORTB,1         ;Test S2
		CALL            CONUM2          ;Control number byte (63)
		CALL            ONDTA           ;Control on data byte
LOOP            BTFSC           PORTB,0         ;Test S1
		GOTO            LOOP            ;Loop until S1 is released
		CALL            CONCHG          ;Control change status byte
		BTFSC           PORTB,1         ;Test S2
		CALL            CONUM1          ;Control number byte (64)
		BTFSS           PORTB,1         ;Test S2
		CALL            CONUM2          ;Control number byte (63)
		CALL            OFFDTA          ;Control off data byte
		GOTO            START           ;Loop indefinitely
;
CONCHG          BSF             PORTA,0         ;Byte 1 start bit high
		MOVLW           0A
		MOVWF           CNTR
BIT1            DECFSZ          CNTR,1
		GOTO            BIT1
		BSF             PORTA,0         ;Byte 1 D0 high
		MOVLW           0A
		MOVWF           CNTR
BIT2            DECFSZ          CNTR,1
		GOTO            BIT2
		BSF             PORTA,0         ;Byte 1 D1 high
		MOVLW           0A
		MOVWF           CNTR
BIT3            DECFSZ          CNTR,1
		GOTO            BIT3
		BSF             PORTA,0         ;Byte 1 D2 high
		MOVLW           0A
		MOVWF           CNTR
BIT4            DECFSZ          CNTR,1
		GOTO            BIT4
		BSF             PORTA,0         ;Byte 1 D3 high
		MOVLW           0A
		MOVWF           CNTR
BIT5            DECFSZ          CNTR,1
		GOTO            BIT5
		BCF             PORTA,0         ;Byte 1 D4 low
		MOVLW           0A
		MOVWF           CNTR
BIT6            DECFSZ          CNTR,1
		GOTO            BIT6
		BCF             PORTA,0         ;Byte 1 D5 low
		MOVLW           0A
		MOVWF           CNTR
BIT7            DECFSZ          CNTR,1
		GOTO            BIT7
		BSF             PORTA,0         ;Byte 1 D6 high
		MOVLW           0A
		MOVWF           CNTR
BIT8            DECFSZ          CNTR,1
		GOTO            BIT8
		BCF             PORTA,0         ;Byte 1 D7 low
		MOVLW           0A
		MOVWF           CNTR
BIT9            DECFSZ          CNTR,1
		GOTO            BIT9
		BCF             PORTA,0         ;Byte 1 stop bit low
		MOVLW           0A
		MOVWF           CNTR
BIT10           DECFSZ          CNTR,1
		GOTO            BIT10
		RETLW           0
;
CONUM1          BSF             PORTA,0         ;Byte 2 start bit high
		MOVLW           0A
		MOVWF           CNTR
BIT11           DECFSZ          CNTR,1
		GOTO            BIT11
		BSF             PORTA,0         ;Byte 2 D0 high
		MOVLW           0A
		MOVWF           CNTR
BIT12           DECFSZ          CNTR,1
		GOTO            BIT12
		BSF             PORTA,0         ;Byte 2 D1 high
		MOVLW           0A
		MOVWF           CNTR
BIT13           DECFSZ          CNTR,1
		GOTO            BIT13
		BSF             PORTA,0         ;Byte 2 D2 high
		MOVLW           0A
		MOVWF           CNTR
BIT14           DECFSZ          CNTR,1
		GOTO            BIT14
		BSF             PORTA,0         ;Byte 1 D3 high
		MOVLW           0A
		MOVWF           CNTR
BIT15           DECFSZ          CNTR,1
		GOTO            BIT15
		BSF             PORTA,0         ;Byte 2 D4 high
		MOVLW           0A
		MOVWF           CNTR
BIT16           DECFSZ          CNTR,1
		GOTO            BIT16
		BSF             PORTA,0         ;Byte 2 D5 high
		MOVLW           0A
		MOVWF           CNTR
BIT17           DECFSZ          CNTR,1
		GOTO            BIT17
		BCF             PORTA,0         ;Byte 2 D6 low
		MOVLW           0A
		MOVWF           CNTR
BIT18           DECFSZ          CNTR,1
		GOTO            BIT18
		BSF             PORTA,0         ;Byte 2 D7 high
		MOVLW           0A
		MOVWF           CNTR
BIT19           DECFSZ          CNTR,1
		GOTO            BIT19
		BCF             PORTA,0         ;Byte 2 stop bit low
		MOVLW           0A
		MOVWF           CNTR
BIT20           DECFSZ          CNTR,1
		GOTO            BIT20
		RETLW           0
;
ONDTA           BSF             PORTA,0         ;Byte 3 start bit high
		MOVLW           0A
		MOVWF           CNTR
BIT21           DECFSZ          CNTR,1
		GOTO            BIT21
		BCF             PORTA,0         ;Byte 3 D0 low
		MOVLW           0A
		MOVWF           CNTR
BIT22           DECFSZ          CNTR,1
		GOTO            BIT22
		BCF             PORTA,0         ;Byte 3 D1 low
		MOVLW           0A
		MOVWF           CNTR
BIT23           DECFSZ          CNTR,1
		GOTO            BIT23
		BCF             PORTA,0         ;Byte 3 D2 low
		MOVLW           0A
		MOVWF           CNTR
BIT24           DECFSZ          CNTR,1
		GOTO            BIT24
		BCF             PORTA,0         ;Byte 3 D3 low
		MOVLW           0A
		MOVWF           CNTR
BIT25           DECFSZ          CNTR,1
		GOTO            BIT25
		BCF             PORTA,0         ;Byte 3 D4 low
		MOVLW           0A
		MOVWF           CNTR
BIT26           DECFSZ          CNTR,1
		GOTO            BIT26
		BCF             PORTA,0         ;Byte 3 D5 low
		MOVLW           0A
		MOVWF           CNTR
BIT27           DECFSZ          CNTR,1
		GOTO            BIT27
		BCF             PORTA,0         ;Byte 3 D6 low
		MOVLW           0A
		MOVWF           CNTR
BIT28           DECFSZ          CNTR,1
		GOTO            BIT28
		BSF             PORTA,0         ;Byte 3 D7 high
		MOVLW           0A
		MOVWF           CNTR
BIT29           DECFSZ          CNTR,1
		GOTO            BIT29
		BCF             PORTA,0         ;Byte 3 stop bit low
		MOVLW           0A
		MOVWF           CNTR
BIT30           DECFSZ          CNTR,1
		GOTO            BIT30
		RETLW           0
;
OFFDTA          BSF             PORTA,0         ;Byte 1 start bit high
		MOVLW           0A
		MOVWF           CNTR
BIT31           DECFSZ          CNTR,1
		GOTO            BIT31
		BSF             PORTA,0         ;Byte 1 D0 high
		MOVLW           0A
		MOVWF           CNTR
BIT32           DECFSZ          CNTR,1
		GOTO            BIT32
		BSF             PORTA,0 ;       Byte 1 D1 high
		MOVLW           0A
		MOVWF           CNTR
BIT33           DECFSZ          CNTR,1
		GOTO            BIT33
		BSF             PORTA,0         ;Byte 1 D2 high
		MOVLW           0A
		MOVWF           CNTR
BIT34           DECFSZ          CNTR,1
		GOTO            BIT34
		BSF             PORTA,0         ;Byte 1 D3 high
MOVLW           0A
MOVWF           CNTR
BIT35           DECFSZ          CNTR,1
		GOTO            BIT35
		BSF             PORTA,0         ;Byte 1 D4 high
MOVLW           0A
MOVWF           CNTR
BIT36           DECFSZ          CNTR,1
		GOTO            BIT36
		BSF             PORTA,0         ;Byte 1 D5 high
		MOVLW           0A
		MOVWF           CNTR
BIT37           DECFSZ          CNTR,1
		GOTO            BIT37
		BSF             PORTA,0         ;Byte 1 D6 high
		MOVLW           0A
		MOVWF           CNTR
BIT38           DECFSZ          CNTR,1
		GOTO            BIT38
		BSF             PORTA,0         ;Byte 1 D7 high
		MOVLW           0A
		MOVWF           CNTR
BIT39           DECFSZ          CNTR,1
		GOTO            BIT39
		BCF             PORTA,0         ;Byte 1 stop bit low
		MOVLW           0A
		MOVWF           CNTR
BIT40           DECFSZ          CNTR,1
		GOTO            BIT40
		RETLW           0
;
CONUM2          BSF             PORTA,0         ;Byte 2 start bit high
		MOVLW           0A
		MOVWF           CNTR
BIT41           DECFSZ          CNTR,1
		GOTO            BIT41
		BCF             PORTA,0         ;Byte 2 D0 low
		MOVLW           0A
		MOVWF           CNTR
BIT42           DECFSZ          CNTR,1
		GOTO            BIT42
		BSF             PORTA,0         ;Byte 2 D1 high
		MOVLW           0A
		MOVWF           CNTR
BIT43           DECFSZ          CNTR,1
		GOTO            BIT43
		BSF             PORTA,0         ;Byte 2 D2 high
		MOVLW           0A
		MOVWF           CNTR
BIT44           DECFSZ          CNTR,1
		GOTO            BIT44
		BSF             PORTA,0         ;Byte 2 D3 high
		MOVLW           0A
		MOVWF           CNTR
BIT45           DECFSZ          CNTR,1
		GOTO            BIT45
		BSF             PORTA,0         ;Byte 2 D4 high
		MOVLW           0A
		MOVWF           CNTR
BIT46           DECFSZ          CNTR,1
		GOTO            BIT46
		BSF             PORTA,0         ;Byte 2 D5 high
		MOVLW           0A
		MOVWF           CNTR
BIT47           DECFSZ          CNTR,1
		GOTO            BIT47
		BCF             PORTA,0         ;Byte 2 D6 low
		MOVLW           0A
		MOVWF           CNTR
BIT48           DECFSZ          CNTR,1
		GOTO            BIT48
		BSF             PORTA,0         ;Byte 2 D7 high
		MOVLW           0A
		MOVWF           CNTR
BIT49           DECFSZ          CNTR,1
		GOTO            BIT49
		BCF             PORTA,0         ;Byte 2 stop bit low
		MOVLW           0A
		MOVWF           CNTR
BIT50           DECFSZ          CNTR,1
		GOTO            BIT50
		RETLW           0
;
		END

