 ;MIDI CODE TESTER
 ;================
 ;LIST R=DEC ; DEFAULT RADIX DECIMAL
 ;LIST P=PIC16F628 ; FLASH MEMORY 18-PIN DEVICE
 ; PICSIZE 2048;16F628 PROGRAMME MEMORY SIZE
 ; RAMSIZE 128;16F627 RAM MEMORY SIZE (MAX 128)
 ;__CONFIG %11111101100001;
 ;PROGRAM CODE PROTECTION OFF
 ;DATA CODE PROTECTION OFF
 ;LOW VOLTAGE PROGRAMMING DISABLED
 ;BROWN-OUT DETECT ENABLED
 ;MCLR- SELECTED
 ;POWER-UP TIMER ENABLED
 ;WATCHDOG TIMER DISABLED
 ;XT XTAL SELECTED
 ;#DEFINE BANK0 BCF STATUS,6 BCF STATUS,5
 ;#DEFINE BANK1 BCF STATUS,6 BSF STATUS,5
 ;#DEFINE BANK2 BSF STATUS,6 BCF STATUS,5
 ;#DEFINE BANK3 BSF STATUS,6 BSF STATUS,5
 ;==============================================
 
W EQU 0 ; WORKING REGISTER FLAG
F EQU 1 ; FILE REGISTER FLAG
 ;==============================================
 ; REGISTER FILES TO $0C
 ; *********************
 
 ; BANK0 REGISTER FILES
 ; --------------------
PORTA EQU $05 ; PORT A DATA REGISTER
 ; BANK1 REGISTER FILES
 ; --------------------
TRISA EQU $05 ; PORT A DIRECTION REGISTER
 ; BANK0 AND BANK2 REGISTER FILES
 ; ------------------------------
TMR0 EQU $01 ; 
PORTB EQU $06 ; PORT B DATA REGISTER
 ; BANK1 AND BANK3 REGISTER FILES
 ; ------------------------------
OPTION EQU $01 ; 
TRISB EQU $06 ; PORT B DIRECTION REGISTER
 ; BANK0, BANK1, BANK2 AND BANK3 REGISTER FILES
 ; --------------------------------------------
PCL EQU $02 ;
STATUS EQU $03 ; STATUS REGISTER
 ; STATUS BITS
C EQU 0 ; CARRY FLAG
Z EQU 2 ; ZERO FLAG
RP0 EQU 5 ;
RP1 EQU 6 ;
FSR EQU $04 ;
PCLATH EQU $0A ;
INTCON EQU $0B ;
RA0 EQU 0
RA1 EQU 1
RA3 EQU 3
RB3 EQU 3
 ;========================================================
 ;SET UP PIC16F627/8 ADDITIONAL REGISTERS
 ; REGISTER FILES $0C TO $20
 ; *************************
 ; BANK0 REGISTER FILES
 ; --------------------
 ;RP0 EQU 5 ;
 ; INTCON BITS
PEIE EQU 6 ;
GIE EQU 7 ;
PIR1 EQU $0C ; 
 ; PIR1 BITS
RCIF EQU 5
TXIF EQU 4 ;
TMR1L EQU $0E ;
TMR1H EQU $0F ;
T1CON EQU $10 ;
TMR2 EQU $11 ;
T2CON EQU $12 ;
CCPR1L EQU $15 ;
CCPR1H EQU $16 ;
CCP1CON EQU $17 ;
RCSTA EQU $18 ;
 ; RCSTA BITS
SPEN EQU 7;
RX9 EQU 6;
CREN EQU 4;
FERR EQU 2;
OERR EQU 1;
RX9D EQU 0;
TXREG EQU $19 ;
RCREG EQU $1A ;
CMCON EQU $1F ;
 ; BANK1 REGISTER FILES
 ; --------------------
PIE1 EQU $0C ;
 ; PIE1 BITS
RCIE EQU 5;
TXIE EQU 4;
PCON EQU $0E ;
PR2 EQU $12 ;
TXSTA EQU $18 ;
 ; TXSTA BITS
SYNC EQU 4;
BRGH EQU 2;
TX9 EQU 6;
TXEN EQU 5;
TRMT EQU 1;
TX9D EQU 0;
SPBRG EQU $19 ;
EEDATA EQU $1A ;
EEADR EQU $1B ;
EECON1 EQU $1C ;
EECON2 EQU $1D ;
VRCON EQU $1F ;
 ; ======================================================
 ; GENERAL PURPOSE REGISTERS
 ; -------------------------
 ; 020-07F (BANK 0)
 ; 0A0-0EF (BANK 1)
 ; 120-14F BANK 2)
 ; TOTAL 224 
 ; $70-$7F ALSO ACCESSED VIA BANKS1, 2 AND 3
 ; ========================================= ;
 ;NB MIDI CHANNEL 1 ONLY
 ;HARDWARE CONFIGURATION
 ;4MHZ XTAL (DEFINES BAUD RATE)
 ;LCD MODULE
 ;2X16 ALPHANUMERIC DISPLAY
 ;E = RB3
 ;RS = RB0
 ;0=COMMAND 1=TEXT
 ;4-BIT OPERATION
 ;D7-D4 = RB7-RB4
 ;D3-D0 = NOT USED
 ;R/W- = HARD-WIRED TO 0
 ;SWITCHES
 ;PORTA,RA0 = CHANGE/NO
 ;PORTA,RA1 = ACCEPT/YES
 ;NEGATIVE LOGIC (0 = PRESSED)
 ;USART
 ;DATA RECEIVED ON RB1
 ;DATA TRANSMITTED ON RB2
 ;END OF HARDWARE CONFIGURATION
 ;===============================================
 ;SET UP USER REGISTERS
 ;*********************
 ;GENERAL PURPOSE REGISTERS -
 ;020H-07FH (BANK 0)
 ;0A0H-0EFH (BANK 1)
 ;120H-14FH BANK 2)
 ;TOTAL 224 
 ;BANK 0
MS_BYTE_1 EQU $20;
MS_BYTE_2 EQU $21;
MS_BYTE_3 EQU $22;
MS_OPT_NR EQU $23;
MS_OPT_NR_TP EQU $24;
TX_OPT_NR EQU $25;
RPT_TYP_NR EQU $26;
MS_OPT_TMP EQU $27 ;
STATUS_TEMP EQU $28 ;
SW_ST_TMP EQU $29 ;
MIDI_BYTE EQU $2A ;
SW_STATE EQU $2B;BIT 0 = SW0, BIT 1 = SW1
SW_STATE_TMP EQU $2C;BIT 0 = SW0, BIT 1 = SW1
MSG_NR_TMP EQU $2D ;
MSG_NR_TMP_T EQU $2E ;
LCD_BYTE EQU $2F ;
LCD_BYTE_TMP EQU $30 ;
TEMP_BYTE EQU $31;
TEMP_BYTE_TP EQU $32;
RS_BYTE EQU $33;BIT0 = RS CONTROL LINE FOR LCD VIA
RS_BYTE_TMP EQU $34;BIT0 = RS CONTROL LINE FOR LCD VIA
 ;PORTB (BIT 4 FOR SIMULATOR) 
TX_MES EQU $35;
US_COUNT EQU $36; 
US_COUNT_TMP EQU $37; 
MSG_NR EQU $38;
MSG_NR_TP EQU $39;
MSG_ADR_OS EQU $3A;
MSG_ADR_OS_T EQU $3B;
MSG_TB_PTR EQU $3C;
MSG_TB_PTR_T EQU $3D;
LCD_IN_T_P EQU $3E;
LCD_IN_T_P_T EQU $3F;
COUNT1 EQU $40 ;
COUNT1_TMP EQU $41 ;
VARMSCOUNT EQU $42;
VARMSCOUNT_T EQU $43;
DLY_COUNT EQU $44;
DLY_COUNT_TP EQU $45;
W_TEMP EQU $7F ;
 ;END OF SET UP USER REGISTERS
 ;START OF PROGRAMME CODE
 ORG $0000 
 GOTO START;
 ;INTERRUPT VECTOR
 ORG $0004;
 GOTO INTRPT;
 ORG $0005;
 ;START OF TABLES
 ;LCD INIT TABLE
LCD_INIT_TB: ADDWF PCL,F;
 RETLW $33 ;
 RETLW $32 ;
 RETLW $28; 
 RETLW $28;
 RETLW $06;
 RETLW $0F;
 RETLW $01;
 RETLW $00;
 ;START OF RX TABLES
 ;RX LCD MESSAGE TABLE
MSG_TBL_RX: ADDWF PCL,F;
 ;MESSAGE ADDRESS OFFSET -
 ;(= NO. OF CHARACTERS + 1 FOR '#', THE
 ;END-OF-MESSAGE MARKER)
 ;ENTER THESE VALUES IN MESSAGE
 ;ADDRESS OFFSET TABLE
 ;MESSAGE NUMBERS 0 TO 15 AND TABLE OFFSETS
 RETLW 'N'
 RETLW 'o'
 RETLW 't'
 RETLW 'e'
 RETLW ' '
 RETLW 'O'
 RETLW 'f'
 RETLW 'f'
 RETLW '#';0
 RETLW 'N'
 RETLW 'o'
 RETLW 't'
 RETLW 'e'
 RETLW ' '
 RETLW 'O'
 RETLW 'n'
 RETLW '#';9
 RETLW 'P'
 RETLW 'o'
 RETLW 'l'
 RETLW 'y'
 RETLW ' '
 RETLW 'K'
 RETLW 'e'
 RETLW 'y'
 RETLW ' '
 RETLW 'P'
 RETLW 'r'
 RETLW 'e'
 RETLW 's'
 RETLW 's'
 RETLW 'u'
 RETLW 'r'
 RETLW '#';17
 RETLW 'C'
 RETLW 'o'
 RETLW 'n'
 RETLW 't'
 RETLW 'r'
 RETLW 'o'
 RETLW 'l'
 RETLW ' '
 RETLW 'C'
 RETLW 'h'
 RETLW 'a'
 RETLW 'n'
 RETLW 'g'
 RETLW 'e'
 RETLW '#';34
 RETLW 'P'
 RETLW 'r'
 RETLW 'o'
 RETLW 'g'
 RETLW 'r'
 RETLW 'a'
 RETLW 'm'
 RETLW ' '
 RETLW 'C'
 RETLW 'h'
 RETLW 'a'
 RETLW 'n'
 RETLW 'g'
 RETLW 'e'
 RETLW '#';49
 RETLW 'O'
 RETLW 'v'
 RETLW 'e'
 RETLW 'r'
 RETLW 'a'
 RETLW 'l'
 RETLW 'l'
 RETLW ' '
 RETLW 'P'
 RETLW 'r'
 RETLW 'e'
 RETLW 's'
 RETLW 's'
 RETLW 'u'
 RETLW 'r'
 RETLW 'e'
 RETLW '#';64
 RETLW 'P'
 RETLW 'i'
 RETLW 't'
 RETLW 'c'
 RETLW 'h'
 RETLW ' '
 RETLW 'W'
 RETLW 'h'
 RETLW 'e'
 RETLW 'e'
 RETLW 'l'
 RETLW '#';81
 RETLW 'C'
 RETLW 'l'
 RETLW 'o'
 RETLW 'c'
 RETLW 'k'
 RETLW ' '
 RETLW 'S'
 RETLW 'i'
 RETLW 'g'
 RETLW 'n'
 RETLW 'a'
 RETLW 'l'
 RETLW '#';93
 RETLW 'S'
 RETLW 'y'
 RETLW 's'
 RETLW 't'
 RETLW 'e'
 RETLW 'm'
 RETLW ' '
 RETLW 'M'
 RETLW 'e'
 RETLW 's'
 RETLW 's'
 RETLW 'a'
 RETLW 'g'
 RETLW 'e'
 RETLW '#';106
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW '#';121
 RETLW 'C'
 RETLW 'h'
 RETLW 'a'
 RETLW 'n'
 RETLW 'g'
 RETLW 'e'
 RETLW '/'
 RETLW 'A'
 RETLW 'c'
 RETLW 'c'
 RETLW 'e'
 RETLW 'p'
 RETLW 't'
 RETLW '?'
 RETLW '#';138
 ;RETLW ''
 RETLW '#';153
 RETLW 'A'
 RETLW 'l'
 RETLW 'l'
 RETLW ' '
 RETLW 'M'
 RETLW 'e'
 RETLW 's'
 RETLW 's'
 RETLW 'a'
 RETLW 'g'
 RETLW 'e'
 RETLW 's'
 RETLW '#';154
 RETLW 'N'
 RETLW 'o'
 RETLW ' '
 RETLW 'C'
 RETLW 'l'
 RETLW 'k'
 RETLW ';'
 RETLW ' '
 RETLW 'S'
 RETLW 'h'
 RETLW 'o'
 RETLW 'w'
 RETLW ' '
 RETLW 'S'
 RETLW 'y'
 RETLW 's'
 RETLW '#';167
 RETLW 'N'
 RETLW 'o'
 RETLW ' '
 RETLW 'S'
 RETLW 'y'
 RETLW 's'
 RETLW ' '
 RETLW 'o'
 RETLW 'r'
 RETLW ' '
 RETLW 'C'
 RETLW 'l'
 RETLW 'k'
 RETLW '#';184
 ;RX MESSAGE ADDRESS OFFSET TABLE
MSG_OF_TB_RX: ADDWF PCL,F;
 ;MESSAGE NUMBERS 0 TO 15
 RETLW 0;
 RETLW 9;
 RETLW 17;
 RETLW 34;
 RETLW 49;
 RETLW 64;
 RETLW 81;
 RETLW 93;
 RETLW 106;
 RETLW 121;
 RETLW 138;
 RETLW 153;
 RETLW 154;
 RETLW 167;
 RETLW 184;
 ;END OF RX TABLES
 ;START OF TX TABLES
 ORG $0100;
 ;SET PCLATH FOR ORG $0100
TX_OPT_TBL: BSF PCLATH,0;
 ADDWF PCL,F;
 GOTO NOTE_OFF;
 GOTO NOTE_ON;
 GOTO P_KY_PR;
 GOTO CON_CH;
 GOTO PROG_CH;
 GOTO OVRL_PR;
 GOTO PTCH_WH;
 GOTO SYS_RST;
 ;NEED RETURN INSTRUCTION AT
 ;THE END OF THESE 'GOTO' ROUTINES
 ;TX LCD MESSAGE TABLE
MSG_TBL_TX: BSF PCLATH,0; SET PCLATH FOR ORG 0100
 ADDWF PCL,F;
 ;MESSAGE ADDRESS OFFSET -
 ;(= NO. OF CHARACTERS + 1 FOR '#', THE
 ;END-OF-MESSAGE MARKER)
 ;ENTER THESE VALUES IN MESSAGE
 ;ADDRESS OFFSET TABLE
 ;MESSAGE NUMBERS 0 TO 15
 RETLW 'N'
 RETLW 'o'
 RETLW 't'
 RETLW 'e'
 RETLW ' '
 RETLW 'O'
 RETLW 'f'
 RETLW 'f'
 RETLW ' '
 RETLW '('
 RETLW 'C'
 RETLW '3'
 RETLW ')'
 RETLW '#';
 RETLW 'N'
 RETLW 'o'
 RETLW 't'
 RETLW 'e'
 RETLW ' '
 RETLW 'O'
 RETLW 'n'
 RETLW ' '
 RETLW '('
 RETLW 'C'
 RETLW '3'
 RETLW ')'
 RETLW '#';14
 RETLW 'P'
 RETLW '-'
 RETLW 'K'
 RETLW 'e'
 RETLW 'y'
 RETLW ' '
 RETLW 'P'
 RETLW 'r'
 RETLW 'e'
 RETLW 's'
 RETLW 's'
 RETLW ' '
 RETLW '('
 RETLW '6'
 RETLW '4'
 RETLW ')'
 RETLW '#';27
 RETLW 'C'
 RETLW 't'
 RETLW 'r'
 RETLW 'l'
 RETLW ' '
 RETLW 'C'
 RETLW 'h'
 RETLW 'g'
 RETLW ' '
 RETLW '('
 RETLW '7'
 RETLW '-'
 RETLW '1'
 RETLW '2'
 RETLW '7'
 RETLW ')'
 RETLW '#';44
 RETLW 'P'
 RETLW 'r'
 RETLW 'o'
 RETLW 'g'
 RETLW ' '
 RETLW 'C'
 RETLW 'h'
 RETLW 'g'
 RETLW ' '
 RETLW '('
 RETLW '9'
 RETLW '9'
 RETLW ')'
 RETLW '#';61
 RETLW 'O'
 RETLW 'v'
 RETLW 'r'
 RETLW 'l'
 RETLW ' '
 RETLW 'P'
 RETLW 'r'
 RETLW 'e'
 RETLW 's'
 RETLW 's'
 RETLW ' '
 RETLW '('
 RETLW '9'
 RETLW '0'
 RETLW ')'
 RETLW '#';75
 RETLW 'P'
 RETLW 'i'
 RETLW 't'
 RETLW 'c'
 RETLW 'h'
 RETLW ' '
 RETLW 'W'
 RETLW ' '
 RETLW '('
 RETLW '9'
 RETLW '5'
 RETLW '-'
 RETLW '8'
 RETLW '5'
 RETLW ')'
 RETLW '#';91
 RETLW 'S'
 RETLW 'y'
 RETLW 's'
 RETLW 't'
 RETLW 'e'
 RETLW 'm'
 RETLW ' '
 RETLW 'R'
 RETLW 'e'
 RETLW 's'
 RETLW 'e'
 RETLW 't'
 RETLW '#';107
 RETLW 'N'
 RETLW 'e'
 RETLW 'w'
 RETLW ' '
 RETLW 'O'
 RETLW 'p'
 RETLW 't'
 RETLW 'i'
 RETLW 'o'
 RETLW 'n'
 RETLW '?'
 RETLW '#';120
 RETLW 'T'
 RETLW 'r'
 RETLW 'a'
 RETLW 'n'
 RETLW 's'
 RETLW 'm'
 RETLW 'i'
 RETLW 't'
 RETLW '?'
 RETLW '#';132
 RETLW 'C'
 RETLW 'h'
 RETLW 'a'
 RETLW 'n'
 RETLW 'g'
 RETLW 'e'
 RETLW '/'
 RETLW 'A'
 RETLW 'c'
 RETLW 'c'
 RETLW 'e'
 RETLW 'p'
 RETLW 't'
 RETLW '?'
 RETLW '#';142
 RETLW 'R'
 RETLW 'e'
 RETLW 'p'
 RETLW 'e'
 RETLW 'a'
 RETLW 't'
 RETLW '?'
 RETLW '#';157
 RETLW 'N'
 RETLW 'e'
 RETLW 'w'
 RETLW ' '
 RETLW 'O'
 RETLW 'p'
 RETLW 't'
 RETLW 'i'
 RETLW 'o'
 RETLW 'n'
 RETLW '?'
 RETLW '#';165
 ;RETLW ''
 RETLW '#';177
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW ' '
 RETLW '#';178
 RETLW 'T'
 RETLW 'r'
 RETLW 'a'
 RETLW 'n'
 RETLW 's'
 RETLW 'm'
 RETLW 'i'
 RETLW 't'
 RETLW 't'
 RETLW 'i'
 RETLW 'n'
 RETLW 'g'
 RETLW '#';195
 ;TX MESSAGE ADDRESS OFFSET TABLE
MSG_OF_TB_TX: BSF PCLATH,0; SET PCLATH FOR ORG $0100
 ADDWF PCL,F;
 RETLW 0;
 RETLW 14;
 RETLW 27;
 RETLW 44;
 RETLW 61;
 RETLW 75;
 RETLW 91;
 RETLW 107;
 RETLW 120;
 RETLW 132;
 RETLW 142;
 RETLW 157;
 RETLW 165;
 RETLW 177;
 RETLW 178;
 RETLW 195;
 ;END OF TX TABLES
 ;END OF TABLES 
 ;INITIALISE IN/OUT PORTS
START: CALL INIT_IO;
 ;INITIALISE LCD DISPLAY
 CALL INIT_LCD;
 ;TEST RA3 FOR TX OR RX
 ;RA3 = 0 - RX
 ;RA3 = 1 - TX
 ;AND GO TO APPROPRIATE SECTION
 BTFSC PORTA,RA3;
 GOTO INIT_TX;
 ;+RX INITIALISATION PROCEDURES
 ;INITIALISE FILE REGISTERS
 CALL IN_F_REG_RX;
 ;INITIALISE INTERRUPT CONTROL
 CALL IN_INT_CON_RX;
 ;INITIALISE USART
INIT_RX: CALL IN_USART_RX;
 ;+END OF INITIALISATION PROCEDURES
 ;+START OF MAIN PROGRAMME
 ;MAIN PROGRAM START
 ;ENTER MAIN ROUTINE FIRST TIME WITH
 ;DEFAULT VALUES AS SET IN INITIALISATION
 ;PROCEDURES
 ;DISABLE RECEPTION
MAIN_START: ;
GET_NEW_MODE: ; 
 ;SELECT THE REQUIRED MIDI MESSAGE
 BCF RCSTA,CREN;OPTION 
 CALL GET_MODE_TYPE;
 ;RETURN WITH SELECTED VALUE DISPLAYED
 ;AND RX MODE TYPE IN SW_STATE
 ;FILE REGISTER
 ;ENABLE RECEPTION
MAIN_LP: BSF RCSTA,CREN;
 ;TEST SWITCHES
 BTFSS PORTA,0;
 GOTO GET_NEW_MODE;
 BTFSS PORTA,1;
 GOTO GET_NEW_MODE;
 GOTO MAIN_LP;
 ;+END OF MAIN PROGRAM
 ;+INTERRUPT SUB-ROUTINE
INTRPT: MOVWF W_TEMP;
 SWAPF STATUS,W;
 BCF STATUS,RP0;
 MOVWF STATUS_TEMP;
 ;
 MOVF MS_OPT_NR,W;
 MOVWF MS_OPT_NR_TP;
 MOVF SW_STATE,W;
 MOVWF SW_STATE_TMP;
 MOVF MSG_NR_TMP,W ;
 MOVWF MSG_NR_TMP_T ;
 MOVF LCD_BYTE,W ;
 MOVWF LCD_BYTE_TMP ;
 MOVF TEMP_BYTE,W;
 MOVWF TEMP_BYTE_TP;
 MOVF RS_BYTE,W;
 MOVWF RS_BYTE_TMP;
 ;
 MOVF US_COUNT,W; 
 MOVWF US_COUNT_TMP; 
 MOVF MSG_NR,W;
 MOVWF MSG_NR_TP;
 MOVF MSG_ADR_OS,W;
 MOVWF MSG_ADR_OS_T;
 MOVF MSG_TB_PTR,W;
 MOVWF MSG_TB_PTR_T;
 MOVF LCD_IN_T_P,W;
 MOVWF LCD_IN_T_P_T;
 MOVF COUNT1,W;
 MOVWF COUNT1_TMP ;
 MOVF VARMSCOUNT,W;
 MOVWF VARMSCOUNT_T;
 MOVF DLY_COUNT,W;
 MOVWF DLY_COUNT_TP;
 ;
 CALL NXT_DAT;
 ;RETURN WITH MESSAGE IN MIDI_BYTE 
 ;TEST FOR MESSAGE OR RETLW BYTE
 BTFSS MIDI_BYTE,7;
 GOTO RET_FIE;
 ;TEST MIDI_BYTE FOR NOTE OFF ETC
 ;REMEMBER CHANNEL NO. 1 ONLY
 ;(EXCEPT SYSTEM MESSAGE)
 ;SET INITIAL MESSAGE NUMBER (0)
 MOVLW 0;
 MOVWF MSG_NR;
 MOVLW %10000000;
 SUBWF MIDI_BYTE,W;
 BTFSS STATUS,Z;
 GOTO NOT_M0;
 ;MESSAGE #0
 GOTO LCD_OUT;
NOT_M0: INCF MSG_NR,F;
 MOVLW %10010000;
 SUBWF MIDI_BYTE,W;
 BTFSS STATUS,Z;
 GOTO NOT_M1;
 ;MESSAGE #1
 GOTO LCD_OUT;
NOT_M1: INCF MSG_NR,F;
 MOVLW %10100000;
 SUBWF MIDI_BYTE,W;
 BTFSS STATUS,Z;
 GOTO NOT_M2;
 ;MESSAGE #2
 GOTO LCD_OUT;
NOT_M2: INCF MSG_NR,F;
 MOVLW %10110000;
 SUBWF MIDI_BYTE,W;
 BTFSS STATUS,Z;
 GOTO NOT_M3;
 ;MESSAGE #3
 GOTO LCD_OUT;
NOT_M3: INCF MSG_NR,F;
 MOVLW %11000000;
 SUBWF MIDI_BYTE,W;
 BTFSS STATUS,Z;
 GOTO NOT_M4;
 ;MESSAGE #4
 GOTO LCD_OUT;
NOT_M4: INCF MSG_NR,F;
 MOVLW %11010000;
 SUBWF MIDI_BYTE,W;
 BTFSS STATUS,Z;
 GOTO NOT_M5;
 ;MESSAGE #5
 GOTO LCD_OUT;
NOT_M5: INCF MSG_NR,F;
 MOVLW %11100000;
 SUBWF MIDI_BYTE,W;
 BTFSC STATUS,Z;
 ;MESSAGE #6
 GOTO LCD_OUT;
 ;MUST BE SYSTEM MESSAGE IF REACH HERE
 ;TEST SWITCH SYS FILTER STATE
 BTFSC SW_STATE,1;
 ;SKIP DISPLAY IF SYS FILTER ON
 GOTO RET_FIE; 
 ;CHECK FOR CLOCK SIGNAL
 MOVLW %11111000;
 SUBWF MIDI_BYTE,W;
 ;IF NOT CLOCK DISPLAY SYSTEM MESSAGE
 BTFSS STATUS,Z;
 GOTO SYS_MSG;
 ;TEST SWITCH CLOCK FILTER STATE
 BTFSC SW_STATE,0;
 ;SKIP DISPLAY IF CLOCK FILTER ON
 GOTO RET_FIE;
 ;OTHERWISE MESSAGE #7
 INCF MSG_NR,F;
 GOTO LCD_OUT;
 GOTO LCD_OUT;
SYS_MSG: INCF MSG_NR,F;
 INCF MSG_NR,F;
 ;MESSAGE #8
 GOTO LCD_OUT;
LCD_OUT: ;HOME THE LCD DISPLAY
 ;AND PRINT MESSAGE (LEAVE LINE 2)
 MOVF MSG_NR,W;
 MOVWF MSG_NR_TMP;
 CALL HM_LCD;
 MOVLW 9;
 MOVWF MSG_NR;
 CALL SND_LCD_MSG_RX;
 CALL HM_LCD;
 MOVF MSG_NR_TMP,W;
 MOVWF MSG_NR;
 CALL SND_LCD_MSG_RX;
 ;RETURN FROM INTERRUPT
RET_FIE: ;
 MOVF MS_OPT_NR_TP,W;
 MOVWF MS_OPT_NR;
 MOVF SW_STATE_TMP,W;
 MOVWF SW_STATE;
 MOVF MSG_NR_TMP_T,W ;
 MOVWF MSG_NR_TMP ;
 MOVF LCD_BYTE_TMP,W ;
 MOVWF LCD_BYTE ;
 MOVF TEMP_BYTE_TP,W;
 MOVWF TEMP_BYTE;
 MOVF RS_BYTE_TMP,W;
 MOVWF RS_BYTE;
 ;
 MOVF US_COUNT_TMP,W; 
 MOVWF US_COUNT; 
 MOVF MSG_NR_TP,W;
 MOVWF MSG_NR;
 MOVF MSG_ADR_OS_T,W;
 MOVWF MSG_ADR_OS;
 MOVF MSG_TB_PTR_T,W;
 MOVWF MSG_TB_PTR;
 MOVF LCD_IN_T_P_T,W;
 MOVWF LCD_IN_T_P;
 MOVF COUNT1_TMP,W;
 MOVWF COUNT1 ;
 MOVF VARMSCOUNT_T,W;
 MOVWF VARMSCOUNT;
 MOVF DLY_COUNT_TP,W;
 MOVWF DLY_COUNT;
 ;
 SWAPF STATUS_TEMP,W;
 MOVWF STATUS;
 SWAPF W_TEMP,F;
 SWAPF W_TEMP,W;
 RETFIE;
 ;+END OF INTERRUPT SUB-ROUTINE
 ;+START OF SUB-ROUTINES
 ;+INITIALISE VARIABLES SUB-ROUTINE
;
 ;DEFAULT VALUES
 ;FIRST PRESENTED MIDI MESSAGE =
 ;1 NOTE ON SO DEFAULT NEEDS TO BE 0
 ;TO ALLOW FOR FIRST INCF MS_OPT_NR
 ;IN MAIN PROGRAM
 ;TRANSMIT OPTION = 1 TRANSMIT
 ;REPEAT TYPE = 0 SAME AGAIN
IN_F_REG_RX: CLRF MIDI_BYTE;
 ;SET SW_STATE TO 14 TO ALLOW MESSAGE
 ;PRINTING FROM MESSAGE #12
 ;AND USE BITS 0 AND 1 AS SWITCH
 ;STATE FLAGS
 ;14 TO ALLOW FOR INCREMENT WHEN
 ;ENTERING MAIN PROGRAMME
 MOVLW 14;
 MOVWF SW_STATE;
 RETURN;
 ;+END OF INITIALISE VARIABLES SUB-R
 ;+INITIALISE I/O SUB-ROUTINE
 ;SET UP PORT A
 ;TRISA SET TO ALL INPUTS ON POWER-UP
 ;TRISA = %11-1 1111 AT POWER-UP
 ;CMCON SET TO %00000000 AT POWER-UP
 ;VRCON SET TO %00000000 AT POWER-UP
 ;CCP1CON SET TO %00000000 AT POWER-UP
 ;REMOVE INDETERMINATE STATES AND
 ;SET RA0, RA1 TO 1 (= SWITCH NOT
 ;PRESSED)
 ;BSF STATUS,RP0 ; BANK1;
 ;MOVLW %00000000;
 ;MOVWF TRISA;
 ;BCF STATUS,RP0 ; BANK0;
 ;MOVLW %00000011;
 ;MOVWF PORTA;
 ;BSF STATUS,RP0 ; BANK1;
 ;MOVLW %00000011;
 ;MOVWF TRISA;
 ;ENSURE CCP MODULE IS OFF
 ;SET UP TO USE SWITCHES ON RA0 AND RA1
 ;COMPARATORS OFF
INIT_IO: BCF STATUS,RP0 ; BANK0;
 MOVLW %00000111;
 MOVWF CMCON;
 ;END OF SET UP PORT A
 ;SET UP PORT B
 ;TRISB SET TO ALL INPUTS ON POWER-UP
 ;TRISB = %1111 1111 AT POWER-UP
 ;OPTION SET TO %11111111 AT POWER-UP
 ;USART RECEIVES RETLW ON RB1
 ;REMOVE INDETERMINATE STATES
 ;AND SET RB1, RB2 TO 1
 BSF STATUS,RP0 ; BANK1;
 MOVLW %00000110;
 MOVWF TRISB;
 ;SET RB1, RB2 AS I/P BOTH NEEDED
 ;FOR USART OPERATION
 ;OTHERS O/P
 BCF STATUS,RP0 ; BANK0;
 ;END OF SET UP PORT B
 RETURN;
 ;+END OF INITIALISE I/O SUB-ROUTINE
 ;+INITIALISE LCD MODULE SUB-ROUTINE
 ;WAIT 15MS MIN AFTER POWER-UP
 ;USE 20MS
 MOVLW 20;
 CALL MS_DLY;
 ;DURING THIS TIME THE MODULE
 ;INITIALISES THUS -
 ;CLEAR DISPLAY
 ;FUNCTION SET -
 ;8 BIT INTERFACE
 ;1 LINE DISPLAY
 ;5X7 DOT FONT
 ;DISPLAY CONTROL -
 ;DISPLAY OFF
 ;CURSOR OFF
 ;BLINK OFF
 ;ENTRY MODE SET -
 ;+1 INCREMENT
 ;DD RAM SELECTED
INIT_LCD: CLRF LCD_IN_T_P ;SET LOOKUP POINTER TO ZERO
NXT_LCD_INIT: MOVF LCD_IN_T_P,W ;MOVE LOOKUP POINTER INTO W
 CALL LCD_INIT_TB ;GET LCD SETUP RETLW
 ADDLW 0 ;SET Z FLAG IF W IS ZERO
 BTFSC STATUS,Z ;BIT TEST SKIP IF Z CLEAR
 GOTO END_INIT ;
 MOVWF LCD_BYTE ;
 CLRF RS_BYTE ;
 CALL SEND_LCD_BY ;
 ;SEND COMMAND RETLW TO LCD
 ;SEND TO LCD SIMULATOR
 MOVLW 15;WAIT 15MS BETWEEN EACH INITIALISATION
 CALL MS_DLY;COMMAND TO ENSURE LARGE MARGINS FOR
 ;PROPER INITIALISATION
 INCF LCD_IN_T_P,F ;
 GOTO NXT_LCD_INIT ;
END_INIT: RETURN;
 ;+END OF INITIALISE LCD MODULE SUB-R
 ;+INITIALISE USART SUB-ROUTINE
 ;SET UP FOR ASYNCHRONOUS TRANSMISSION
 ;TXSTA SET TO %00000010 AT POWER-UP
 ;RCSTA SET TO %0000000X AT POWER-UP
 ;SPBRG SET TO %00000000 AT POWER-UP
 ;PIE1 SET TO %00000000 AT POWER-UP
 ;PIR1 SET TO %00000000 AT POWER-UP
 ;RCREG SET TO %00000000 AT POWER-UP
 ;ENABLE SERIAL PORT
 ;SET RCSTA,SPEN
 ;SPEN = BIT 7 (0 AT POWER-UP)
 ;RETLW RECEIVED ON RB1
 ;RETLW TRANSMITTED ON RB2
 ;ENABLE ASYNCHRONOUS MODE -
 ;CLEAR TXSTA,SYNC (0 AT POWER-UP)
 ;SYNC = BIT 4
 ;INITIALISE USART FOR 31250 BAUD RATE
 ;(4MHZ XTAL)
 ;USE TXSTA,BRGH = 0 (LOW SPEED)
 ;BRGH = BIT 2 (0 AT POWER-UP)
 ;BR = FOSC/(64(X+1))
 ;X IS VALUE IN SPBRG
 ;X = 1 FOR 31250 BR
IN_USART_RX: BSF STATUS,RP0 ; BANK1; 
 MOVLW 1;
 MOVWF SPBRG;
 ;SET UP 8-BIT RECEPTION
 ;CLEAR RCSTA,RX9
 ;RX9 = BIT 6 (0 AT POWER-UP)
 ;CONFIGURE PORT B FOR USART
 BCF STATUS,RP0 ; BANK0;
 ;ENABLE SERIAL PORT
 ;SET RCSTA,SPEN
 ;SPEN = BIT 7 (0 AT POWER-UP)
 ;RETLW RECEIVED ON RB1
 ;RETLW TRANSMITTED ON RB2
 BSF RCSTA,SPEN;
 ;ENABLE INTERRUPTS
 BSF STATUS,RP0 ; BANK1
 BSF PIE1,RCIE;
 BCF STATUS,RP0 ; BANK0
 RETURN;
 ;+END OF INITIALISE USART SUB-ROUTINE
 ;+START OF INIT INTERRUPT CONTROL S-R
IN_INT_CON_RX: BCF STATUS,RP0 ; BANK0
 ;ENABLE PERIPHERAL INTERRUPTS
 BSF INTCON,PEIE ;
 ;ENABLE GLOBAL INTERRUPTS
 BSF INTCON,GIE ;
 RETURN;
 ;+END OF INIT INTERRUPT CONTROL S-R
 ;+SEND BYTE TO LCD SUB-ROUTINE
SEND_LCD_BY: MOVF LCD_BYTE,W;
 MOVWF TEMP_BYTE ;
 MOVF TEMP_BYTE,W ;MOVE RETLW INTO W
 ANDLW %11110000 ;CLEAR BOTTOM 4 BITS OF W
 IORWF RS_BYTE,W ;OR THE RS BIT INTO W
 MOVWF PORTB ;MOVE W INTO PORT B
 MOVLW 1 ;ENSURE RETLW AND RS STABLE
 CALL MS_DLY ;
 BSF PORTB,RB3 ;SET E LINE OF LCD HIGH
 MOVLW 1 ;ENSURE PULSE WIDE ENOUGH (450NS MIN)
 CALL MS_DLY ;
 BCF PORTB,RB3 ;RESET E LINE OF LCD LOW
 MOVLW 1 ;1MS DELAY ENSURE RETLW AND RS STABLE
 CALL MS_DLY ;AFTER E GOES LOW AND ALSO THROUGHPUT
 ;NOT TOO FAST (EVERY 40US MAX)
 MOVF LCD_BYTE,W ;
 MOVWF TEMP_BYTE ;
 SWAPF TEMP_BYTE,F ;SWAP TOP 4 BITS WITH
 ;BOTTOM 4
 MOVF TEMP_BYTE,W ;MOVE RETLW INTO W
 ANDLW %11110000 ;CLEAR BOTTOM 4 BITS OF W
 IORWF RS_BYTE,W ;OR THE RS BIT INTO W
 MOVWF PORTB ;MOVE W INTO PORT B
 MOVLW 1 ;ENSURE DATA AND RS STABLE
 CALL MS_DLY ;
 BSF PORTB,RB3 ;SET E LINE OF LCD HIGH
 MOVLW 1 ;ENSURE PULSE WIDE ENOUGH (450NS MIN)
 CALL MS_DLY ;
 BCF PORTB,RB3 ;RESET E LINE OF LCD LOW
 MOVLW 1 ;1MS DELAY ENSURE RETLW AND RS STABLE
 CALL MS_DLY ;AFTER E GOES LOW AND ALSO THROUGHPUT
 ;NOT TOO FAST (EVERY 40US MAX)
 RETURN ;
 ;+END OF SEND BYTE TO LCD SUB-ROUTINE
 ;+MILLISECONDS DELAY SUB-ROUTINE
 ;ENTER ROUTINE WITH NO. OF MILLI-
 ;SECONDS REQUIRED IN W 
MS_DLY: ;
 MOVWF DLY_COUNT ;
MS1_LP: CALL MS1DLY ;
 DECFSZ DLY_COUNT,F ;
 GOTO MS1_LP ;
 RETURN ;
 ;+END OF MILLISECONDS DELAY SUB-R
 ;+START OF 1MS DELAY SUBROUTINE
MS1DLY: MOVLW 248 ;MOVE THE REQUIRED LOOP NUMBER INTO
 MOVWF VARMSCOUNT ;VARMSCOUNT
MSLOOP: NOP ;
 DECFSZ VARMSCOUNT,F ;DECREMENT THE COUNTER AND
 GOTO MSLOOP ;LOOP UNTIL THE COUNTER IS ZERO
 NOP ;TOTAL NUMBER OF INSTRUCTIONS INCLUDING
 NOP ;CALL AND RETURN = 1000 HENCE 1MS
 NOP ;FOR 4MHZ CLOCK
 RETURN ;+END OF 1MS DELAY SUBROUTINE
 ;+SEND RX LCD MESSAGE SUB-ROUTINE
 ;ENTER ROUTINE WITH REQUIRED MESSAGE
 ;NUMBER (NUMBER IN MSG_TBL_RX TABLE)
 ;IN MSG_NR FILE REGISTER
SND_LCD_MSG_RX: ;GET THE RELEVANT MESSAGE POINTER
 CALL GT_MS_TB_P_RX ;
 ;GET THE NEXT TABLE ENTRY
 MOVF MSG_TB_PTR,W ;
NXT_TB_RX: CALL MSG_TBL_RX ;
 MOVWF LCD_BYTE ;SAVE IT IN LCD_BYTE
 ;TEST IF IT IS END MARKER '#'
 ;AND RETURN IF IT IS
 SUBLW '#' ;
 BTFSC STATUS,Z ;
 GOTO END_MSG ;
 ;SEND IT TO LCD DISPLAY IF NOT
 ;TEXT MODE
 BSF RS_BYTE,0 ;
 ;BSF RS_BYTE,4 ;
 CALL SEND_LCD_BY ;
 ;SEND TEXT DATA TO LCD
 ;CALL SNDLCDBY_SM ;
 ;DELAY 10MS (1.6 MS NEEDED -
 ;CLEAR AND HOME)
 MOVLW 10 ;
 CALL MS_DLY ;
 ;INCREMENT MESSAGE TABLE POINTER
 ;AND GET NEXT TABLE ENTRY
 INCF MSG_TB_PTR,F ;
 MOVF MSG_TB_PTR,W ;
 GOTO NXT_TB_RX ;
END_MSG: RETURN;
 ;+END OF SEND RX LCD MESSAGE SUB-ROUTINE
 ;+CLEAR & HOME LCD CURSOR SUB-ROUTINE
CLR_HM_LCD: ;DELAY FOR LCD INSTRUCTION TIMING
 MOVLW 10 ;
 CALL MS_DLY ;
 ;DATA MODE
 BCF RS_BYTE,0 ;
 ;BCF RS_BYTE,4 ;
 ;CLEAR DISPLAY AND HOME CURSOR
 MOVLW $01 ;
 MOVWF LCD_BYTE ;
 ;SEND TO LCD
 CALL SEND_LCD_BY ;
 ;CALL SNDLCDBY_SM ;
 ;CALL LCD_SIM_FX1 ;
 ;(DEBUG FIX)
 ;DELAY FOR LCD INSTRUCTION TIMING
 MOVLW 10 ;
 CALL MS_DLY ;
 RETURN ;
 ;+END OF CLEAR & HOME LCD CURSOR S-R
 ;+MOVE LCD CURSOR TO 2ND LINE S-R
MV_LCD_LN2: MOVLW 10 ;DELAY FOR LCD INSTRUCTION TIMING
 CALL MS_DLY ;
 ;DATA MODE
 BCF RS_BYTE,0 ;
 ;BCF RS_BYTE,4 ;
 ;MOVE CURSOR TO START OF 2ND LINE
 MOVLW $0C0 ;
 MOVWF LCD_BYTE ;
 CALL SEND_LCD_BY ;
 ;SEND TO LCD
 ;DELAY FOR LCD INSTRUCTION TIMING
 MOVLW 10 ;
 CALL MS_DLY ;
 RETURN ;
 ;+END OF MOVE LCD CURSOR TO 2ND LINE S-R
 ;+NEXT SWITCH STATE SUB-ROUTINE
 ;SWITCH STATE OPTION NUMBERS 12 TO 14
 ;CORRESPONDING TO 3 RECEIVE TYPE
 ;CHOICES - 12 ADDED FOR EASE OF
 ;DISPLAYING MESSAGES
NXT_SW_STATE: INCF SW_STATE,F ;
 MOVF SW_STATE,W ;
 SUBLW 15 ;
 BTFSS STATUS,Z ;
 GOTO RET_SW_ST ;
 MOVLW 12 ;
 MOVWF SW_STATE ;
RET_SW_ST: RETURN ;
 ;+END OF NEXT MIDI MESSAGE OPTION S-R
 ;+GET RX MESSAGE TABLE POINTER S-R
GT_MS_TB_P_RX: MOVF MSG_NR,W ;
 ;GET MESSAGE ADDRESS OFFSET
 CALL MSG_OF_TB_RX ;
 MOVWF MSG_ADR_OS ;
 ;MOVE IT TO THE MESSAGE TABLE POINTER
 MOVWF MSG_TB_PTR ;
 RETURN ;
 ;+END OF GET RX MESSAGE TABLE PNTR S-R
LCD_SIM_FX1: BCF RS_BYTE,0 ;
 ;HOME CURSOR
 MOVLW $02 ;
 MOVWF LCD_BYTE ;
 CALL SEND_LCD_BY ;
 RETURN ;
 ;+END OF LCD SIMULATOR
 ;+HOME LCD CURSOR SUB-ROUTINE
 ;(DON'T CLEAR)
 ;DELAY FOR LCD INSTRUCTION TIMING
HM_LCD: MOVLW 10 ;
 CALL MS_DLY ;
 ;DATA MODE
 BCF RS_BYTE,0 ;
 ;HOME CURSOR
 MOVLW $02 ;
 MOVWF LCD_BYTE ;
 CALL SEND_LCD_BY ;
 CALL SNDLCDBY_SM ;SEND TO LCD SIMULATOR
 ;DELAY FOR LCD INSTRUCTION TIMING
 MOVLW 10 ;
 CALL MS_DLY ;
 RETURN ;
 ;+END OF HOME LCD CURSOR S-R
 ;+GET MODE TYPE SUB-ROUTINE
 ;
 ;SELECT ONE OF THE 3 RECEIVE TYPE
 ;OPTIONS - NOTE OFF TO SYSTEM MESSAGE
 ;- 0 TO 7 - DEFAULT =1 NOTE ON
 ;INCREMENT TO ALLOW FOR CHANGE WHEN
 ;RUNNING
GET_MODE_TYPE: CALL NXT_SW_STATE ;
 ;DISPLAY CURRENT RECEIVE MODE
 ;ON LCD LINE 1
 CALL CLR_HM_LCD ;
 CALL DISP_RX_TYP ;
 ;DISPLAY CHANGE/ACCEPT? MESSAGE
 ;ON LCD LINE 2
 CALL CLR_HM_LN2 ;
 MOVLW 10 ;
 MOVWF MSG_NR ;
 CALL SND_LCD_MSG_RX ;
 ;TEST THE EDIT SWITCH
 ;IF PRESSED OFFER THE NEXT
 ;MESSAGE OPTION ON LCD LINE 1
LP_BK: BTFSC PORTA,RA0 ;
 GOTO NOT_PR_ED ;
 CALL NXT_SW_STATE ;
 CALL CLR_HM_LCD ;
 CALL DISP_RX_TYP ;
 ;DISPLAY CHANGE/ACCEPT? MESSAGE
 ;ON LCD LINE 2
 CALL CLR_HM_LN2 ;
 MOVLW 10 ;
 MOVWF MSG_NR ;
 CALL SND_LCD_MSG_RX ;
 ;THEN WAIT UNTIL EDIT SWITCH RELEASED
ED_NT_R: BTFSS PORTA,RA0 ;
 GOTO ED_NT_R ;
 ;OTHERWISE
 ;TEST THE ACCEPT SWITCH
NOT_PR_ED: BTFSC PORTA,RA1 ;
 GOTO LP_BK;
 ;IF NOT PRESSED GO BACK ROUND THE GET
 ;MESSAGE TYPE LOOP AGAIN
 ;OTHERWISE WAIT UNTIL NOT PRESSED
STL_PRSD: BTFSS PORTA,RA1 ;
 GOTO STL_PRSD ;
 ;THEN RETURN WITH CURRENT RECEIVE TYPE
 ;IN SW_STATE FILE
 ;REGISTER AND MODE DISPLAYED 
 ;ON LINE 2
 CALL CLR_HM_LCD ;
 CALL MV_LCD_LN2 ;
 MOVF SW_STATE,W ;
 MOVWF MSG_NR ;
 CALL SND_LCD_MSG_RX ;
 RETURN ;
 ;+END OF GET MODE TYPE S-R
 ;+WAIT FOR NO SWITCH PRESSED S-R
W8_NO_SW: ;
W8_1: BTFSS PORTA,RA0 ;
 GOTO W8_1;
W8_2: BTFSS PORTA,RA1 ;
 GOTO W8_2 ;
 RETURN ;
 ;+END OF WAIT FOR NO SWITCH PRESSED
 ;+DISPLAY RECEIVE MODE TYPE SUB-ROUTINE
 ;
 ;MAKE LCD MESSAGE NUMBER THE
 ;REQUIRED ONE
DISP_RX_TYP: MOVF SW_STATE,W ;
 MOVWF MSG_NR ;
 CALL SND_LCD_MSG_RX ;
 RETURN ;
 ;+END OF DISPLAY MIDI MESSAGE TYPE S-R
 ;+WAIT FOR A SWITCH PRESS S-R
W8_SW_PR: ;
LP_BK2: BTFSC PORTA,RA0 ;
 GOTO W8_3 ;
 GOTO SW0_PR ;
W8_3: BTFSC PORTA,RA1 ;
 GOTO LP_BK2 ;
SW0_PR: RETURN ;
 ;+END OF WAIT FOR NO SWITCH PRESSED
 ;+PRINT BLANK LCD LINE SUB-ROUTINE
CLR_HM_LN2: CALL MV_LCD_LN2 ;
 MOVLW 9 ;
 MOVWF MSG_NR ;
 CALL SND_LCD_MSG_RX ;
 CALL MV_LCD_LN2 ;
 RETURN ;
 ;+END OF PRINT BLANK LCD LINE S-R
 ;+ENABLE SERIAL PORT SUB-ROUTINE
 ;SET RCSTA,SPEN
 ;SPEN = BIT 7 (0 AT POWER-UP)
 ;RETLW RECEIVED ON RB1
 ;RETLW TRANSMITTED ON RB2
 ;ENABLE ASYNCHRONOUS MODE
 ;CLEAR TXSTA,SYNC (0 AT POWER-UP)
EN_SER_PORT: BCF STATUS,RP0 ; BANK0
 BSF RCSTA,SPEN ;
 RETURN ;
 ;+END OF ENABLE SERIAL PORT S-R
 ;+DISABLE SERIAL PORT SUB-ROUTINE 
DIS_SER_PRT: BCF STATUS,RP0 ; BANK0
 BCF RCSTA,SPEN ;
 BSF STATUS,RP0 ; BANK1
 BCF TRISB,2 ;
 BCF TRISB,1 ;
 BCF STATUS,RP0 ; BANK0
 RETURN ;
 ;+END OF DISABLE SERIAL PORT S-R
 ;+SEND BYTE TO LCD SIMULATOR SUB-ROUTINE
SNDLCDBY_SM: MOVF LCD_BYTE,W ;
 MOVWF TEMP_BYTE ;
 SWAPF TEMP_BYTE,F ;SWAP TOP 4 BITS WITH BOTTOM 4
 MOVF TEMP_BYTE,W ;MOVE RETLW INTO W
 ANDLW 15;CLEAR TOP 4 BITS OF W
 IORWF RS_BYTE,W ;OR THE RS BIT INTO W
 MOVWF PORTB ;MOVE W INTO PORT B
 MOVLW 1 ;ENSURE RETLW AND RS STABLE
 CALL MS_DLY ;
 BSF PORTB,5 ;SET E LINE OF LCD HIGH
 MOVLW 1 ;ENSURE PULSE WIDE ENOUGH (450NS MIN)
 CALL MS_DLY ;
 BCF PORTB,5 ;RESET E LINE OF LCD LOW
 MOVLW 1 ;1MS DELAY ENSURE RETLW AND RS STABLE
 CALL MS_DLY ;AFTER E GOES LOW AND ALSO THROUGHPUT
 ;NOT TOO FAST (EVERY 40US MAX)
 MOVF LCD_BYTE,W ;
 MOVWF TEMP_BYTE ;
 MOVF TEMP_BYTE,W ;MOVE DATA INTO W
 ANDLW 15 ;CLEAR TOP 4 BITS OF W
 IORWF RS_BYTE,W ;OR THE RS BIT INTO W
 MOVWF PORTB ;MOVE W INTO PORT B
 MOVLW 1 ;ENSURE RETLW AND RS STABLE
 CALL MS_DLY ;
 BSF PORTB,5 ;SET E LINE OF LCD HIGH
 MOVLW 1 ;ENSURE PULSE WIDE ENOUGH (450NS MIN)
 CALL MS_DLY ;
 BCF PORTB,5 ;RESET E LINE OF LCD LOW
 MOVLW 1 ;1MS DELAY ENSURE RETLW AND RS STABLE
 CALL MS_DLY ;AFTER E GOES LOW AND ALSO THROUGHPUT
 ;NOT TOO FAST (EVERY 40US MAX)
 RETURN ;
 ;+END OF SEND BYTE TO LCD SIMULATOR S-R
 ;+160US DELAY SUB-ROUTINE
DLY_160US: ;
 MOVLW 160 ;
DLY160_LP: MOVWF US_COUNT ;
 DECF US_COUNT,W ;
 BTFSS STATUS,Z ;
 GOTO DLY160_LP ;
 RETURN ;
 ;+END OF 160US DELAY SUB-ROUTINE
 ;+GET NEXT DATA SUB-ROUTINE
 ;
 ;ENABLE SERIAL PORT
NXT_DAT: ;SET RCSTA,SPEN
 ;SPEN = BIT 7 (0 AT POWER-UP)
 ;DATA RECEIVED ON RB1
 ;DATA TRANSMITTED ON RB2
 ;ENABLE RECEPTION
 ;SET RCSTA,CREN
 ;CREN = BIT 4
 ;CREN = 0 AT POWER-UP
L1: ;SAVE RCREG IN MIDI_BYTE
 MOVF RCREG,W ;
 MOVWF MIDI_BYTE ;
 BCF RCSTA,CREN ;
 RETURN ;
 ;+END OF GET NEXT RETLW SUB-ROUTINE
 ;+START OF SWITCH 0 PRESSED S-R
 ;
 ;DISABLE INTERRUPTS
SW_0_PRESS: BCF INTCON,GIE ;
 ;TOGGLE SW0 STATE BIT
 BTFSC SW_STATE,0 ;
 GOTO SW0_2_0 ;
 BSF SW_STATE,0 ;
 GOTO RET_SW_0 ;
SW0_2_0: BCF SW_STATE,0;
RET_SW_0: CALL DISP_OPT ;
 RETURN ;
 ;+END OF SWITCH 0 PRESSED S-R
 ;+START OF SWITCH 1 PRESSED S-R
 ;
 ;DISABLE INTERRUPTS
SW_1_PRESS: BCF INTCON,GIE ;
 ;TOGGLE SW1 STATE BIT
 BTFSC SW_STATE,1 ;
 GOTO SW1_2_0 ;
 BSF SW_STATE,1 ;
 GOTO RET_SW_1 ;
SW1_2_0: BCF SW_STATE,1 ;
RET_SW_1: CALL DISP_OPT ;
 RETURN ;
 ;+END OF SWITCH 1 PRESSED S-R
 ;+DISPLAY SWITCH OPTIONS SUB-ROUTINE
 ;DISPLAY SWITCH OPTIONS
 ;
 ;TEST FOR NO SYSTEM MESSAGES
DISP_OPT: BTFSC SW_STATE,1 ;
 GOTO NO_SYS ;
SYS: BTFSC SW_STATE,0 ;
 GOTO NO_CLK ;
SYS_CLK: MOVLW 12 ;
 GOTO LCD_OUT_OPT ;
NO_SYS: MOVLW 15 ;
 GOTO LCD_OUT_OPT ;
NO_CLK: MOVLW 13 ;
LCD_OUT_OPT: MOVWF MSG_NR_TMP ;
 CALL CLR_HM_LN2 ;
 MOVF MSG_NR_TMP,W ;
 MOVWF MSG_NR ;
 CALL SND_LCD_MSG_RX ;
 RETURN ;
 ;+END OF DISPLAY SWITCH OPTIONS S-R
 ;+END OF SUB-ROUTINES
 ;INITIALISE TX FILE REGISTERS
INIT_TX: CALL IN_F_REG_TX ;
 ;INITIALISE TX USART
 CALL IN_USART_TX ;
 ;INCREMENT MIDI MESSAGE NUMBER TO
 ;ALLOW FOR RETURN FROM CHANGE OPTION?
 ;AFTER TRANSMIT
 ;NB INITIALISATION VALUE MUST BE 0
 ;SO FIRST PRESENTED OPTION AT POWER-
 ;UP IS 1
GET_NEW_MES: INCF MS_OPT_NR,F ;
 ;CHECK NOT OVERRUN MESSAGE NO.
 MOVF MS_OPT_NR,W ;
 SUBLW 8 ;
 BTFSC STATUS,Z ;
 CLRF MS_OPT_NR ;
 ;SELECT THE REQUIRED MIDI MESSAGE
 ;OPTION
 CALL GET_MS_TYPE ;
 ;RETURN WITH SELECTED VALUE DISPLAYED
 ;AND MIDI MESSAGE NUMBER IN MS_OPT_NR
 ;FILE REGISTER
 ;
 ;SELECT REQUIRED TX TYPE
 CALL GET_TX_TYPE;
 ;RETURN WITH SELECTED VALUE DISPLAYED
 ;AND TX MODE NUMBER IN TX_OPT_NR
 ;FILE REGISTER
 ;TEST FOR TX TYPE = CHANGE MESSAGE
GT_NW_TX_TP: MOVF TX_OPT_NR,W ;
 SUBLW 0 ;
 BTFSC STATUS,Z ;
 GOTO GET_NEW_MES ;
 ;IF SO JUMP BACK TO GET NEW MESSAGE
 ;IF NOT CONTINUE
RPT_SAME: CALL TX_MODULE ;
 CALL GT_RPT_TYP ;
 ;RETURN WITH SELECTED VALUE DISPLAYED
 ;AND REPEAT TYPE NUMBER IN RPT_TYP_NR
 ;FILE REGISTER
 ;ACT ON REPEAT TYPE SELECTED
 ;TEST FOR REPEAT SAME
 MOVF RPT_TYP_NR,W ;
 SUBLW 0 ;
 BTFSC STATUS,Z ;
 GOTO RPT_SAME ;
 ;TEST FOR CHANGE TX TYPE
 ;IF REACH HERE MUST BE
 ;CHANGE MIDI MESSAGE
 GOTO GET_NEW_MES ;
 ;END OF TX PROGRAMME
 ;+INITIALISE TX VARIABLES SUB-ROUTINE
 ;
 ;DEFAULT VALUES
 ;FIRST PRESENTED MIDI MESSAGE =
 ;1 NOTE ON SO DEFAULT NEEDS TO BE 0
 ;TO ALLOW FOR FIRST INCF MS_OPT_NR
 ;IN MAIN PROGRAM
IN_F_REG_TX: MOVLW 0 ;
 MOVWF MS_OPT_NR ;
 ;TRANSMIT OPTION = 1 TRANSMIT
 MOVLW 1 ;
 MOVWF TX_OPT_NR ;
 ;REPEAT TYPE = 0 SAME AGAIN
 CLRF RPT_TYP_NR ;
 RETURN ;
 ;+END OF INITIALISE TX VARIABLES SUB-R
 ;+INITIALISE TX USART SUB-ROUTINE
 ;SET UP FOR ASYNCHRONOUS TRANSMISSION
 ;TXSTA SET TO %00000010 AT POWER-UP
 ;RCSTA SET TO %0000000X AT POWER-UP
 ;SPBRG SET TO %00000000 AT POWER-UP
 ;PIE1 SET TO %00000000 AT POWER-UP
 ;PIR1 SET TO %00000000 AT POWER-UP
 ;RCREG SET TO %00000000 AT POWER-UP
 ;ENABLE SERIAL PORT
 ;SET RCSTA,SPEN
 ;SPEN = BIT 7 (0 AT POWER-UP)
 ;RETLW RECEIVED ON RB1
 ;RETLW TRANSMITTED ON RB2
 ;ENABLE ASYNCHRONOUS MODE -
 ;CLEAR TXSTA,SYNC (0 AT POWER-UP)
 ;SYNC = BIT 4
 ;INITIALISE USART FOR 31250 BAUD RATE
 ;(4MHZ XTAL)
 ;USE TXSTA,BRGH = 0 (LOW SPEED)
 ;BRGH = BIT 2 (0 AT POWER-UP)
 ;BR = FOSC/(64(X+1))
 ;X IS VALUE IN SPBRG
 ;X = 1 FOR 31250 BR
IN_USART_TX: BSF STATUS,RP0 ; BANK1 
 MOVLW 1 ;
 MOVWF SPBRG ;
 ;SET UP 8-BIT RECEPTION
 ;CLEAR RCSTA,RX9
 ;RX9 = BIT 6 (0 AT POWER-UP)
 ;DISABLE INTERRUPTS
 ;CLEAR PIE1,RCIE
 ;RCIE = BIT 5 (0 AT POWER-UP)
 ;CLEAR TXIE
 ;PIE1,TXIE
 ;TXIE = BIT4 (0 AT POWER-UP)
 ;SET UP 8-BIT TRANSMISSION
 ;CLEAR TXSTA,TX9
 ;TX9 = BIT 6 (0 AT POWER-UP)
 ;ENABLE RECEPTION -
 ;SET RCSTA,CREN
 ;CREN = BIT 4
 ;ENABLE TRANSMISSION -
 ;SET TXSTA,TXEN
 ;TXEN = BIT 5
 ;TRANSMIT DATA WHEN LOAD RETLW TO
 ;TXREG REGISTER
 ;TRMT FLAG =
 ;TRANSMIT SHIFT REGISTER EMPTY
 ;(= 1 AT POWER-UP)
 ;TXSTA,TRMT
 ;TRMT = BIT 1, READ-ONLY
 ;PIR1,RCIF SET WHEN RECEPTION
 ;COMPLETE
 ;RCIF = BIT 5
 ;INTERRUPT GENERATED IF RCIE SET
 ;9TH BIT IN RCSTA,RX9D IF 9TH
 ;BIT ENABLED
 ;READ 8-BIT RETLW IN RCREG
 ;ERROR FLAGS -
 ;RCSTA,FERR FRAMING ERROR
 ;FERR = BIT 2
 ;RCSTA,OERR OVERRUN ERROR
 ;OERR = BIT 1
 ;CLEAR ERROR BY CLEARING RCSTA,CREN
 BCF STATUS,RP0 ; BANK0
 RETURN ;
 ;+END OF INIT TX USART S-R
 ;+GET TX MESSAGE TYPE SUB-ROUTINE
 ;SELECT ONE OF THE EIGHT MIDI MESSAGE
 ;OPTIONS - NOTE OFF TO SYSTEM MESSAGE
 ;- 0 TO 7 - DEFAULT =1 NOTE ON
 ;DISPLAY CURRENT MIDI MESSAGE VALUE
 ;ON LCD LINE 1
GET_MS_TYPE: CALL CLR_HM_LCD ;
 CALL DISP_MS_TYP ;
 ;SAVE CURRENT MESSAGE NUMBER
 MOVF MS_OPT_NR,W ;
 MOVWF MS_OPT_TMP ;
 ;DISPLAY CHANGE/ACCEPT? MESSAGE
 ;ON LCD LINE 2
 MOVLW 10 ;
 MOVWF MS_OPT_NR ;
 CALL CLR_HM_LN2 ;
 CALL DISP_MS_TYP ;
 ;RESTORE CURRENT MESSAGE NUMBER
 MOVF MS_OPT_TMP,W ;
 MOVWF MS_OPT_NR ;
 ;TEST THE EDIT SWITCH
 ;IF PRESSED OFFER THE NEXT
 ;MESSAGE OPTION ON LCD LINE 1
LP_BK3: BTFSC PORTA,RA0 ;
 GOTO SKP_1 ;
 CALL NXT_MS_OPT ;
 CALL CLR_HM_LCD ;
 CALL DISP_MS_TYP ;
 ;SAVE CURRENT MESSAGE NUMBER
 MOVF MS_OPT_NR,W ;
 MOVWF MS_OPT_TMP ;
 ;DISPLAY CHANGE/ACCEPT? MESSAGE
 ;ON LCD LINE 2
 MOVLW 10 ;
 MOVWF MS_OPT_NR ;
 CALL CLR_HM_LN2 ;
 CALL DISP_MS_TYP ;
 ;RESTORE CURRENT MESSAGE NUMBER
 MOVF MS_OPT_TMP,W ;
 MOVWF MS_OPT_NR ;
 ;THEN WAIT UNTIL EDIT SWITCH RELEASED
EDT_ST_PR: BTFSS PORTA,RA0 ;
 GOTO EDT_ST_PR ;
 ;OTHERWISE
 ;TEST THE ACCEPT SWITCH
SKP_1: BTFSC PORTA,RA1 ;
 GOTO LP_BK3 ;
 ;IF NOT PRESSED GO BACK ROUND THE GET
 ;MESSAGE TYPE LOOP AGAIN
 ;OTHERWISE WAIT UNTIL NOT PRESSED
SW1_ST_PR: BTFSS PORTA,RA1 ;
 GOTO SW1_ST_PR ;
 ;THEN RETURN WITH CURRENT MIDI MESSAGE
 ;OPTION NUMBER IN MS_OPT_NR FILE
 ;REGISTER AND DISPLAYED ON LCD LINE 1
 RETURN ;
 ;+END OF GET MESSAGE TYPE S-R
 ;+GET TRANSMIT TYPE SUB-ROUTINE
 ;
 ;SELECT ONE OF THREE OPTIONS -
 ;0 - GO BACK TO CHANGE MESSAGE
 ;1 - TRANSMIT?
 ;2 - CONTINUOUS (NOT AVAILABLE)
 ;DEFAULT = 1
GET_TX_TYPE: MOVLW 1 ;
 MOVWF TX_OPT_NR ;
 ;DISPLAY CURRENT TRANSMISSION TYPE
 ;ON LCD LINE 2
 CALL CLR_HM_LN2 ;
 CALL DISP_TX_TYP ;
 ;
 ;TEST EDIT SWITCH
LP_BK4: BTFSC PORTA,RA0 ;
 GOTO NOT_ED ;
 ;IF PRESSED -
 ;GET NEXT TX TYPE OPTION
 CALL TX_TYP_OPT ;
 ;MOVE LCD CURSOR TO LINE 2
 CALL CLR_HM_LN2 ;
 ;DISPLAY THE OPTION
 CALL DISP_TX_TYP ;
 ;THEN WAIT UNTIL EDIT SWITCH RELEASED
ED_PRS: BTFSS PORTA,RA0 ;
 GOTO ED_PRS ;
 ;OTHERWISE
 ;TEST THE ACCEPT SWITCH
NOT_ED: BTFSC PORTA,RA1 ;
 GOTO LP_BK4 ;
 ;IF NOT PRESSED GO BACK ROUND THE GET
 ;TRANSMISSION TYPE LOOP AGAIN
 ;OTHERWISE WAIT UNTIL NOT PRESSED
SW1_P: BTFSS PORTA,RA1 ;
 GOTO SW1_P ;
 ;THEN RETURN WITH CURRENT TRANSMISSION
 ;OPTION NUMBER IN TX_OPT_NR FILE
 ;REGISTER AND DISPLAYED ON LCD LINE 2
 RETURN ;
 ;+END OF GET TRANSMIT TYPE S-R
 ;+DISPLAY TX TYPE SUB-ROUTINE
 ;MAKE LCD MESSAGE NUMBER THE
 ;REQUIRED ONE
DISP_TX_TYP: MOVF TX_OPT_NR,W ;
 ;ADD 8 TO THE TX OPTION NUMBER TO
 ;GIVE CORRECT LCD MESSAGE NUMBER
 ADDLW 8 ;
 MOVWF MSG_NR ;
 CALL SND_LCD_MSG_TX ;
 RETURN ;
 ;+END OF DISPLAY TX TYPE SUB-ROUTINE
 ;+GET TX TYPE SUB-ROUTINE
 ;
 ;TX MESSAGE OPTION NUMBERS 0 TO 2
 ;0 - BACK TO CHANGE MESSAGE
 ;1 - TRANSMIT?
 ;2 - CONTINUOUS (NOT AVAILABLE)
 ;DEFAULT VALUE = 1
TX_TYP_OPT: INCF TX_OPT_NR,F ;
 MOVF TX_OPT_NR,W ;
 SUBLW 2 ;
 BTFSC STATUS,Z ;
 CLRF TX_OPT_NR ;
 RETURN ;
 ;+END OF GET TX TYPE S-R
 ;+SEND TX LCD MESSAGE SUB-ROUTINE
 ;ENTER ROUTINE WITH REQUIRED MESSAGE
 ;NUMBER (NUMBER IN MSG_TBL_RX TABLE)
 ;IN MSG_NR FILE REGISTER
SND_LCD_MSG_TX: ;
 ;GET THE RELEVANT MESSAGE POINTER
 CALL GT_MS_TB_P_TX ;
 ;GET THE NEXT TABLE ENTRY
 MOVF MSG_TB_PTR,W ;
NXT_T_ENT: CALL MSG_TBL_TX ;
 ;RESET PCLATH
 BCF PCLATH,0 ;
 MOVWF LCD_BYTE ;SAVE IT IN LCD_BYTE
 ;TEST IF IT IS END MARKER '#'
 ;AND RETURN IF IT IS
 SUBLW '#' ;
 BTFSC STATUS,Z ;
 GOTO END_MSG_TX ;
 ;SEND IT TO LCD DISPLAY IF NOT
 ;TEXT MODE
 BSF RS_BYTE,0 ;
 CALL SEND_LCD_BY ;
 ;SEND TEXT RETLW TO LCD
 ;DELAY 10MS (1.6 MS NEEDED -
 ;CLEAR AND HOME)
 MOVLW 10 ;
 CALL MS_DLY ;
 ;INCREMENT MESSAGE TABLE POINTER
 ;AND GET NEXT TABLE ENTRY
 INCF MSG_TB_PTR,F ;
 MOVF MSG_TB_PTR,W ;
 GOTO NXT_T_ENT ;
END_MSG_TX: RETURN ;
 ;+END OF SEND TX LCD MESSAGE SUB-ROUTINE
 ;+DISPLAY TX MIDI MESSAGE TYPE S-R
 ;MAKE LCD MESSAGE NUMBER THE
 ;REQUIRED ONE
DISP_MS_TYP: MOVF MS_OPT_NR,W ;
 MOVWF MSG_NR ;
 CALL SND_LCD_MSG_TX ;
 RETURN ;
 ;+END OF DISPLAY TX MIDI MESSAGE S-R
 ;+GET TX MESSAGE TABLE POINTER S-R
GT_MS_TB_P_TX: MOVF MSG_NR,W ;
 ;GET MESSAGE ADDRESS OFFSET
 CALL MSG_OF_TB_TX ;
 ;RESET PCLATH
 BCF PCLATH,0 ;
 MOVWF MSG_ADR_OS ;
 ;MOVE IT TO THE MESSAGE TABLE POINTER
 MOVWF MSG_TB_PTR ;
 RETURN ;
 ;+END OF GET TX MESSAGE TABLE PNTR S-R
 ;+GET TX REPEAT TYPE S-R
 ;SELECT ONE OF THREE OPTIONS -
 ;0 - REPEAT SAME
 ;1 - CHANGE MESSAGE TYPE
 ;DEFAULT = 0
GT_RPT_TYP: MOVLW 0 ;
 MOVWF RPT_TYP_NR ;
 ;DISPLAY CURRENT REPEAT TYPE
 ;ON LCD LINE 2
 CALL CLR_HM_LN2 ;
 CALL DSP_RPT_TYP ;
 ;TEST EDIT SWITCH
LP_BK5: BTFSC PORTA,RA0 ;
 GOTO NO_ED ;
 ;IF PRESSED -
 ;GET NEXT REPEAT TYPE OPTION
 CALL RPT_TYP_OPT ;
 ;MOVE LCD CURSOR TO LINE 2
 CALL CLR_HM_LN2 ;
 ;DISPLAY THE OPTION
 CALL DSP_RPT_TYP ;
 ;THEN WAIT UNTIL EDIT SWITCH RELEASED
SW0_N_RL: BTFSS PORTA,RA0 ;
 GOTO SW0_N_RL ;
 ;OTHERWISE
 ;TEST THE ACCEPT SWITCH
NO_ED: BTFSC PORTA,RA1 ;
 GOTO LP_BK5 ;
 ;IF NOT PRESSED GO BACK ROUND THE GET
 ;REPEAT TYPE LOOP AGAIN
 ;OTHERWISE WAIT UNTIL NOT PRESSED
S_P_SW1: BTFSS PORTA,RA1;
 GOTO S_P_SW1 ;
 ;THEN RETURN WITH CURRENT REPEAT TYPE
 ;OPTION NUMBER IN RPT_OPT_NR FILE
 ;REGISTER AND DISPLAYED ON LCD LINE 2
 RETURN ;
 ;+END OF GET TX REPEAT TYPE S-R
 ;+DISPLAY TX REPEAT TYPE SUB-ROUTINE
 ;MAKE LCD MESSAGE NUMBER THE
 ;REQUIRED ONE
DSP_RPT_TYP: MOVF RPT_TYP_NR,W ;
 ;ADD 11 TO THE TX OPTION NUMBER TO
 ;GIVE CORRECT LCD MESSAGE NUMBER
 ADDLW 11 ;
 MOVWF MSG_NR ;
 CALL SND_LCD_MSG_TX ;
 RETURN ;
 ;+END OF DISPLAY TX REPEAT TYPE S-R
 ;+GET TX REPEAT TYPE SUB-ROUTINE
 ;REPEAT MESSAGE OPTION NUMBERS 0 TO 2
 ;0 - REPEAT SAME
 ; - CHANGE TX TYPE NOT AVAILABLE
 ;1 - CHANGE MIDI MESSAGE TYPE
 ;DEFAULT VALUE = 0
RPT_TYP_OPT: INCF RPT_TYP_NR,F ;
 MOVF RPT_TYP_NR,W ;
 SUBLW 2 ;
 BTFSC STATUS,Z ;
 CLRF RPT_TYP_NR ;
 RETURN ;
 ;+END OF GET TX RPT TYPE S-R
 ;+TRANSMIT MODULE SUB-ROUTINE
 ;WAIT IF ACCEPT SWITCH IS STILL PRESSED
TX_MODULE: ;
BK1: BTFSS PORTA,RA1 ;
 GOTO BK1 ;
 ;MOVE LCD CURSOR START OF TO LINE 2
 ;AND DISPLAY 'TRANSMITTING'
 CALL CLR_HM_LN2 ;
 MOVLW 15 ;
 MOVWF MSG_NR ;
 CALL SND_LCD_MSG_TX ;
 ;SEND MIDI MESSAGE VIA USART
MIDI_OUT_LP: ;
RPT_MS_OUT: ;
 CALL MIDI_MS_OUT ;
 ;TEST IF CONTINUOUS MODE
 ;NB CONTINUOUS MODE NOT IMPLEMENTED
 MOVF TX_OPT_NR,W ;
 SUBLW 2 ;
 BTFSS STATUS,Z ;
 ;(OTHERWISE 1-SHOT SO RETURN)
 GOTO END_TX ;
 ;ARRIVE HERE IF CONTINUOUS MODE
 ;END TRANSMIT IF EDIT (RA0) PRESSED
 BTFSS PORTA,RA0 ;
 GOTO END_TX ;
 ;OTHERWISE REPEAT AFTER 1 SECOND
 ;CALL SEC_1_DLY;
 GOTO RPT_MS_OUT;
 ;WAIT UNTIL RA0 NOT PRESSED
END_TX: ;
BK2: BTFSS PORTA,RA1 ;
 GOTO BK2 ;
 ;CLEAR LCD DISPLAY LINE
 CALL CLR_HM_LN2 ;
 RETURN ;
 ;+END OF TRANSMIT MODULE S-R
 ;+MIDI MESSAGE OUT SUB-ROUTINE
 ;GET MIDI RETLW - 1, 2 OR 3 BYTES
MIDI_MS_OUT: MOVF MS_OPT_NR,W ;
 CALL TX_OPT_TBL ;
 ;RESET PCLATH
 BCF PCLATH,0 ;
 ;RETURN WITH THE RELEVANT MIDI
 ;MESSAGE CODES IN MS_BYTES _1 TO _3
 ;TEST FOR 1, 2 OR 3 BYTE MESSAGE
 ;ALL 3-BYTE MESSAGES EXCEPT -
 ;PROGRAM CHANGE 2-BYTE
 ;OVERALL PRESSURE 2-BYTE
 ;SYSTEM CLOCK 1-BYTE
 ;SYSTEM CLOCK?
 MOVF MS_OPT_NR,W ;
 SUBLW 7 ;
 BTFSS STATUS,Z ;
 GOTO NO_SYS_CLK ;
 ;IF YES
 ;TRANSMIT 1-BYTE MIDI MESSAGE
 CALL TX_1_BYTE ;
 GOTO END_SER_COM ;
 ;OTHERWISE
 ;PROGRAM CHANGE?
NO_SYS_CLK: MOVF MS_OPT_NR,W ;
 SUBLW 4 ;
 BTFSS STATUS,Z ;
 GOTO NO_PRG_CH ;
 ;IF YES
 ;TRANSMIT 2-BYTE MIDI MESSAGE
 CALL TX_2_BYTES ;
 GOTO END_SER_COM ;
 ;OTHERWISE
 ;OVERALL PRESSURE?
NO_PRG_CH: MOVF MS_OPT_NR,W ;
 SUBLW 5 ;
 BTFSS STATUS,Z ;
 GOTO NO_OV_PR ;
 ;IF YES
 ;TRANSMIT 2-BYTE MIDI MESSAGE
 CALL TX_2_BYTES ;
 GOTO END_SER_COM ;
 ;OTHERWISE
 ;TRANSMIT 3-BYTE MIDI MESSAGE
NO_OV_PR: CALL TX_3_BYTES ;
END_SER_COM: RETURN ;
 ;+END OF MIDI MESSAGE OUT SUB-ROUTINE
 ;+TRANSMIT 1-BYTE MIDI MESSAGE S-R
 ;DISABLE SERIAL PORT
TX_1_BYTE: BCF STATUS,RP0 ; BANK0
 BCF RCSTA,SPEN ;
 ;RESET TRANSMITTER
 BSF STATUS,RP0 ; BANK1
 BCF TXSTA,TXEN ;
 ;ENABLE TRANSMIT
 BSF STATUS,RP0 ; BANK1
 BSF TXSTA,TXEN ;
 ;ENABLE SERIAL PORT
 BCF STATUS,RP0 ; BANK0
 BSF RCSTA,SPEN ;
 ;MOVE RETLW INTO TXREG
 ;(INITIATES TRANSMISSION)
 BCF STATUS,RP0 ; BANK0
 MOVF MS_BYTE_1,W ;
 MOVWF TXREG ;
 BSF STATUS,RP0 ; BANK1; 
TRMT_LP: BTFSS TXSTA,TRMT;
 GOTO TRMT_LP ;
 ;DISABLE SERIAL PORT
 BCF STATUS,RP0 ; BANK0
 BCF RCSTA,SPEN ;
 BCF TXSTA,TXEN ;
 BCF STATUS,RP0 ; BANK0
 RETURN ;
 ;INITIATE TRANSMISSION
 BSF STATUS,RP0 ; BANK1
 BSF TXSTA,TXEN ;
 ;WAIT UNTIL TSR EMPTY IE TX FINISHED
TX_NT_FIN: BTFSS TXSTA,TRMT;
 GOTO TX_NT_FIN ;
 ;DISABLE TRANSMIT
 BCF TXSTA,TXEN ;
 BCF STATUS,RP0 ; BANK0
 ;+END OF TRANSMIT 1-BYTE MIDI MESSAGE SR
 ;+TRANSMIT 2-BYTE MIDI MESSAGE S-R
 ;
 ;DISABLE SERIAL PORT
TX_2_BYTES: BCF STATUS,RP0 ; BANK0
 BCF RCSTA,SPEN ;
 ;RESET TRANSMITTER
 BSF STATUS,RP0 ; BANK1
 BCF TXSTA,TXEN ;
 ;ENABLE TRANSMIT
 BSF STATUS,RP0 ; BANK1
 BSF TXSTA,TXEN ;
 ;ENABLE SERIAL PORT
 BCF STATUS,RP0 ; BANK0
 BSF RCSTA,SPEN ;
 ;MOVE DATA INTO TXREG
 ;(INITIATES TRANSMISSION)
 BCF STATUS,RP0 ; BANK0
 MOVF MS_BYTE_1,W ;
 MOVWF TXREG ;
 ;DELAY 160US
 CALL DLY_160US ;
 MOVF MS_BYTE_2,W ;
 MOVWF TXREG ;
 BSF STATUS,RP0 ; BANK1
TRMT_LP2: BTFSS TXSTA,TRMT;
 GOTO TRMT_LP2 ;
 ;DISABLE SERIAL PORT
 BCF STATUS,RP0 ; BANK0
 BCF RCSTA,SPEN ;
 BCF TXSTA,TXEN ;
 BCF STATUS,RP0 ; BANK0
 RETURN ;
 ;INITIATE TRANSMISSION
 BSF STATUS,RP0 ; BANK1
 BSF TXSTA,TXEN ;
 ;WAIT UNTIL TSR EMPTY IE TX FINISHED
TSR_NT_MT: BTFSS TXSTA,TRMT ;
 GOTO TSR_NT_MT ;
 ;DISABLE TRANSMIT
 BCF TXSTA,TXEN ;
 BCF STATUS,RP0 ; BANK0
 RETURN ;
 ;+END OF TRANSMIT 2-BYTE MIDI MESSAGE SR
 ;+TRANSMIT 3-BYTE MIDI MESSAGE S-R
 ;DISABLE SERIAL PORT
TX_3_BYTES: BCF STATUS,RP0 ; BANK0
 BCF RCSTA,SPEN ;
 ;RESET TRANSMITTER
 BSF STATUS,RP0 ; BANK1
 BCF TXSTA,TXEN ;
 ;ENABLE TRANSMIT
 BSF STATUS,RP0 ; BANK1
 BSF TXSTA,TXEN ;
 ;ENABLE SERIAL PORT
 BCF STATUS,RP0 ; BANK0
 BSF RCSTA,SPEN ;
 ;MOVE RETLW INTO TXREG
 ;(INITIATES TRANSMISSION)
 BCF STATUS,RP0 ; BANK0
 MOVF MS_BYTE_1,W ;
 MOVWF TXREG ;
 ;DELAY 160US
 CALL DLY_160US ;
 MOVF MS_BYTE_2,W ;
 MOVWF TXREG ;
 ;DELAY 160US
 CALL DLY_160US ;
 MOVF MS_BYTE_3,W ;
 MOVWF TXREG ;
 BSF STATUS,RP0 ; BANK1; 
TRMT_LP3: BTFSS TXSTA,TRMT ;
 GOTO TRMT_LP3 ;
 ;DISABLE SERIAL PORT
 BCF STATUS,RP0 ; BANK0
 BCF RCSTA,SPEN ;
 BCF TXSTA,TXEN ;
 BCF STATUS,RP0 ; BANK0
 RETURN ;
 ;INITIATE TRANSMISSION
 BSF STATUS,RP0 ; BANK1
 BSF TXSTA,TXEN ;
 ;WAIT UNTIL TSR EMPTY IE TX FINISHED
TSR_NO_MT: BTFSS TXSTA,TRMT;
 GOTO TSR_NO_MT ;
 ;DISABLE TRANSMIT
 BCF TXSTA,TXEN ;
 BCF STATUS,RP0 ; BANK0;
 RETURN ;
 ;+END OF TRANSMIT 3-BYTE MIDI MESSAGE SR
 ;+START OF MIDI MESSAGE ROUTINES
 ;SERIES OF INDIVIDUAL GOTO PROCEDURES
 ;WITH RETURN
 ;+NOTE OFF GOTO ROUTINE
NOTE_OFF: MOVLW %10000000;NOTE OFF CODE IN MESSAGE (BYTE 1 OF 3)
 MOVWF MS_BYTE_1 ;
 MOVLW 60 ;NOTE VALUE RETLW (BYTE 2 OF 3)
 MOVWF MS_BYTE_2 ;MIDDLE C = 60
 MOVLW 64 ;NOTE OFF VELOCITY RETLW (BYTE 3 OF 3)
 MOVWF MS_BYTE_3 ;
 ;RETURN WITH THESE VALUES
 RETURN ;
 ;+END OF NOTE ON GOTO ROUTINE
 ;+NOTE ON GOTO ROUTINE
NOTE_ON: MOVLW %10010000;NOTE ON CODE IN MESSAGE (BYTE 1 OF 3)
 MOVWF MS_BYTE_1 ;
 MOVLW 60 ;NOTE VALUE RETLW (BYTE 2 OF 3)
 MOVWF MS_BYTE_2 ;MIDDLE C = 60
 MOVLW 110 ;NOTE ON VELOCITY RETLW (BYTE 3 OF 3)
 MOVWF MS_BYTE_3 ;
 ;RETURN WITH THESE VALUES
 RETURN ;
 ;+END OF NOTE ON GOTO ROUTINE
 ;+POLY KEY PRESSURE GOTO ROUTINE
P_KY_PR: MOVLW %10100000 ;POLY KEY PRESSURE CODE IN MESSAGE
 MOVWF MS_BYTE_1 ;(BYTE 1 OF 3)
 MOVLW 60 ;NOTE VALUE RETLW (BYTE 2 OF 3)
 MOVWF MS_BYTE_2 ;MIDDLE C = 60
 MOVLW 64;PRESSURE VALUE DATA (BYTE 3 OF 3)
 MOVWF MS_BYTE_3 ;
 ;RETURN WITH THESE VALUES
 RETURN ;
 ;+END OF POLY KEY PRESSURE GOTO ROUTINE
 ;+CONTROL CHANGE GOTO ROUTINE
CON_CH: MOVLW %10110000 ;CONTROL CHANGE CODE IN MESSAGE
 MOVWF MS_BYTE_1 ;(BYTE 1 OF 3)
 MOVLW 7 ;CONTROL NUMBER DATA (BYTE 2 OF 3)
 MOVWF MS_BYTE_2 ;
 MOVLW 127 ;VALUE DATA (BYTE 3 OF 3)
 MOVWF MS_BYTE_3 ;
 ;RETURN WITH THESE VALUES
 RETURN ;
 ;+END OF CONTROL CHANGE GOTO ROUTINE
 ;+PROGRAM CHANGE GOTO ROUTINE
PROG_CH: MOVLW %11000000;PROGRAM CODE IN MESSAGE (BYTE 1 OF 2)
 MOVWF MS_BYTE_1 ;
 MOVLW 99;PROGRAM NUMBER DATA (BYTE 2 OF 2)
 MOVWF MS_BYTE_2 ;
 ;RETURN WITH THESE VALUES
 RETURN ;
 ;+END OF PROGRAM CHANGE GOTO ROUTINE
 ;+OVERALL PRESSURE GOTO ROUTINE
OVRL_PR: MOVLW %11010000 ;OVERALL PRESSURE CODE IN MESSAGE
 MOVWF MS_BYTE_1 ;(BYTE 1 OF 2)
 MOVLW 90 ;OVERALL PRESSURE VALUE DATA
 ;(BYTE 2 OF 2)
 MOVWF MS_BYTE_2 ;
 ;RETURN WITH THESE VALUES
 RETURN ;
 ;+END OF OVERALL PRESSURE GOTO ROUTINE
 ;+PITCH WHEEL GOTO ROUTINE
PTCH_WH: MOVLW %11100000 ;PITCH WHEEL CODE IN MESSAGE
 MOVWF MS_BYTE_1 ;(BYTE 1 OF 3)
 MOVLW 95 ;PITCH WHEEL LSB RETLW (BYTE 2 OF 3)
 MOVWF MS_BYTE_2 ;
 MOVLW 85 ;PITCH WHEEL MSB DATA(BYTE 3 OF 3)
 MOVWF MS_BYTE_3 ;
 ;RETURN WITH THESE VALUES
 RETURN ;
 ;+END OF PITCH WHEEL GOTO ROUTINE
 ;+SYSTEM MESSAGE GOTO ROUTINE
SYS_RST: MOVLW %11111111 ;SYSTEM RESET CODE
 MOVWF MS_BYTE_1 ;(BYTE 1 OF 1)
 ;RETURN WITH THESE VALUES
 RETURN ;
 ;+END OF SYSTEM MESSAGE GOTO ROUTINE
 ;+NEXT MIDI MESSAGE OPTION SUB-ROUTINE
 ;MIDI MESSAGE OPTION NUMBERS 0 TO 7
NXT_MS_OPT: INCF MS_OPT_NR,F ;
 MOVF MS_OPT_NR,W ;
 SUBLW 8 ;
 BTFSC STATUS,Z ;
 CLRF MS_OPT_NR ;
 RETURN ;
 ;+END OF NEXT MIDI MESSAGE OPTION S-R
 ;ASM DIRECTIVE
 ;==================
 ;END

