; MASTERMSG480M 26JUN06 - COPYRIGHT JOHN BECKER - EPE MOVING MESSAGE DISPLAY MASTER

; PIC16F628, INTERNAL OSC WDT OFF, POR ON, INTRC 100

; command codes:                              
; 1 Setup PIC ID numbers                      **
; 2 not used                                  ** 
; 3 get & send on character data block        **
; 4 receive normal data from PC for scrolling **
; 5 clear anim & static flags                 **
; 6 halt display                              **
; 7 receive animate display data from PC      **
; 8 Sync Off                                  **
; 9 Sync On                                   **
; 10 not used by master; only by slaves  ; send on received animate display data    **
; 11 send on anim rate value                  **
; 12 receive message scroll rate              **
; 13 code to select moving message mode       **
; 14 code to select animation mode            **
; 15 code to select static display mode       **
; 16 moving message stop - not used by slaves **
; 17 check PIC IDs			      **
; 18 Stop animate mode                        **
; 19 Stop static mode			      **
; 20 Run Mode
; 21 Program Mode
; 22 slaves only
; 23 show sync

#DEFINE BANK0 BCF $03,5
#DEFINE BANK1 BSF $03,5

        List P = PIC16F628, R=DEC; 
        __CONFIG   h'3F30'

        include P16F628.inc

        CBLOCK
STORE1
STORE2
STORE3
COLUMN0
COLUMN1
COLUMN2
COLUMN3
COLUMN4
COLUMN5
CHARACTER
COUNT1
LOOP
COLUMN0A
COLUMN1A
COLUMN2A
COLUMN3A
COLUMN4A
COLUMN5A
LENGTH
SCROLLRATE
SWITCH
PREVSWITCH
NEWSWITCH
SYNCFLAG
MOVINGFLAG
ANIMRATE
ANIMADDRESS
ANIMSTORE    ; extends to $6F
        ENDC
             ; do not add REGs after ANIMSTORE


PROMVAL .EQU $70    ; in both pages
SPBRG   .EQU $99    ; not in INC file for some odd reason.  Bank 1

; **************

        .ORG 0
        goto GIEOFF
        .ORG 4          ; Interrupt vector address
        goto GIEOFF
        .ORG 5          ; Start of program memory

GIEOFF: BCF INTCON,GIE  ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

ROUTEITRUNMODE: movf STORE1,W
        andlw 31
	addwf PCL,F
        goto RUNMODE2       ; 0 not used at all
        goto SETUP          ; 1 Setup
        goto RUNMODE2       ; 2 not used at all
        goto GETSTATIC      ; 3 receive & send on static characters to slaves
        goto RECEIVEPC      ; 4 receive normal data from PC for scrolling
        goto CLEARFLAGS     ; 5 clear anim & static flags
        goto RUNMODE2       ; 6 not used in this mode
        goto SENDANIMATION  ; 7 receive and send on Animation to slaves
        goto SENDONSYNC     ; 8 sync off
        goto SENDONSYNC     ; 9 sync on
        goto RUNMODE2       ; 10 not used to receive, slave command only
        goto SENDONANIMRATE ; 11 send on animate rate change to slaves
        goto GETSCROLLRATE  ; 12 moving message scroll rate
        goto MOVINGMODE     ; 13 start moving message
        goto ANIMATIONMODE  ; 14 start animation
        goto STATICMODE     ; 15 static static
	goto STOPMOVING     ; 16 stop moving message
        goto CHECKPICIDS    ; 17 Check PIC IDs
	goto STOPANIMATE    ; 18 Stop animate mode
	goto STOPSTATIC     ; 19 Stop static mode
        goto RUNMODE2       ; 20 Run Mode
        goto RUNMODE2       ; 21 Run Mode
        goto RUNMODE2       ; 22 Run Mode
        goto SHOWSYNC       ; 23 tell slaves to show sync
        goto RUNMODE2       ; 24 Run Mode
        goto RUNMODE2       ; 25 Run Mode
        goto RUNMODE2       ; 26 Run Mode
        goto RUNMODE2       ; 27 Run Mode
        goto RUNMODE2       ; 28 Run Mode
        goto RUNMODE2       ; 29 Run Mode
        goto RUNMODE2       ; 30 Run Mode
        goto RUNMODE2       ; 31 Run Mode

;*******************

TABLE:  movf CHARACTER,W
        andlw 127
	addwf PCL,F

        include lcdmtx2.inc"

;*******************

START:  clrf PORTA
        clrf PORTB
        movlw $07
        movwf CMCON

        BANK1
        movlw %11100110     ; RB1 & RB2 for serial, RB7-RB5 switches, RB4 as output test point
;        movlw %00000110     ; RB1 & RB2 for serial, RB7-RB4 leds
        movwf TRISB
        movlw %00010000     ; RA4 as input for PIC mode use
        movwf TRISA
        movlw %00000111     ; timer 1:128, pull-ups on (bit 7 = 0)
        movwf OPTION_REG
        BANK0

        call JOESETBAUD     ; initialise serial BAUD rate etc

;****************** START OF MAIN

MAIN:   clrf PORTB
        clrf STORE1
        clrf STORE2
        clrf STORE3
        
        clrf PORTA
        clrf COUNT1

        clrf COLUMN1A
        clrf COLUMN2A
        clrf COLUMN3A
        clrf COLUMN4A
        clrf COLUMN5A

        clrf SWITCH
        clrf PREVSWITCH
        clrf NEWSWITCH
        clrf MOVINGFLAG
        movlw 8
        movwf SYNCFLAG

CHECKSWITCHMAIN:
        comf PORTB,W     ; invert switch inputs to PORTB
        andlw %11100000                        
        movwf SWITCH     ; any switch press?
        swapf SWITCH,F   ; swap bits 8-4 with bits 3-0
        movf SWITCH,W    ; get switch
        movwf PREVSWITCH ; store as prev switch   

CHKS1:  btfss SWITCH,1   ; is S1 pressed (moving mode)?
        goto CHKS2
        bsf MOVINGFLAG,0 ; yes, set running mode in Master

CHKS2:  btfss SWITCH,2   ; is S2 pressed (animate mode)?
        goto CHKS3       ; no, not animation
        movlw 14
        call TXBYTE      ; yes, activate animate

CHKS3:  btfss SWITCH,3   ; is S3 pressed (static mode)?
        goto LOOP0       ; no, not static
        movlw 15         ; yes, activate static
        call TXBYTE

LOOP0:  movlw 2
        movwf LOOP
        movlw 0
        call PRMGET
        addlw 2
        andlw 127
        movwf LENGTH
        movlw 1
        call PRMGET
        movwf SCROLLRATE

LOOPIT: movf LOOP,W
        call PRMGET
        movwf CHARACTER

        andlw 128
        btfsc STATUS,Z
        goto LOOPIT2
        movf CHARACTER,W
        movwf COLUMN5A
        incf LOOP,F
        movf LOOP,W
        call PRMGET
        movwf COLUMN1
        incf LOOP,F
        movf LOOP,W
        call PRMGET
        movwf COLUMN2
        incf LOOP,F
        movf LOOP,W
        call PRMGET
        movwf COLUMN3
        incf LOOP,F
        movf LOOP,W
        call PRMGET
        movwf COLUMN4
        goto COL0

LOOPIT2: movf SCROLLRATE,W    ; sets scroll delay rate
        movwf COUNT1
        call TABLE

COL0:   btfss MOVINGFLAG,0 
        goto RUNMODE1

	call SHOWCHAR

        btfss PIR1,RCIF       ; Check for any RX'd data
        goto COL0B
        movf RCREG,W          ; zero ignored - PC turn off/on condition
        btfsc STATUS,Z
        goto COL0B
        movwf STORE1
        goto ROUTEITRUNMODE

COL0B:

; CHECKSWITCHMOVING:
        comf PORTB,W     ; invert switch inputs to PORTB
        andlw %11100000                        
        movwf SWITCH     ; any switch press?
        swapf SWITCH,F   ; swap bits 8-4 with bits 3-0
        movf PREVSWITCH,W  ; get prev switch
        xorwf SWITCH,W     ; is it the same as SWITCH?
        movwf NEWSWITCH    ; store XORed value
        btfsc STATUS,Z
        goto COL0C         ; yes, the same
        goto ROUTESWITCH   ; no, different, so route it

COL0C:  decfsz COUNT1,F
        goto COL0
        movf SCROLLRATE,W     ; sets scroll delay rate
        movwf COUNT1
        call ROTATE

;        btfss PIR1,RCIF       ; Check for any RX'd data
;        goto COL0A
;        movf RCREG,W          ; zero ignored - PC turn off/on condition if
;        btfsc STATUS,Z        ; serial connected to unit
;        goto COL0A

;        movwf STORE1
;        goto ROUTEIT

COL0A:  btfss MOVINGFLAG,0 
        goto RUNMODE1

        movf COLUMN0,W       ; are all bytes empty?
        iorwf COLUMN1,W
        iorwf COLUMN2,W
        iorwf COLUMN3,W
        iorwf COLUMN4,W
        iorwf COLUMN5,W

        btfss STATUS,Z
        goto COL0            ; no
        incf LOOP,F          ; yes, get another character
        movf LOOP,W
        subwf LENGTH,W
        btfsc STATUS,C       ; is there a borrow ?
        goto LOOPIT          ; no, Carry is still high

        movlw 2              ; yes, Carry is low
        movwf LOOP
        goto LOOPIT

;*****************




SHOWCHAR: ; not actually used for display, just timing
COL1:  call DELAY
COL2:  call DELAY
COL3:  call DELAY
COL4:  call DELAY
COL5:  call DELAY
        return

DELAY:  clrf STORE2
D2:     decfsz STORE2,F
        goto D2
D3:     decfsz STORE2,F
        goto D3
D4:     decfsz STORE2,F
        goto D4
D5:     decfsz STORE2,F
        goto D5
        return

ROTATE: movf COLUMN1,W
        movwf COLUMN0
        movf COLUMN2,W
        movwf COLUMN1
        movf COLUMN3,W
        movwf COLUMN2
        movf COLUMN4,W
        movwf COLUMN3
        movf COLUMN5,W
        movwf COLUMN4
        clrf COLUMN5

        movf COLUMN1A,W
        movwf COLUMN0A
        movf COLUMN2A,W
        movwf COLUMN1A
        movf COLUMN3A,W
        movwf COLUMN2A
        movf COLUMN4A,W
        movwf COLUMN3A
        movf COLUMN5A,W
        movwf COLUMN4A
        movf COLUMN0A,W
        iorlw 128             ; set bit 7 for sake of other PICs
        call TXBYTE

        movf COLUMN0,W
        movwf COLUMN5A
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********
          ;according to data sheet page 93 (is the same as for 16F87x devices
	  ; except that PIR2 of '87x has become PIR1 for '62x and page 2/3 not used)
	
                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL, which is located in both pages at or above $70
SETPRM: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        movf PROMVAL,W  ;get data value from PROMVAL and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        BANK0

CHKWRT: btfss PIR1,EEIF ;wait until bit 4 of PIR1 is set
        goto CHKWRT
        bcf PIR1,EEIF   ;clear bit 4 of PIR1
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x    retlwvices ****
;         the data sheet page 93 is wrong!  This routine here works!

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf EECON1,RD   ;enable read flag
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        BANK0
        return

; **************

        include lcdmtx1.inc

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03

JOESETBAUD: BANK1               ; Configure the baud rate generator
        movlw 25                ; BRG for 9600baud from 4MHz, brgh=1
                                ; Internal osc is 4MHz
        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 5)
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Send byte in W to the USART

TxByte: nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer:
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
        movf    RCREG,W
        return

RECEIVEPC:
        clrf LOOP
        clrf PORTA
        clrf COLUMN1A
        clrf COLUMN2A
        clrf COLUMN3A
        clrf COLUMN4A
        clrf COLUMN5A

        movlw %10000000
        call TXBYTE            ; ack back to PC



RT1:    btfss PIR1,RCIF        ; Check for any RX'd data
        goto RT1               ; Nothing RX'd
        movf RCREG,W           ; Store the RX'd data in 'W'

        movwf PROMVAL
        movwf LENGTH
        decf PROMVAL,F
        decf PROMVAL,F
        decf PROMVAL,F

        movlw %10000000
        call TXBYTE

        movf LOOP,W
        call SETPRM
        incf LOOP,F

RT2:    btfss PIR1,RCIF        ; Check for any RX'd data
        goto RT2               ; Nothing RX'd
        movf RCREG,W           ; Store the RX'd data in 'W'
        movwf PROMVAL

        movlw %10000000
        call TXBYTE

        movf LOOP,W
        call SETPRM
        incf LOOP,F
        movf LOOP,W
        xorwf LENGTH,W
        btfss STATUS,Z
        goto RT2
	return

SENDANIMATION:
        movlw %10000000
        call TXBYTE           ; ack back to PC
        movlw ANIMSTORE       ; get address of ANIMSTORE
        movwf FSR

SA0:    btfss PIR1,RCIF       ; Check for any RX'd data ; get PIC address
        goto SA0              ; Nothing RX'd
        movf RCREG,W          ; Store the RX'd data in 'W'
        movwf ANIMADDRESS

        movlw %10000000
        call TXBYTE           ; ack back to PC
        clrf LOOP

SA1:    btfss PIR1,RCIF       ; Check for any RX'd data
        goto SA1              ; Nothing RX'd
        movf RCREG,W          ; Store the RX'd data in 'W'
        movwf INDF            ; store it into ANIMSTORE via FSR
        incf FSR,F
        incf LOOP,F

        movlw %10000000
        call TXBYTE           ; ack back to PC
        movf LOOP,W
        xorlw 35
        btfss STATUS,Z
        goto SA1

SA1A:   btfss PIR1,RCIF       ; Check for any RX'd data ; get animrate
        goto SA1A             ; Nothing RX'd
        movf RCREG,W          ; Store the RX'd data in 'W'
        movwf ANIMRATE

SA1B:   btfss PIR1,RCIF       ; Check for any RX'd data ; get animrate
        goto SA1B             ; Nothing RX'd
        movf RCREG,W          ; Store the RX'd data in 'W'
        movwf SYNCFLAG

        movlw %10000000
        call TXBYTE           ; ack back to PC

;        movwf SYNCFLAG    ; value 8 or 9
;        call TXBYTE

; send animation to next PIC

        movlw ANIMSTORE       ; get address of ANIMSTORE
        movwf FSR
        clrf LOOP
        movlw 10
        call TXBYTE           ; send anim coming command to next PIC
SA2:    decfsz LOOP,F         ; wait a bit
        goto SA2


SA2A:   call DELAY
        movf ANIMADDRESS,W
        call TXBYTE           ; send anim address on to next PIC

      ; send anim data on to next PIC

SA3:    movf INDF,W
        call TXBYTE           ; send anim data on to next PIC
        nop
        nop
        nop
        nop
        nop

        incf FSR,F
        incf LOOP,F
        movf LOOP,W
        xorlw 35
        btfss STATUS,Z
        goto SA3

        movf ANIMRATE,W       ; send on ANIMRATE
        call TXBYTE

        movf SYNCFLAG,W  ; value 8 or 9
        call TXBYTE

        goto LOOP0
;        return

GETSTATIC:
        clrf PORTA
        clrf PORTB

        clrf LOOP
        clrf COLUMN1A
        clrf COLUMN2A
        clrf COLUMN3A
        clrf COLUMN4A
        clrf COLUMN5A

        movlw %10000000
        movlw 22               ; tell slaves to expect static data
        call TXBYTE            ; ack back to PC

GS1:    btfss PIR1,RCIF        ; Check for any RX'd data
        goto GS1               ; Nothing RX'd
        movf RCREG,W           ; Store the RX'd data in 'W'

        movwf PROMVAL
        movwf LENGTH
        decf PROMVAL,F
        decf PROMVAL,F
        decf PROMVAL,F

        movlw %10000000
        call TXBYTE

        movf LOOP,W
        call SETPRM
        incf LOOP,F

GS2:    btfss PIR1,RCIF        ; Check for any RX'd data
        goto GS2               ; Nothing RX'd
        movf RCREG,W           ; Store the RX'd data in 'W'
        movwf PROMVAL

        movlw %10000000
        call TXBYTE

        movf LOOP,W
        call SETPRM
        incf LOOP,F
        movf LOOP,W
        xorwf LENGTH,W
        btfss STATUS,Z
        goto GS2

LOOPST0: movlw 2
        movwf LOOP
        movlw 0
        call PRMGET
        addlw 2
        andlw 127
        movwf LENGTH

        movlw 4
        movwf SCROLLRATE

LOOPITST: movf LOOP,W
        call PRMGET
        movwf CHARACTER

LOOPITST2: movf SCROLLRATE,W    ; sets scroll delay rate
        movwf COUNT1
        call TABLE

COLST0: call STATICCHARDELAY
        decfsz COUNT1,F       ; is delay count = 0 ?
        goto COLST0           ; no, so continue with these columns
        movf SCROLLRATE,W     ; yes, sets scroll delay rate
        movwf COUNT1
        movf COLUMN1,W
        iorlw 128
        call TXBYTE

COLST1: call STATICCHARDELAY
        decfsz COUNT1,F       ; is delay count = 0 ?
        goto COLST1           ; no, so continue with these columns
        movf SCROLLRATE,W     ; yes, sets scroll delay rate
        movwf COUNT1
        movf COLUMN2,W
        iorlw 128
        call TXBYTE

COLST2: call STATICCHARDELAY
        decfsz COUNT1,F       ; is delay count = 0 ?
        goto COLST2           ; no, so continue with these columns
        movf SCROLLRATE,W     ; yes, sets scroll delay rate
        movwf COUNT1
        movf COLUMN3,W
        iorlw 128
        call TXBYTE

COLST3: call STATICCHARDELAY
        decfsz COUNT1,F       ; is delay count = 0 ?
        goto COLST3           ; no, so continue with these columns
        movf SCROLLRATE,W     ; yes, sets scroll delay rate
        movwf COUNT1
        movf COLUMN4,W
        iorlw 128
        call TXBYTE

COLST4: call STATICCHARDELAY
        decfsz COUNT1,F       ; is delay count = 0 ?
        goto COLST4           ; no, so continue with these columns
        movf SCROLLRATE,W     ; yes, sets scroll delay rate
        movwf COUNT1
        movf COLUMN5,W
        iorlw 128
        call TXBYTE

        incf LOOP,F          ; yes, get another character
        movf LOOP,W
        subwf LENGTH,W
        btfsc STATUS,C       ; is there a borrow ?
        goto LOOPITST        ; no, Carry is still high, so get next character

        call STATICCHARDELAY
        call STATICCHARDELAY
        call STATICCHARDELAY
        call STATICCHARDELAY

        call STATICCHARDELAY
        call STATICCHARDELAY

        movlw 3
        call TXBYTE          ; send STATIC store command to slaves
	return

STATICCHARDELAY:
        call DELAY
        call DELAY
        call DELAY
        call DELAY
        call DELAY
        return

ANIMATIONMODE: movlw 14
        call TXBYTE
        goto LOOP0

STATICMODE: movlw 15
        call TXBYTE
        goto LOOP0

;CHECKSWITCH:
;        comf PORTB,W     ; invert switch inputs to PORTB
;        andlw %11110000                        
;        movwf STORE1     ; any switch press?
;        swapf STORE1,W   ; swap bits 8-4 with bits 3-0
;        movwf SWITCH
;        xorlw PREVSWITCH
;;        btfss STATUS,Z
;        return

; ******* here

        btfss STATUS,Z   ; is SWITCH = 0 (none pressed)?
        goto CSA         ; no, a switch is pressed
        clrf PREVSWITCH  ; clear PREVSWITCH & return
        return

CSA:    movf PREVSWITCH,W ; is PREVSWITCH = 0 ?
        btfsc STATUS,Z
        goto CSB         ; yes
        clrf SWITCH      ; no, still set
        return           

CSB:    btfsc SWITCH,0   ; yes, PREVSWITCH = 0, so is it switch 1?
        goto SWITCH1     ; yes S1
        btfsc SWITCH,1   ; no, switch 2?
        goto SWITCH2     ; yes, S2
        btfsc SWITCH,2   ; no, switch 3?
        goto SWITCH3     ; yes, S3
        btfsc SWITCH,3   ; no, switch 4?
        goto SWITCH4     ; yes, S4
        return

SWITCH1: movlw 13        ; moving message mode
         movwf SWITCH
         return
SWITCH2: movlw 14        ; animation mode
         movwf SWITCH
         return
SWITCH3: movlw 15        ; static mode
         movwf SWITCH
         return
SWITCH4: incf SYNCFLAG,F ; toggle SYNCFLAG
         bcf SYNCFLAG,1
         movf SYNCFLAG,W
         movwf SWITCH
         return

STOPANIMATE:
	movlw 18	      ; 18 Stop animate mode
	call TXBYTE
        clrf COLUMN1A
        clrf COLUMN2A
        clrf COLUMN3A
        clrf COLUMN4A
        clrf COLUMN5A
        goto LOOP0

STOPSTATIC:
	movlw 19          ; 19 Stop static mode
	call TXBYTE
        clrf COLUMN1A
        clrf COLUMN2A
        clrf COLUMN3A
        clrf COLUMN4A
        clrf COLUMN5A
        goto LOOP0

RUNMODE2:
        movlw 20
        call TXBYTE
        bcf MOVINGFLAG,0  ; clear moving flag

RUNMODE1:

RM1:
        comf PORTB,W     ; invert switch inputs to PORTB
        andlw %11100000                        
        movwf SWITCH     ; any switch press?
        swapf SWITCH,F   ; swap bits 8-4 with bits 3-0
        movf PREVSWITCH,W  ; get prev switch
        xorwf SWITCH,W     ; is it the same as SWITCH?
        movwf NEWSWITCH    ; store XORed value
        btfsc STATUS,Z
        goto RM2           ; yes
        goto ROUTESWITCH

RM2:    btfss PIR1,RCIF       ; Check for any RX'd data
        goto RM1              ; Nothing RX'd

        movf RCREG,W
        movwf STORE1
        goto ROUTEITRUNMODE

; *******************

SETUP:  movlw 1               ; tell next PIC to expect address as next byte
        call TXBYTE
        clrf STORE1
ST2:    decfsz STORE1,F       ; short delay to allow next PIC to react
        goto ST2
        movlw 1
        call TXBYTE           ; send address byte to next PIC
        goto RUNMODE1

CLEARFLAGS: movlw 5
        call TXBYTE
        goto LOOP0

SENDONSYNC: movf STORE1,W
        movwf SYNCFLAG    ; value 8 or 9
        call TXBYTE
        goto LOOP0

SENDONANIMRATE: movlw 11         
        call TXBYTE           ; 11 alert next PIC to rate change coming
CHK11A: btfss PIR1,RCIF       ; Check for any RX'd data
        goto CHK11A
        movf RCREG,W          ; zero ignored
        btfsc STATUS,Z        ; serial connected to unit
        goto CHK11A           ; get anim rate
        movf RCREG,W
        call TXBYTE           ; send on to next PIC
        goto LOOP0

GETSCROLLRATE:                ; 12 moving message scroll rate
        movlw %1000000        ; ack back to PC
        call TXBYTE
CHK12A: btfss PIR1,RCIF       ; Check for any RX'd data
        goto CHK12A
        movf RCREG,W          ; zero ignored
        btfsc STATUS,Z        ; serial connected to unit
        goto CHK12A           ; get anim rate
        movf RCREG,W
        movwf SCROLLRATE
        movwf PROMVAL
        movlw %10000000
        call TXBYTE           ; ack back to PC
        movlw 1
        call SETPRM
        clrf COLUMN1
        clrf COLUMN2
        clrf COLUMN3
        clrf COLUMN4
        clrf COLUMN5
        clrf COLUMN1A
        clrf COLUMN2A
        clrf COLUMN3A
        clrf COLUMN4A
        clrf COLUMN5A
        goto MOVINGMODE2

CHECKPICIDS: movlw 17
	call TXBYTE           ; tell PICs to show IDs
        goto RUNMODE1

MOVINGMODE:  movlw 13    ; send on to slaves
        ;  movlw %10000000   ; just ack to PC
        call TXBYTE
MOVINGMODE2:
        bsf MOVINGFLAG,0  ; set moving flag
        goto LOOP0

STOPMOVING:  clrf STORE1
	call CLEARSCREEN
        bcf MOVINGFLAG,0  ; clear moving flag
        movlw 16  ; ack back to PC
        call TXBYTE   ; ACK to PC and clear moving message displays in slaves
        goto LOOP0

CLEARSCREEN:
;        return
        clrf COLUMN0A
        clrf COLUMN1A
        clrf COLUMN2A
        clrf COLUMN3A
        clrf COLUMN4A
        clrf COLUMN5A
        clrf COLUMN0
        clrf COLUMN1
        clrf COLUMN2
        clrf COLUMN3
        clrf COLUMN4
        clrf COLUMN5

;        movlw %10000000  ; set display cathode 4 high (RA7)
;        movwf PORTA      ; and all transistors off (low)
;        movlw 255
;        movwf PORTB      ; set all display cathodes high

;        clrf STORECOL1
;        clrf STORECOL2
;        clrf STORECOL3
;        clrf STORECOL4
;        clrf STORECOL5

        return


;HALT3:  btfss PIR1,RCIF       ; Check for any RX'd data
;        goto HALT3            ; Nothing RX'd
;        btfsc RCREG,7
;        goto HALT3

;        movf RCREG,W
;        movwf STORE1
;        goto ROUTEITRUNMODE

SHOWSYNC: movlw 23    ; send on to slaves & ack to PC
        call TXBYTE
        goto LOOP0

ROUTESWITCH:
        movf SWITCH,W
        movwf PREVSWITCH  ; store into prev switch
CHKS1M: btfss NEWSWITCH,1   ; is S1 different (moving mode)?
        goto CHKS2M

        movlw 13          ; prepare for moving mode
        btfss SWITCH,1    ; is switch bit 1 high?
        movlw 16          ; prepare for stop moving
        movwf STORE1
        goto ROUTEITRUNMODE

CHKS2M: btfss NEWSWITCH,2 ; is S2 different (animate mode)?
        goto CHKS3M       ; no, not animation
;        bsf PORTB,4       ; yes, it's different
        movlw 14          ; prepare to activate animate
        btfss SWITCH,2    ; is switch bit 2 high?
        movlw 18          ; no, so stop animate
        movwf STORE1
        goto ROUTEITRUNMODE

CHKS3M: btfss NEWSWITCH,3 ; is S3 different (static mode)?
        goto COL0C        ; no, not static
        movlw 15          ; yes, prepare to activate static
        btfss SWITCH,3    ; is switch bit 3 high?
        movlw 19          ; no, so stop static
        movwf STORE1
        goto ROUTEITRUNMODE

        .org $2100             ; data eeprom values

        DE 35, 20    ; (qty/scroll rate)

        DE 'M','I','N','D',' ','T','H','E',' ','C','A','R',' '

        DE %10000000 ; 19
	DE %10001100 ; 0
	DE %10011100 ; 1
	DE %10011010 ; 2
        DE %10011101 ; 3

        DE %10011010 ; 4
        DE %10101100 ; 5
        DE %11001100 ; 6
        DE %11001100 ; 7
        DE %11111100 ; 8

        DE %11001100 ; 9
        DE %11001100 ; 10
        DE %11001010 ; 11
        DE %11111101 ; 12
        DE %10111010 ; 13

        DE %10011100 ; 14
        DE %10011100 ; 15
        DE %10000000 ; 16
        DE %10000000 ; 17
        DE %10000000 ; 18

        DE ' ',' ',' '
        DE 'X'

        END
