VERSION 5.00
Object = "{86CF1D34-0C5F-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCT2.OCX"
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Begin VB.Form frmModelCreate 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Create IC Profile"
   ClientHeight    =   4620
   ClientLeft      =   3450
   ClientTop       =   3375
   ClientWidth     =   5145
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   HelpContextID   =   400
   Icon            =   "frmModelCreate.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4620
   ScaleWidth      =   5145
   Begin VB.TextBox txtInput 
      Height          =   285
      Left            =   1380
      MaxLength       =   8
      TabIndex        =   12
      Tag             =   "0"
      Top             =   3450
      Visible         =   0   'False
      Width           =   690
   End
   Begin MSFlexGridLib.MSFlexGrid grdPins 
      Height          =   3300
      HelpContextID   =   400
      Index           =   0
      Left            =   45
      TabIndex        =   3
      Top             =   855
      Width           =   2190
      _ExtentX        =   3863
      _ExtentY        =   5821
      _Version        =   393216
      Cols            =   3
   End
   Begin MSComCtl2.UpDown UpDown1 
      Height          =   330
      HelpContextID   =   400
      Left            =   3675
      TabIndex        =   1
      ToolTipText     =   "Specifiy the total number of pins on the IC package"
      Top             =   45
      Width           =   240
      _ExtentX        =   423
      _ExtentY        =   582
      _Version        =   393216
      Value           =   14
      BuddyControl    =   "lblPins"
      BuddyDispid     =   196617
      OrigLeft        =   1575
      OrigTop         =   1425
      OrigRight       =   1815
      OrigBottom      =   1965
      Max             =   24
      Min             =   10
      SyncBuddy       =   -1  'True
      BuddyProperty   =   65537
      Enabled         =   -1  'True
   End
   Begin VB.TextBox txtDescription 
      Height          =   330
      HelpContextID   =   400
      Left            =   1140
      MaxLength       =   80
      TabIndex        =   2
      ToolTipText     =   "Enter a description of the IC here (ie Quad 2-input nand)"
      Top             =   420
      Width           =   3930
   End
   Begin VB.TextBox txtModel 
      Height          =   330
      HelpContextID   =   400
      Left            =   1140
      MaxLength       =   8
      TabIndex        =   0
      ToolTipText     =   "Enter the model number of the IC here (ie 7400)"
      Top             =   15
      Width           =   1080
   End
   Begin VB.CommandButton cmdNext 
      Caption         =   "Next ->"
      Height          =   330
      HelpContextID   =   400
      Left            =   3900
      TabIndex        =   6
      Top             =   4245
      Width           =   1155
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   330
      Left            =   2610
      TabIndex        =   5
      Top             =   4245
      Width           =   1155
   End
   Begin MSFlexGridLib.MSFlexGrid grdPins 
      Height          =   3300
      HelpContextID   =   400
      Index           =   1
      Left            =   2895
      TabIndex        =   4
      Top             =   855
      Width           =   2190
      _ExtentX        =   3863
      _ExtentY        =   5821
      _Version        =   393216
      Cols            =   3
   End
   Begin VB.Shape Shape2 
      FillStyle       =   0  'Solid
      Height          =   180
      Left            =   2400
      Top             =   855
      Width           =   300
   End
   Begin VB.Shape shpIC 
      BorderWidth     =   3
      Height          =   3330
      Left            =   2250
      Top             =   840
      Width           =   615
   End
   Begin VB.Label Label5 
      BackStyle       =   0  'Transparent
      Caption         =   "Step 1 of 2"
      Height          =   240
      Left            =   90
      TabIndex        =   11
      Top             =   4290
      Width           =   825
   End
   Begin VB.Label lblPins 
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Caption         =   "14"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Left            =   3360
      TabIndex        =   10
      Top             =   60
      Width           =   300
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Number Pins:"
      Height          =   195
      Left            =   2370
      TabIndex        =   9
      Top             =   75
      Width           =   945
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Description:"
      Height          =   195
      Left            =   240
      TabIndex        =   8
      Top             =   450
      Width           =   855
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Model Number:"
      Height          =   195
      Left            =   15
      TabIndex        =   7
      Top             =   75
      Width           =   1080
   End
End
Attribute VB_Name = "frmModelCreate"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private mbAmend                                 As Boolean

Private Const Module_Name                       As String = "frmModelCreate"
Public Property Get Amend() As Boolean

    Amend = mbAmend
    
End Property

Public Property Let Amend(bAmend As Boolean)
    
    Const PROC_NAME                     As String = "Property LET Amend"
    
    On Error GoTo ErrorHandler
    
    mbAmend = bAmend
    
    If bAmend = False Then
        ' Erase the current model details
        With gtypNewModel
            .Description = ""
            .Model = ""
            .NumPins = 14
            Erase .Pin
            .PinVDD = -1 'No power pins specifed as yet
            .PinVSS = -1
            Set .TestScript = Nothing
            Erase .UsageCount
            txtModel.Text = ""
            txtDescription = ""
            UpDown1.Value = .NumPins
        End With
    Else
        ' Transfer details of the current model over
        gtypNewModel = gtypModel
        
        With gtypNewModel
            txtModel.Text = .Model
            txtDescription.Text = .Description
            UpDown1.Value = .NumPins
        End With
    
    End If
    
    Call RefreshGrid
    
    Exit Property
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Property

Private Sub RefreshGrid()

    Dim F                               As Integer
    Dim G                               As Integer
    Dim H                               As Integer
    Dim nPinsPerSide                    As Integer
    Dim nPin                            As Integer

    Const PINUSAGE As String = "INPUT OUTPUTIN/OUTGND   +V    N/C   "
    
    Const PROC_NAME                     As String = "RefreshGrid"
    
    On Error GoTo ErrorHandler
    
    
    nPinsPerSide = gtypNewModel.NumPins / 2
    
    For G = 0 To 1
        With grdPins(G)
            .Visible = False
            .Rows = nPinsPerSide + 1
        
            For F = 1 To .Rows - 1
                'nPin = f + ((g * nPinsPerSide))
                .Row = F
                .Col = 0
                Select Case G
                Case 0 ' Left
                    .Text = Format$(F)
                Case 1 ' Right
                    .Text = Format$((gtypNewModel.NumPins - F) + 1)
                End Select
                nPin = .Text
                
                
                .Col = 1
                .Text = Trim$(Mid$(PINUSAGE, (gtypNewModel.Pin(nPin).Usage * 6) + 1, 6))
                
                .Col = 2
                .Text = gtypNewModel.Pin(nPin).Tag
            
                ' Now update the row back colour
                For H = 0 To .Cols - 1
                    .Col = H
                    .CellBackColor = glColors(gtypNewModel.Pin(nPin).Usage)
                Next H
        
            Next F
            .Visible = True
        End With
    Next G
    
    shpIC.Height = 120 + ((nPinsPerSide + 1) * grdPins(0).RowHeight(0))
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub

Private Sub cmdCancel_Click()

    If MsgBox("Are you sure you wish to cancel ?", vbYesNo + vbQuestion, "Cancel Operation") = vbYes Then
        Unload Me
    End If
    
End Sub

Private Sub cmdHelp_Click()

    txtInput.Visible = False
    
End Sub

Private Sub cmdNext_Click()
    
    Dim bWarning                        As Boolean
    Dim F                               As Integer
    Dim sMessage                        As String
    
    
    Const PROC_NAME                     As String = "cmdNext_Click"
    
    On Error GoTo ErrorHandler
    
    
    txtInput.Visible = False
    
    '
    ' Validation rules
    
    If Len(Trim$(txtModel.Text)) = 0 Then
        MsgBox "You must specify a model number for the IC. This will be used to generate the filename where the parameters and settings for this IC are stored", vbOKOnly + vbExclamation, "No Model Number Specified"
        Exit Sub
    Else
        gtypNewModel.Model = Trim$(txtModel.Text)
    End If
    
    If Len(Trim$(txtDescription.Text)) = 0 Then
        MsgBox "You must enter a description for this IC", vbOKOnly + vbExclamation, "No Description Entered"
        Exit Sub
    Else
        gtypNewModel.Description = Trim$(txtDescription.Text)
    End If
    
    '
    ' Generate warnings for the following situations
    With gtypNewModel
        Erase .UsageCount
        For F = 1 To .NumPins
            .UsageCount(.Pin(F).Usage) = .UsageCount(.Pin(F).Usage) + 1    ' At least one input
            Select Case .Pin(F).Usage
            Case 3 ' GND
                .PinVSS = F
            Case 4
                .PinVDD = F
            End Select
        Next F
    
        If .UsageCount(0) = 0 Then
            sMessage = sMessage & "Has no pins specified as input" & vbCrLf
        End If
        If .UsageCount(2) = 0 Then
            If .UsageCount(1) = 0 Then
                sMessage = sMessage & "Has no pins specified as output" & vbCrLf
            End If
        End If
        '
        ' Now check the power pins
        bWarning = False
        If .UsageCount(3) = 0 Then
            sMessage = sMessage & "Has no pin specified as GND" & vbCrLf
            bWarning = True
        End If
        If .UsageCount(3) > 1 Then
            sMessage = sMessage & "Has more than one GND pin" & vbCrLf
            bWarning = True
        End If
        If .UsageCount(4) = 0 Then
            sMessage = sMessage & "Has no pin specified as +V" & vbCrLf
            bWarning = True
        End If
        If .UsageCount(4) > 1 Then
            sMessage = sMessage & "Has more than one +V pin" & vbCrLf
            bWarning = True
        End If
                
        ' Reset power pins
        
        If bWarning = True Then
            .PinVDD = -1 ' IC will require manual configuration of it's power requirements
            .PinVSS = -1
            If MsgBox("Warning" & vbCrLf & vbCrLf & "The model specification:" & vbCrLf & sMessage & vbCrLf & "Do you wish to continue ?", vbOKCancel + vbDefaultButton2 + vbExclamation, "Model Definition Warning") = vbCancel Then
                Exit Sub
            End If
        End If
            
    End With
    
    UpDown1.Enabled = False ' Can't change the number of pins any more
        
    frmTestScript.Show
    frmModelCreate.Hide
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub


Private Sub Form_Load()

    Dim F                       As Integer
    
    Const PROC_NAME                     As String = "Form_Load"
    
    On Error GoTo ErrorHandler
    
    For F = 0 To 1
        With grdPins(F)
            .Rows = 1
            .Row = 0
            
            .Cols = 3
            
            .Col = 0
            .Text = "Pin"
            .ColWidth(.Col) = 300
            
            .Col = 1
            .Text = "Usage"
            .ColWidth(.Col) = 700
            .ColAlignment(.Col) = flexAlignLeftCenter
            
            .Col = 2
            .Text = "Tag"
            .ColWidth(.Col) = 1050
            If F = 0 Then
                .ColAlignment(.Col) = flexAlignRightCenter
            Else
                .ColAlignment(.Col) = flexAlignLeftCenter
            End If
            
        End With
    Next F
    
    If gtypNewModel.NumPins Then
        ' Wizard has previous settings in
        UpDown1.Value = gtypNewModel.NumPins
        txtModel.Text = gtypNewModel.Model
        txtDescription.Text = gtypNewModel.Description
    End If
    
    Call RefreshGrid
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub


Private Sub grdPins_Click(Index As Integer)
' We've clicked on the grid
' Check what col/row has ben clicked


    Dim nPin                            As Integer
    Dim X                               As Integer
    Dim r                               As Integer
    
    Const PROC_NAME                     As String = "grdPins_Click"
    
    On Error GoTo ErrorHandler
    
    With grdPins(Index)
        X = .Col ' Remember the col that was selected
        r = .Row
        .Col = 0
        nPin = Val(.Text) ' Extract the pin number
    
        Select Case X
        Case 0 ' Pin number - Ignore
            txtInput.Left = .ColPos(2)
            
        Case 1 ' Pin usage
            X = gtypNewModel.Pin(nPin).Usage
            X = X + 1
            If X = 2 Then X = X + 1 ' We don't use the I/O mode anymore
            
            If X > 5 Then
                X = 0
            End If
            gtypNewModel.Pin(nPin).Usage = X
            
            Call RefreshGrid ' Refresh the grids on the display
            
        Case 2 ' Pin Tag
            If Val(txtInput.Tag) > 0 Then
                gtypNewModel.Pin(txtInput.Tag).Tag = txtInput.Text
                Call RefreshGrid
            End If
            
            .Col = X
            .Row = r
            txtInput.Text = .Text
            txtInput.Left = (.ColPos(X) + .Left) + 50
            txtInput.Top = .RowPos(.Row) + .Top + 50
            txtInput.Height = .RowHeight(.Row) - 75
            txtInput.Width = .ColWidth(X) - 25
            txtInput.Visible = True
            txtInput.Tag = nPin
            txtInput.SetFocus
            
        End Select
    End With

    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub

Private Sub txtDescription_GotFocus()
    
    txtInput.Visible = False

End Sub

Private Sub txtDescription_KeyPress(KeyAscii As Integer)
    
    KeyAscii = ValidateKeyPress(KeyAscii, VALIDATE_ALPHA)

End Sub




Private Sub txtInput_KeyPress(KeyAscii As Integer)

    Dim nPin                        As Integer
    Dim nIndex                      As Integer
    Dim nOffset                     As Integer
    Dim nPinsPerSide                As Integer
        
    
    If KeyAscii = 13 Then
        ' CR pressed
        ' Move to next row
        KeyAscii = 0 ' Supress the 'BELL'
        
        nPinsPerSide = gtypNewModel.NumPins / 2
        
        nPin = txtInput.Tag
        
        If nPin = gtypNewModel.NumPins Then
            nPin = 0
        End If
        
        nIndex = 0
        If nPin >= nPinsPerSide Then
            nIndex = 1
        End If
        
        With grdPins(nIndex)
            Select Case nIndex
            Case 0 ' Left
                .Row = nPin + 1
                
            Case 1 ' Right
                .Row = (nPinsPerSide - (nPin - nPinsPerSide))
                
            End Select
            .Col = 2
        End With
        
        Call grdPins_Click(nIndex)
        
    End If
    
End Sub


Private Sub txtModel_GotFocus()

    txtInput.Visible = False
    
End Sub

Private Sub txtModel_KeyPress(KeyAscii As Integer)

    KeyAscii = ValidateKeyPress(KeyAscii, VALIDATE_FILENAME)
    
End Sub


Private Sub UpDown1_DownClick()

    On Error Resume Next
    
    DoEvents
    
    If UpDown1.Value / 2 <> Int(UpDown1.Value) Then
        UpDown1.Value = UpDown1.Value - 1
    End If

    With gtypNewModel
        .NumPins = UpDown1.Value
    End With
    
    Call RefreshGrid

End Sub


Private Sub UpDown1_GotFocus()
    
    txtInput.Visible = False

End Sub


Private Sub UpDown1_UpClick()

    On Error Resume Next
    
    If UpDown1.Value / 2 <> Int(UpDown1.Value) Then
        UpDown1.Value = UpDown1.Value + 1
    End If
    
    gtypNewModel.NumPins = UpDown1.Value
    Call RefreshGrid

End Sub


