;*****************************************************************************        
;
;   Module:     scan.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.1 20/3/04                                                  
;
;               location scanner code.
;               This is a loop that searches the list of stored positions
;               looking for the closest one.
;               At the end, we have the following information
;               1) CurrentPos - gives eeprom index of closest camera. zero if none
;               2) ScanDist - the distance-squared to the camera. 
;                  distance is in 1/100 of a minute of arc
;
;*****************************************************************************        
loop
    ; Calculate the address for this entry:
    ; ( numEntries * 6 ) + 2
    ; numEntriesH * 6 * 256 + ( numEntriesL * 6 )
    movlw   0x06
    mulwf   scanNumH
    movf    PRODL, W    
    movwf   eepAddH 
    movlw   0x02
    movwf   eepAddL
    movlw   0x06
    mulwf   scanNumL
    movf    PRODL, W
    addwf   eepAddL, F
    movf    PRODH, W
    addwfc  eepAddH, F
 
    ; Get data, store in scanLat/scanLong   
    call    EEPReadPositionFast
    
    ; subtract Latmmhh from scanLat, make positive if needed
    movf    Latmmhh+2, W
    subwf   scanLat+2, F
    movf    Latmmhh+1, W
    btfss   STATUS, C
    incfsz  Latmmhh+1,W
    subwf   scanLat+1, F
    movf    Latmmhh, W
    btfss   STATUS, C
    incfsz  Latmmhh,W
    subwf   scanLat, F
    
    btfss   scanLat, 7       ; Was the result negative? Make postive if so
    goto    subLong
    
    comf    scanLat, F    
    comf    scanLat+1, F    
    comf    scanLat+2, F    
    
    movlw   0x01
    addwf   scanLat+2, F
    btfss   STATUS, C
    goto    subLong
    movlw   0x01
    addwf   scanLat+1, F
    btfsc   STATUS, C
    incf    scanLat, F
     
    
    ; subtract Longmmhh from scanLong, make positive if needed
subLong
    movf    Longmmhh+2, W
    subwf   scanLong+2, F
    movf    Longmmhh+1, W
    btfss   STATUS, C
    incfsz  Longmmhh+1,W
    subwf   scanLong+1, F
    movf    Longmmhh, W
    btfss   STATUS, C
    incfsz  Longmmhh,W
    subwf   scanLong, F
    
    btfss   scanLong, 7      ; Was the result negative? Make postive if so
    goto    calcAdjust
    
    comf    scanLong, F    
    comf    scanLong+1, F    
    comf    scanLong+2, F    
    
    movlw   0x01
    addwf   scanLong+2, F
    btfss   STATUS, C
    goto    calcAdjust
    movlw   0x01
    addwf   scanLong+1, F
    btfsc   STATUS, C
    incf    scanLong, F


    ; multiply scanLong by cosineValue, 24U * 16U, result in scanLong
calcAdjust
    movf    scanLong,W
    movwf   AARGB0
    movf    scanLong+1, W
    movwf   AARGB1
    movf    scanLong+2, W
    movwf   AARGB2
    movf    cosineValueH, W
    movwf   BARGB0
    movf    cosineValueL, W
    movwf   BARGB1

    call    FXM2416U     ; Interesting result in AARG ( AARGB3:5, B3 MSB )

    movf    AARGB0, W
    movwf   scanLong
    movf    AARGB1, W
    movwf   scanLong+1
    movf    AARGB2, W
    movwf   scanLong+2
    
    ; add scanLat to scanLong, result in dist
    movf    scanLong, W
    movwf   dist
    movf    scanLong+1, W
    movwf   dist+1
    movf    scanLong+2, W
    movwf   dist+2
    
    movf    scanLat+2, W
    addwf   dist+2, F
    movf    scanLat+1, W
    btfsc   STATUS, C
    incfsz  scanLat+1,W
    addwf   dist+1,F
    movf    scanLat, W
    btfsc   STATUS, C
    incfsz  scanLat,W
    addwf   dist,F
    
    ; If the camera point is *very* roughly more than 10 minutes of arc
    ; away, then it is too far away to bother with    
    ; subtract 10 minutes ( 1000,  0x03e8 ) from dist.
    movlw   0xe8
    subwf   dist+2, F
    movlw   0x03
    btfss   STATUS, C   
    movlw   0x04
    subwf   dist+1, F
    movlw   0x00
    btfss   STATUS, C
    movlw   0x01
    subwf   dist, F

    ; if result is postive, goto NEXTLOOP
    btfss   dist, 7
    goto    nextLoop
    
    ; OK, we have a valid camera position to evalaute.
    ; Calculate it's real distance from us
    ; the equaltion is distance = squareroot( x**2 time y**2 ),
    ; but we do not need to bother with the square root since 
    ; we are looking for the closet camera, not it's real distance
    
    ; calc dist = scanLat * scanLat + scanLong * scanLog

    movf    scanLat, W
    movwf   AARGB0
    movwf   BARGB0
    movf    scanLat+1, W
    movwf   AARGB1
    movwf   BARGB1
    movf    scanLat+2, W
    movwf   AARGB2
    movwf   BARGB2
    
    call    FXM2424U     ; Interesting result in AARG ( AARGB3:5, B3 MSB )
    
    movf    AARGB3, W
    movwf   dist
    movf    AARGB4, W
    movwf   dist+1
    movf    AARGB5, W
    movwf   dist+2
    
    movf    scanLong, W
    movwf   AARGB0
    movwf   BARGB0
    movf    scanLong+1, W
    movwf   AARGB1
    movwf   BARGB1
    movf    scanLong+2, W
    movwf   AARGB2
    movwf   BARGB2
    
    call    FXM2424U     ; Interesting result in AARG ( AARGB3:5, B3 MSB )
    
    movf    AARGB5, W
    addwf   dist+2, F
    movf    AARGB4, W
    btfsc   STATUS, C
    incfsz  AARGB4, W
    addwf   dist+1, F
    movf    AARGB3, W
    btfsc   STATUS, C
    incfsz  AARGB3, W
    addwf   dist, F
    
    ; scanDist holds the current closest position. If this position,
    ; dist, is closer, revise scanDist
    
    ; if dist < scanDist...
    ;  copy dist to AARGB0:2 (0 msb) then do aarg = aarg - scanDist
    
    
    movf    dist,W
    movwf   AARGB0
    movf    dist+1, W
    movwf   AARGB1
    movf    dist+2, W
    movwf   AARGB2
    
    movf    scanDist+2, W
    subwf   AARGB2, F
    movf    scanDist+1, W
    btfss   STATUS,C
    incfsz  scanDist+1,W
    subwf   AARGB1, F    
    movf    scanDist, W
    btfss   STATUS,C
    incfsz  scanDist,W
    subwf   AARGB0, F
    
    ; if result negative, then scandist > dist
    ;  scanDist = dist
    ;  currentPosH = scanNumH
    ;  currentPosL = scanNumL
    ; endif
    
    btfss   AARGB0, 7
    goto    nextLoop
    
    ; OK, dist is closer - record the distance and the eeprom location
    movf    dist, W
    movwf   scanDist
    movf    dist+1, W
    movwf   scanDist+1
    movf    dist+2, W
    movwf   scanDist+2
    
    movf    scanNumH, W
    movwf   currentPosH
    movf    scanNumL, W
    movwf   currentPosL

nextLoop    
    movlw   0x01
    subwf   scanNumL, F
    btfss   STATUS, C
    decf    scanNumH, F
    
    ; scanNum zero? End of list if so
    
    movf    scanNumH, W
    iorwf   scanNumL, W
    btfss   STATUS, Z
    goto    loop
    