;*****************************************************************************        
;
;   Module:     scan.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.1 20/3/04                                                  
;
;               location scanner code.
;               This is a loop that searches the list of stored positions
;               looking for the closest one.
;               At the end, we have the following information
;               1) CurrentPos - gives eeprom index of closest camera. zero if none
;               2) ScanDist - the distance-squared to the camera. 
;                  distance is in 1/100 of a minute of arc
;
;*****************************************************************************        

    
loop
    ; Read the data from eeprom, ignoring the first two bytes
    movfw   scanNumL
    movwf   eepAddL
    movfw   scanNumH
    movwf   eepAddH
    bcf     STATUS, C
    rlf     eepAddL, F         ; This calculates numEntries * 8
    rlf     eepAddH, F         ; and only works because the maximum is 1000
    rlf     eepAddL, F         ; You would need to clear the carry flag
    rlf     eepAddH, F         ; otherwise
    rlf     eepAddL, F
    rlf     eepAddH, F
    
    ; add 2 to skip first two bytes
    movlw   0x02
    addwf   eepAddL, F
 
    ; Get data, store in scaLat/scanLong   
    call    eepReadPosition
    
    ; subtract Latmmhh from scanLat, make positive if needed
    movfw   Latmmhh+2
    subwf   scanLat+2, F
    movfw   Latmmhh+1
    btfss   STATUS, C
    incfsz  Latmmhh+1,W
    subwf   scanLat+1, F
    movfw   Latmmhh
    btfss   STATUS, C
    incfsz  Latmmhh,W
    subwf   scanLat, F
    
    btfss   scanLat, 7       ; Was the result negative? Make postive if so
    goto    subLong
    
    comf    scanLat, F    
    comf    scanLat+1, F    
    comf    scanLat+2, F    
    
    movlw   0x01
    addwf   scanLat+2, F
    btfss   STATUS, C
    goto    subLong
    movlw   0x01
    addwf   scanLat+1, F
    btfsc   STATUS, C
    incf    scanLat, F
     
    
    ; subtract Longmmhh from scanLong, make positive if needed
subLong
    movfw   Longmmhh+2
    subwf   scanLong+2, F
    movfw   Longmmhh+1
    btfss   STATUS, C
    incfsz  Longmmhh+1,W
    subwf   scanLong+1, F
    movfw   Longmmhh
    btfss   STATUS, C
    incfsz  Longmmhh,W
    subwf   scanLong, F
    
    btfss   scanLong, 7      ; Was the result negative? Make postive if so
    goto    calcAdjust
    
    comf    scanLong, F    
    comf    scanLong+1, F    
    comf    scanLong+2, F    
    
    movlw   0x01
    addwf   scanLong+2, F
    btfss   STATUS, C
    goto    calcAdjust
    movlw   0x01
    addwf   scanLong+1, F
    btfsc   STATUS, C
    incf    scanLong, F


    ; multiply scanLong by cosineValue, 24U * 16U, result in scanLong
calcAdjust
    movfw   scanLong
    movwf   AARGB0
    movfw   scanLong+1
    movwf   AARGB1
    movfw   scanLong+2
    movwf   AARGB2
    movfw   cosineValueH
    movwf   BARGB0
    movfw   cosineValueL
    movwf   BARGB1

    call    FXM2416U     ; Interesting result in AARG ( AARGB3:5, B3 MSB )

    movfw   AARGB0
    movwf   scanLong
    movfw   AARGB1
    movwf   scanLong+1
    movfw   AARGB2
    movwf   scanLong+2
    
    ; add scanLat to scanLong, result in dist
    movfw   scanLong
    movwf   dist
    movfw   scanLong+1
    movwf   dist+1
    movfw   scanLong+2
    movwf   dist+2
    
    movfw   scanLat+2
    addwf   dist+2, F
    movfw   scanLat+1
    btfsc   STATUS, C
    incfsz  scanLat+1,W
    addwf   dist+1,F
    movfw   scanLat
    btfsc   STATUS, C
    incfsz  scanLat,W
    addwf   dist,F
    
    ; If the camera point is *very* roughly more than 10 minutes of arc
    ; away, then it is too far away to bother with    
    ; subtract 10 minutes ( 1000,  0x03e8 ) from dist.
    movlw   0xe8
    subwf   dist+2, F
    movlw   0x03
    btfss   STATUS, C   
    movlw   0x04
    subwf   dist+1, F
    movlw   0x00
    btfss   STATUS, C
    movlw   0x01
    subwf   dist, F

    ; if result is postive, goto NEXTLOOP
    btfss   dist, 7
    goto    nextLoop
    
    ; OK, we have a valid camera position to evalaute.
    ; Calculate it's real distance from us
    ; the equaltion is distance = squareroot( x**2 time y**2 ),
    ; but we do not need to bother with the square root since 
    ; we are looking for the closet camera, not it's real distance
    
    ; calc dist = scanLat * scanLat + scanLong * scanLog

    movfw   scanLat
    movwf   AARGB0
    movwf   BARGB0
    movfw   scanLat+1
    movwf   AARGB1
    movwf   BARGB1
    movfw   scanLat+2
    movwf   AARGB2
    movwf   BARGB2
    call    FXM2424U     ; Interesting result in AARG ( AARGB3:5, B3 MSB )
    
    movfw   AARGB3
    movwf   dist
    movfw   AARGB4
    movwf   dist+1
    movfw   AARGB5
    movwf   dist+2
    
    movfw   scanLong
    movwf   AARGB0
    movwf   BARGB0
    movfw   scanLong+1
    movwf   AARGB1
    movwf   BARGB1
    movfw   scanLong+2
    movwf   AARGB2
    movwf   BARGB2
    call    FXM2424U     ; Interesting result in AARG ( AARGB3:5, B3 MSB )
    
    movfw   AARGB5
    addwf   dist+2, F
    movfw   AARGB4
    btfsc   STATUS, C
    incfsz  AARGB4, W
    addwf   dist+1, F
    movfw   AARGB3
    btfsc   STATUS, C
    incfsz  AARGB3, W
    addwf   dist, F
    
    ; scanDist holds the current closest position. If this position,
    ; dist, is closer, revise scanDist
    
    ; if dist < scanDist...
    ;  copy dist to AARGB0:2 (0 msb) then do aarg = aarg - scanDist
    
    
    movfw   dist
    movwf   AARGB0
    movfw   dist+1
    movwf   AARGB1
    movfw   dist+2
    movwf   AARGB2
    
    movfw   scanDist+2
    subwf   AARGB2, F
    movfw   scanDist+1
    btfss   STATUS,C
    incfsz  scanDist+1,W
    subwf   AARGB1, F    
    movfw   scanDist
    btfss   STATUS,C
    incfsz  scanDist,W
    subwf   AARGB0, F
    
    ; if result negative, then scandist > dist
    ;  scanDist = dist
    ;  currentPosH = scanNumH
    ;  currentPosL = scanNumL
    ; endif
    
    btfss   AARGB0, 7
    goto    nextLoop
    
    ; OK, dist is closer - record the distance and the eeprom location
    movfw   dist
    movwf   scanDist
    movfw   dist+1
    movwf   scanDist+1
    movfw   dist+2
    movwf   scanDist+2
    
    movfw   scanNumH
    movwf   currentPosH
    movfw   scanNumL
    movwf   currentPosL

nextLoop    
    movlw   0x01
    subwf   scanNumL, F
    btfss   STATUS, C
    decf    scanNumH, F
    
    ; scanNum zero? End of list if so
    
    movfw   scanNumH
    iorwf   scanNumL, W
    btfss   STATUS, Z
    goto    loop
    