; $GPGGA,134158.48x,6016.3072,N,02458.3788,E,1
; $GPGGA,134158.48x,6016.3072,N,02458.3888,E,1
; $GPGGA,134158.48x,5121.2100,N,00000.0000,E,1

; $GPGGA,134158.48x,6016.3072,N,02458.3788,E,0
;*****************************************************************************        
;
;   Module:     cw.asm
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.1 12/01/04                                                  
;
;               Main source file for EPE CameraWatch project.
;               This file contains only the interrupt and mainloop code.
;               This file includes all other source files.
;
;*****************************************************************************        

    list p=16f873, st=OFF, x=OFF, n=0
    errorlevel -302
    errorlevel -306

    #include <p16f873.inc>

    ; Pull in variable definitions and general constants
    #include "equates.inc"


;*****************************************************************************        
;
;   Function :  Reset vector
;               Hardware entry point to the code
;               This vector is also used for soft resets in the event of 
;               abnormal events
;
;   Input:      None.
;
;   Output:     N/A
;
;*****************************************************************************        
    
    ORG    0

RESET        GOTO    Main


;*****************************************************************************        
;
;   Function :  Interrupt vector
;               Hardware entry point for interrupts
;               This vector handles all external and internal interrupts
;
;   Input:      None.
;
;   Output:     N/A
;
;*****************************************************************************        
    
    ORG    4
    
    #include "ints.inc"    

    #include "rxstate.inc"    
    

;*****************************************************************************        
;
;   Function :  Main
;               Main application loop
;
;   Input:      None.
;
;   Output:     N/A
;
;*****************************************************************************        
Main
    clrf    STATUS                ; Select bank 0
    clrf    INTCON                ; No interrupts
    clrf    PCLATH                ; Code is in first bank

    ; Clear all bank0 ram
    movlw   0x20
    movwf   FSR
clrMem
    clrf    INDF
    incf    FSR, F
    btfss   FSR, 7                  ; Have we reached 0x80?
    goto    clrMem                  ; - No, so continue with clear
 
    call    initHardware  
    
    bsf     INTCON, PEIE            ; enable peripheral interrupts
    bsf     INTCON, GIE             ; Enable global interrupts


    ; First - wait to allow power to settle. 1s will do 
    movlw   D'100'
    call    uiWait10ms
    
    ; If the erase button is pressed on powerup, delete
    ; all records
    movfw   PORTA
    andlw   ERASEKEY
    btfsc   STATUS, Z   
    call    eepClear
    
    ; Check the eeprom - initialise it if necessary
    call    eepCheck

    ; Initialise timer flags - I need some to appear 'expired'
    bsf     flags1, IGNORERECBTNTMRFLAG1
    bsf     flags1, IGNOREERASEBTNTMRFLAG1
    bsf     flags1, PWRFLASHOFFTMRFLAG1
    bsf     flags1, WARNINGBEEPONTMRFLAG1   
    bsf     flags1, ERASEBEEPTMRFLAG1   
    bsf     flags1, RECBEEPTMRFLAG1   
 
    ; Get number of records in the eeprom
    clrf    eepAddH
    movlw   0x02
    movwf   eepAddL
    call    eepRead
    movfw   eepData
    movwf   numEntriesH
    incf    eepAddL, F
    call    eepRead
    movfw   eepData
    movwf   numEntriesL
 
    
mainloop
	; Has the interrupt routine asked for an eeprom dump?
	btfsc	flags2, DUMPEEPROMFLAG2
	goto	dumpeeprom

	btfsc	flags2, FILLEEPROMFLAG2
	goto	filleeprom
	
    ; have we received new position data?
    btfss   flags2, NEWDATAFLAG2
    goto    tstSounds
    
    bcf     INTCON, GIE             ; Disable all interrupts
    bcf     flags2, NEWDATAFLAG2
    
    ; copy the data out of the interrupt area
    
    movfw   iLatDeg
    movwf   LatDeg
    movfw   iLongDeg
    movwf   LongDeg
    movfw   iLatmmhh  
    movwf   Latmmhh
    movfw   iLatmmhh +1
    movwf   Latmmhh +1
    movfw   iLatmmhh +2
    movwf   Latmmhh +2
    movfw   iLongmmhh  
    movwf   Longmmhh
    movfw   iLongmmhh +1
    movwf   Longmmhh +1
    movfw   iLongmmhh +2
    movwf   Longmmhh +2
    
    bsf     INTCON, GIE             ; Enable global interrupts

    ; Scan the list of stored camera points

    ; First, calculate the cosine of the latitude angle
    call    calcCosineH
    movwf   cosineValueH
    call    calcCosineL
    movwf   cosineValueL
    
 
    clrf    currentPosH
    clrf    currentPosL
    
    ; Range holds the LED's to display.
    ; They map directly to the port pins, RB1 to RB7
    ; RB0 is the power led
    ; Assume range is 0
    clrf    range      
 
    ; Set a miximum distance. And recorded point should be closer than this
    movlw   0x7f
    movwf   scanDist
    movlw   0xff
    movwf   scanDist+1
    movwf   scanDist+2


    ; If we have no camera points, no need to scan list
    movfw   numEntriesH
    iorwf   numEntriesL, W
    btfsc   STATUS, Z
    goto    calcLEDs       
    
    ; ScanNum will be our pointer to a camera location in eeprom
    movfw   numEntriesH
    movwf   scanNumH
    movfw   numEntriesL
    movwf   scanNumL


    ; The scanning loop is in the include file
    #include "scan.inc"
        
        
calcLEDs
    ; OK, we have processed a new location. We must update the display, even if it is 
    ; to turn off the LEDS's.
    
    ; The key information at this point is
    ; 1) CurrentPos - gives eeprom index of closest camera. zero if none
    ; 2) ScanDist - the distance-squared to the camera. distance is in 1/100 of a minute of arc
    
    ; If currentPos == 0, turn led's off

    bcf     flags2, WARNINGFLAG2    ; Not expecting to sound a warning   
    bsf     flags2, NOWARNFLAG2     ; Are expecting to turn off a warning
    
    movfw   currentPosH
    iorwf   currentPosL, W
    btfsc   STATUS,Z        ; Do we have a 'close' camera?
    goto    showRange       ; NO - so we can exit block
    
    ; Is the closest camera too far away to bother with?
    movfw   scanDist
    iorwf   scanDist, W
    btfss   STATUS,Z
    goto    showRange       ; If ms byte set, show no leds

    movfw   scanDist+1
    andlw   0x80
    btfss   STATUS,Z
    goto    showRange       ; If ms bit byte set, show no leds
    
    ; Right. We have a 15 bit value in scanDist+1, scanDist+2
    ; We now have a set of 7 values that determine the distance when the
    ; lED's turn on. As scanDist holds distance squared, the values are
    ; not linear to distance. In fact they are arbitrary distances, and
    ; are defined in equates.inc
    
    ; At this point in the code, at least LED1 will be displayed
    bsf     range, 1
    
    ; is scanDist(1,2) < DIST_LED2? ie, is scanDist(1,2) - DIST_LED negative?
    
    ; use dist as a temporary variable
    movfw   scanDist+1
    movwf   dist
    movfw   scanDist+2
    movwf   dist+1
    movlw   (DIST_LED2 & 0xFF)
    subwf   dist+1, F
    movlw   (DIST_LED2 >> 8)
    btfss   STATUS, C   
    movlw   (DIST_LED2 >> 8) + 1
    subwf   dist, F

    ; if result is postive, ie scanDist is bigger, goto showRange
    btfss   dist, 7
    goto    showRange
    
    bsf     range, 2

    ; use dist as a temporary variable
    movfw   scanDist+1
    movwf   dist
    movfw   scanDist+2
    movwf   dist+1
    movlw   (DIST_LED3 & 0xFF)
    subwf   dist+1, F
    movlw   (DIST_LED3 >> 8)
    btfss   STATUS, C   
    movlw   (DIST_LED3 >> 8) + 1
    subwf   dist, F

    ; if result is postive, ie scanDist is bigger, goto showRange
    btfss   dist, 7
    goto    showRange
    
    bsf     range, 3


    ; use dist as a temporary variable
    movfw   scanDist+1
    movwf   dist
    movfw   scanDist+2
    movwf   dist+1
    movlw   (DIST_LED4 & 0xFF)
    subwf   dist+1, F
    movlw   (DIST_LED4 >> 8)
    btfss   STATUS, C   
    movlw   (DIST_LED4 >> 8) + 1
    subwf   dist, F

    ; if result is postive, ie scanDist is bigger, goto showRange
    btfss   dist, 7
    goto    showRange
    
    bsf     range, 4

    ; use dist as a temporary variable
    movfw   scanDist+1
    movwf   dist
    movfw   scanDist+2
    movwf   dist+1
    movlw   (DIST_LED5 & 0xFF)
    subwf   dist+1, F
    movlw   (DIST_LED5 >> 8)
    btfss   STATUS, C   
    movlw   (DIST_LED5 >> 8) + 1
    subwf   dist, F

    ; if result is postive, ie scanDist is bigger, goto showRange
    btfss   dist, 7
    goto    showRange
    
    bsf     range, 5

    ; use dist as a temporary variable
    movfw   scanDist+1
    movwf   dist
    movfw   scanDist+2
    movwf   dist+1
    movlw   (DIST_LED6 & 0xFF)
    subwf   dist+1, F
    movlw   (DIST_LED6 >> 8)
    btfss   STATUS, C   
    movlw   (DIST_LED6 >> 8) + 1
    subwf   dist, F

    ; if result is postive, ie scanDist is bigger, goto showRange
    btfss   dist, 7
    goto    showRange
    
    bsf     range, 6

    ; use dist as a temporary variable
    movfw   scanDist+1
    movwf   dist
    movfw   scanDist+2
    movwf   dist+1
    movlw   (DIST_LED7 & 0xFF)
    subwf   dist+1, F
    movlw   (DIST_LED7 >> 8)
    btfss   STATUS, C   
    movlw   (DIST_LED7 >> 8) + 1
    subwf   dist, F

    ; if result is postive, ie scanDist is bigger, goto showRange
    btfss   dist, 7
    goto    showRange
    
    bsf     range, 7


showRange
    ; Now we have the number of LED's to show
    ; If range bit 6 set, set WARNINGFLAG2 (if not masked) else 
    ; clear warning flag, turn off warning timer, clear maskpos
    ; display 'range' LEDs
    

    bsf     flags2, WARNINGFLAG2
    movfw   currentPosH
    subwf   maskPosH, W
    btfss   STATUS,Z
    goto    sr000
    movfw   currentPosL
    subwf   maskPosL, W
    btfsc   STATUS,Z
    bcf     flags2, WARNINGFLAG2    ; position masked, so no alarm

sr000   
    btfsc   range, 6
    goto    sr001
    
    ; ok, warning off, clear maskpos
    bcf     flags2, WARNINGFLAG2
    clrf    warningBeepOnTmr
    clrf    warningBeepOffTmr    
    bsf     flags1, WARNINGBEEPONTMRFLAG1   
    bcf     flags1, WARNINGBEEPOFFTMRFLAG1   
    clrf    maskPosH
    clrf    maskPosL
    
sr001
    movlw   0x01
    andwf   portBCopy, F
    movfw   range
    iorwf   portBCopy, F
    movfw   portBCopy
    movwf   PORTB        
        
    
; Check and update status of beeps
tstSounds
    ; If all beep timers are expired, turn off sound output
    movlw   BEEPSOURCES
    andwf   flags1, W
    sublw   BEEPSOURCES    
    movlw   0
    btfsc   STATUS, Z       ; are all beep sources expired?
    call    SetSound        ; yes, so turn off sounds
  
    ; Check to see if we need to sound a warning beep
    btfss   flags2, WARNINGFLAG2
    goto    testLock

    btfss   flags1, WARNINGBEEPOFFTMRFLAG1
    goto    testBeep
    bcf     flags1, WARNINGBEEPONTMRFLAG1 
    bcf     flags1, WARNINGBEEPOFFTMRFLAG1 
    movlw   WARNINGONTIME
    movwf   warningBeepOnTmr            ; start timer
    movlw   WARNINGBEEPFREQ
    call    SetSound                    ; Set the sound output frequency
    goto    testLock
    
testBeep
    btfss   flags1, WARNINGBEEPONTMRFLAG1   
    goto    testLock

    bcf     flags1, WARNINGBEEPONTMRFLAG1 
    bcf     flags1, WARNINGBEEPOFFTMRFLAG1 
    movlw   WARNINGOFFTIME
    movwf   warningBeepOffTmr           ; start timer
    movlw   NOSOUND
    call    SetSound                    ; Set the sound output frequency
    
testLock      
    ; Are we in lock? If not, flash PWR LED
    btfss   flags2, INLOCKFLAG2
    goto    notInLock
    
    ; In lock, so ensure PWRLED is on
    bsf     portBCopy, PWRLED
    movfw   portBCopy
    movwf   PORTB
    goto    testKeys
      
notInLock   
    ; Turn off all position led's
    movlw   0x01
    andwf   portBCopy, F
    movfw   portBCopy
    movwf   PORTB
    
    ; Ensure warning beep stops
    bcf     flags2, WARNINGFLAG2
    clrf    warningBeepOnTmr
    clrf    warningBeepOffTmr    
    bsf     flags1, WARNINGBEEPONTMRFLAG1   
    bcf     flags1, WARNINGBEEPOFFTMRFLAG1   
    clrf    maskPosH
    clrf    maskPosL
    

    ; Flash power LED to indicate out of lock
    btfss   flags1, PWRFLASHOFFTMRFLAG1   
    goto    testOn
    bcf     flags1, PWRFLASHOFFTMRFLAG1 
    bcf     flags1, PWRFLASHONTMRFLAG1 
    movlw   PWRLEDONTIME
    movwf   pwrFlashOnTmr           ; start timer
    bsf     portBCopy, PWRLED       ; turn LED on
    movfw   portBCopy
    movwf   PORTB
    goto    testKeys
    
testOn
    btfss   flags1, PWRFLASHONTMRFLAG1   
    goto    testKeys
    bcf     flags1, PWRFLASHOFFTMRFLAG1 
    bcf     flags1, PWRFLASHONTMRFLAG1 
    movlw   PWRLEDOFFTIME
    movwf   pwrFlashOffTmr           ; start timer
    bcf     portBCopy, PWRLED       ; turn LED off
    movfw   portBCopy
    movwf   PORTB

testKeys
    ; Ignore the record button if it has been pressed recently
    btfss   flags1, IGNORERECBTNTMRFLAG1
    goto    eraseKeyCheck
    
    ; Ignore the record button if the  memory is full
    
    
    movfw   numEntriesH
    sublw   0x03
    btfss   STATUS, Z
    goto    tk1                 ; Not 1000, so check key allowed
    movfw   numEntriesL
    sublw   0xE8
    btfsc   STATUS, Z
    goto    eraseKeyCheck       ; It is 1000 - add no more, ignore key    

tk1    
    ; Has the record button been pressed?
    
    movfw   PORTA
    andlw   RECORDKEY
    btfss   STATUS, Z   
    goto    eraseKeyCheck           ; No - goto next test

    movlw   IGNORERECORDKEYTIME
    movwf   ignoreRecBtnTmr
    bcf     flags1, IGNORERECBTNTMRFLAG1

    ; If we have not recently recorded a location, 
    ; 0) start record beep
    ; 1) record location
    ; 2) Clear other beep timers
    ; 3) start record timer
    movlw   RECORDBEEPFREQ
    call    SetSound        ; Set the sound output frequency
    bcf     flags1, RECBEEPTMRFLAG1 
    movlw   RECORDBEEPTIME
    movwf   recBeepTmr           ; start timer


    bcf     flags2, WARNINGFLAG2
    clrf    warningBeepOnTmr
    clrf    warningBeepOffTmr    
    bsf     flags1, WARNINGBEEPONTMRFLAG1   
    bcf     flags1, WARNINGBEEPOFFTMRFLAG1           
        
    btfss   flags2, INLOCKFLAG2
    goto    eraseKeyCheck   
        
    movlw   0x01                  
    addwf   numEntriesL,F
    btfsc   STATUS,C
    incf    numEntriesH,F       ; Add 1 to number of stored points
    
    movfw   numEntriesH
    movwf   eepData
    movlw   0x02
    movwf   eepAddL
    clrf    eepAddH
    call    eepWrite
    movfw   numEntriesL
    movwf   eepData
    call    eepWrite            ; store number of stored points
    
    movfw   numEntriesL
    movwf   eepAddL
    movfw   numEntriesH
    movwf   eepAddH
    bcf     STATUS, C
    rlf     eepAddL, F         ; This calculates numEntries * 8
    rlf     eepAddH, F         ; and only works because the maximum is 1000
    rlf     eepAddL, F         ; You would need to clear the carry flag
    rlf     eepAddH, F         ; otherwise
    rlf     eepAddL, F
    rlf     eepAddH, F
   
    ; Now store the data. This is
;            binary degrees lat                  1
;            binary degrees long                 1
;            binary minutes, signed lat          3
;            binary minutes, signed long         3

    movfw   LatDeg
    movwf   eepData
    call    eepWrite
    movfw   LongDeg
    movwf   eepData
    call    eepWrite
    movfw   Latmmhh
    movwf   eepData
    call    eepWrite
    movfw   Latmmhh+1
    movwf   eepData
    call    eepWrite
    movfw   Latmmhh+2
    movwf   eepData
    call    eepWrite
    movfw   Longmmhh
    movwf   eepData
    call    eepWrite
    movfw   Longmmhh+1
    movwf   eepData
    call    eepWrite
    movfw   Longmmhh+2
    movwf   eepData
    call    eepWrite

    ; Make sure we do not alarm this new position - we already know there is a 
    ; Camera here!
    movfw   numEntriesH
    movwf   maskPosH
    movfw   numEntriesL
    movwf   maskPosL
           
        
eraseKeyCheck
    ; Ignore the erase button if it has been pressed recently
    btfss   flags1, IGNOREERASEBTNTMRFLAG1
    goto    nextCheck
    movfw   PORTA
    andlw   ERASEKEY
    btfss   STATUS, Z
    goto    nextCheck               ; No - goto next test
    
    movlw   IGNOREERASEKEYTIME
    movwf   ignoreEraseBtnTmr
    bcf     flags1, IGNOREERASEBTNTMRFLAG1

    btfss   flags2, WARNINGFLAG2
    goto    eraseLoc
      
    ; Clear warning alarm
    movfw   currentPosH
    movwf   maskPosH
    movfw   currentPosL
    movwf   maskPosL



    bcf     flags2, WARNINGFLAG2
    clrf    warningBeepOnTmr
    clrf    warningBeepOffTmr    
    bsf     flags1, WARNINGBEEPONTMRFLAG1   
    bcf     flags1, WARNINGBEEPOFFTMRFLAG1   

    movlw   NOSOUND
    call    SetSound                    ; Set the sound output frequency

    goto    nextCheck
    ; If we have not recently erased a location,
    ; 0) start erase beep
    ; 1) copy last location to this location
    ; 2) decrement count of positions.
eraseLoc      
    movlw   ERASEBEEPFREQ
    call    SetSound        ; Set the sound output frequency
    bcf     flags1, ERASEBEEPTMRFLAG1 
    movlw   ERASEBEEPTIME
    movwf   eraseBeepTmr           ; start timer    
    
    ; OK, so to delete the position we do this
    
    ;1) The position is in currentPosH/L
    ;2) if currentPos == 0 or currentPos == numentries, just decrement numentries & write it back to eeprom
    ;3) else
    ;4) Copy last position into current position
    ;5) decrement numentries & write it back to eeprom

    movfw   numEntriesH
    iorwf   numEntriesL, W
    btfsc   STATUS,Z        ; Do we have any entries?
    goto    nextCheck       ; No, so no point continuing
        
    movfw   currentPosH
    iorwf   currentPosL, W
    btfsc   STATUS,Z        ; Is currentPos zero?
    goto    delLastEntry    ; Yes, so delete last entry in eeprom
    
    subwf   numEntriesH, W
    btfss   STATUS, Z
    goto    delNotLastEntry
    movfw   currentPosL
    subwf   numEntriesL, W
    btfsc   STATUS, Z
    goto    delLastEntry    ; numEntries == currentPos, so we are deleting the last
    
delNotLastEntry
    ; First, copy last entry into the current position, then just jump to delLastEntry
    movfw   numEntriesL
    movwf   eepAddL
    movfw   numEntriesH
    movwf   eepAddH
    bcf     STATUS, C
    rlf     eepAddL, F         ; This calculates numEntries * 8
    rlf     eepAddH, F         ; and only works because the maximum is 1000
    rlf     eepAddL, F         ; You would need to clear the carry flag
    rlf     eepAddH, F         ; otherwise
    rlf     eepAddL, F
    rlf     eepAddH, F
    
    call    eepRead
    movwf   LatDeg
    incf    eepAddL, F
    call    eepRead
    movwf   LongDeg
    incf    eepAddL, F
    call    eepRead
    movwf   Latmmhh
    incf    eepAddL, F
    call    eepRead
    movwf   Latmmhh+1
    incf    eepAddL, F
    call    eepRead
    movwf   Latmmhh+2
    incf    eepAddL,F       
    call    eepRead
    movwf   Longmmhh
    incf    eepAddL, F
    call    eepRead
    movwf   Longmmhh+1
    incf    eepAddL, F
    call    eepRead
    movwf   Longmmhh+2

    ; write this data now
    
    movfw   currentPosL
    movwf   eepAddL
    movfw   currentPosH
    movwf   eepAddH
    bcf     STATUS, C
    rlf     eepAddL, F         ; This calculates numEntries * 8
    rlf     eepAddH, F         ; and only works because the maximum is 1000
    rlf     eepAddL, F         ; You would need to clear the carry flag
    rlf     eepAddH, F         ; otherwise
    rlf     eepAddL, F
    rlf     eepAddH, F
   
    movfw   LatDeg
    movwf   eepData
    call    eepWrite
    movfw   LongDeg
    movwf   eepData
    call    eepWrite
    movfw   Latmmhh
    movwf   eepData
    call    eepWrite
    movfw   Latmmhh+1
    movwf   eepData
    call    eepWrite
    movfw   Latmmhh+2
    movwf   eepData
    call    eepWrite
    movfw   Longmmhh
    movwf   eepData
    call    eepWrite
    movfw   Longmmhh+1
    movwf   eepData
    call    eepWrite
    movfw   Longmmhh+2
    movwf   eepData
    call    eepWrite   
    
    ; This is the last position copied over; now fall through to delLatEntry 
    
    
delLastEntry
    ; Decrement numEntries by 1 and write back to eeprom at location 2/3
    
    movlw   0x01
    subwf   numEntriesL, F
    btfss   STATUS, C
    decf    numEntriesH, F
    
    movfw   numEntriesH
    movwf   eepData
    movlw   0x02
    movwf   eepAddL
    clrf    eepAddH
    call    eepWrite
    movfw   numEntriesL
    movwf   eepData
    call    eepWrite            ; store number of stored points

    
nextCheck    
    goto    mainloop


dumpeeprom
	bcf		flags2, DUMPEEPROMFLAG2
	
    movlw   0x0A
    call    SerialTransmit
    movlw   0x0D
    call    SerialTransmit
    movlw   0x0A
    call    SerialTransmit
    movlw   0x0D
    call    SerialTransmit
    
    clrf	eepAddL
    clrf	eepAddH
dspMem2
    movfw   eepAddL
    andlw   0x0F
    btfss   STATUS, Z
    goto    dspMem3
    movlw   0x0A
    call    SerialTransmit
    movlw   0x0D
    call    SerialTransmit
dspMem3
    call    eepRead
    call    SerialHexTransmit

    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F

	movfw	eepAddL
	btfss	STATUS,Z
    goto    dspMem2 
    movlw	0x20
    subwf	eepAddH, W
	btfss	STATUS,Z
	goto	dspMem2
	goto	mainloop

filleeprom
	bcf		flags2, FILLEEPROMFLAG2
	
	; Disable rx interrupts
    bcf     INTCON, GIE             ; Disable all interrupts
	; receive 8K file
    clrf    eepAddH
    clrf    eepAddL


    btfss   PIR1,RCIF    ;check that buffer is empty
    goto    $-1
    movfw   RCREG
    movwf   tmpH
    call    SerialTransmit
    btfss   PIR1,RCIF    ;check that buffer is empty
    goto    $-1
    movfw   RCREG
    movwf   tmpL
    call    SerialTransmit


fe001    
    btfss   PIR1,RCIF    ;check that buffer is empty
    goto    $-1
    movfw   RCREG
    movwf   tmpM
    movwf   eepData
    call    eepWrite
    movfw   tmpM
    call    SerialTransmit
    
	movfw	eepAddL
	subwf   tmpL, W
	btfss	STATUS,Z
    goto    fe001 
	movfw   tmpH
    subwf	eepAddH, W
	btfss	STATUS,Z
	goto	fe001
        
	; set lights 
	movlw   0xFF
	movwf   PORTB
	
	; stop	
hlt
	goto	hlt


    ; Pull in all the other project Modules
    #include "utils.inc"
    #include "eeprom.inc"
    #include "an617.inc"

    END                ; End of program
    