;timer reload calculation
; reload value =256 - (Fosc/12 * (2^smod/32) / Baud_Rate)
;Fosc =	12MHz	16MHz	20MHz	11.0592	14.7456	18.4320	smod
;Rate
;150	030H	--	--	040H	000H	-- 	0
;300	098H	075H	052H	0A0H	080H	060H	0
;600	0CCH	0BBH	0A9H	0D0H	0C0H	0B0H	0
;1200	0E6H	0DEH	0D5H	0E8H	0E0H	0D8H	0
;2400	0F3H	0EFH	0EAH	0F4H	0F0H	0ECH	0
;4800	--	*	0F5H	0FAH	0F8H	0F6H	0
;9600	--	--	*	0FDH	0FCH	0FBH	0
;19200	--	--	--	0FDH	0FCH	0FBH	1
;38400  --	--	--	--	0FEH	--	1
;76800	--	--	--	--	0FFH	--	1

$MOD51
reload	    equ 0F3H 	      ; 4800 baud (smod=1 :DOUBLE BAUD RATE)
			
max_str_len equ 014H 	      ; max string length i.e. buffer size

	    DSEG              ;select data segment
            ORG 30H	      ; set user ram above registers and bit area
                              ;NOTE only one register bank is used and no bit data is needed
                              ;so 08H could be used, (30H is a safe).
  
str_buf:    ds  max_str_len+1 ; 20 bytes of usable storage 
; the stack pointer defaults to 07H, this would be OK for this prog because there is a large hole
; between 08h-30h however this is a safe way to relocate the stack                     
stack_top:  ds 1              ; this will be the top of the internal ram
	                      ; this must be LAST do not add any ram storage after here	
	  
        CSEG                  ;reselect code segment
	ORG 00H
RESET:  SJMP START

	ORG 30H                  ; start the program at 30H above all the reset vectors (even
                                 ; though we do note use any interupts) 
START:  
        mov sp,#stack_top        ;ensure stack pointer is at the top of used ram
        mov dptr,#intro           ;point to intro
        acall SINT
        acall PSTR		 ;call print string routine
        acall newline
        mov dptr,#question
        acall PSTR
        acall getstr             ;get string and store in global buffer strbuf
        mov dptr,#reply
        acall PSTR
        acall pstrbuf            ;print contents strbuf
        acall newline
ECHO:   acall cin                ;loop forever echoing characters
        acall cout
        sjmp ECHO



SINT:  	NOP
	orl	PCON,#10000000b  ; set bit 7 to double baud rate (SMOD)
	MOV	TMOD,#00100001b  ; Timer Mode 2: 8 bit reload
	MOV	SCON,#01010000b  ; Set Serial for mode 1 &
				 ; Enable reception
	ORL	TCON,#01010010b  ; Start timer 1 both timer
	mov	a, #reload       ;4800
	mov	th1, a
	setb	ti		;ti is normally set in this program
	clr	ri		;ri is normally cleared
        setb    tr1             ;start timer
        ret

;	Console character input routine.
;	Waits for next input from console device and returns with character
;	code in accumulator.
;
cin:   JNB     RI,$            ;Wait until character received.
        MOV     A,SBUF          ;Read input character.
	CLR	RI		;Clear reception flag.
	ret



;	Console character output routine.
;	Outputs character received in accumulator to console output device.
;
cout:  JNB     TI,$            ;Wait until transmission completed.
        CLR     TI              ;Clear interrupt flag.
	MOV	SBUF,A		;Write out character.
	RET

newline:push	acc
	mov	a, #13
	acall	cout
	mov	a, #10
	acall	cout
	pop	acc
	ret

PSTR:		       ;print string @DPTR
	PUSH	ACC
PSTR1:	CLR	A
	MOVC	A,@A+DPTR
	JZ	PSTR2
	mov	c, acc.7
	anl	a, #01111111b
	acall	cout
	Jc	pstr2
	inc	dptr
	SJMP	PSTR1					       
PSTR2:	POP	ACC
	RET    

getstr: ;get a string and store in an internal ram buffer
        ;  str_buf = beginning of the buffer
        ;  max_str_len = max number of char to receive
        ;   (buffer must be one larger for null termination)

        mov     r0, #str_buf
gstrz:  mov     @r0, #0                 ;fill buffer with zeros
        inc     r0
        cjne    r0, #(str_buf+max_str_len+1), gstrz
        mov     r0, #str_buf
gstr_in:lcall   cin
        acall   isend     ;test for end of input esc or line feed
        jc      endstr 
        cjne    r0, #(str_buf+max_str_len), ststore ;test for buffer full
        sjmp    endstr 
ststore: mov     @r0, a
        inc     r0
        sjmp    gstr_in
endstr: clr     a
        mov     @r0, a
        ret

;test for end string input, either ESC or Line feed set C=1 for end
isend:  clr  c
        cjne a,#01bh,lf   ;test for esc
        sjmp endln
lf:     cjne a,#0DH,nend   ;test for line feed
endln:  setb c
nend:   ret    
 


pstrbuf:  ;print the string in the internal ram buffer
        mov     r0, #str_buf
pstrbuf2:
        mov     a, @r0
        jz      pstrbuf3
        lcall   cout
        inc     r0
        sjmp    pstrbuf2
pstrbuf3:
        ret

         CSEG              ;select code segment
intro:    db 'Test message, using serial port',0 ;terminate 0
question: db 'enter string >',0
reply:    db 'You entered ',0
	end
