 //INTEL HEX TO BINARY FILE CONVERTER
//By Colin Meikle September 1997
//Rev A.0
//Email colin.meikle@virgin.net

//Reads in a intel.hex file into a 1 or 2k buffer for programming
//1051 or 2051 devices.

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <conio.h>

#define FALSE	0
#define TRUE	1
#define END_OF_RECORD 01
#define DATA 0

#define SIZE1051 1024
#define SIZE2051 2048
#define max_size 8096

#define GET_BYTE 16*aton(getc(hexfile)) +  aton(getc(hexfile))

typedef unsigned char     BYTE;
typedef unsigned int      WORD;

int aton(unsigned ch);

load_intel(char fname[],unsigned char buffer[],int chip_size) {


FILE *hexfile;
int i=0;
int finish=0;
//char *fname;
//char outname[80];
char *ans;
unsigned char addh,addl;
char ch=0;
unsigned char csum=0;
unsigned int len=0;
unsigned int type=0;
unsigned int  address=0;
int error=0;

//initialise array
 for(i=0;i<chip_size;i++){
  buffer[i]=0xff;
 }
 //get name of output file

// printf("Enter name for output binary file >");
// scanf("%s",outname);
// if ((binfile = fopen( outname, "wb" )) == NULL) {
//  printf("ERROR OPENING OUTPUT FILE");
//  return( FALSE );		// file open failed
// }


 //open file
 printf("Opening file %s\n",fname);
 if ((hexfile = fopen( fname, "r" )) == NULL) {
  printf("ERROR OPENING FILE\n");
  return( FALSE );		// file open failed
 }

 finish=0;
 while(!finish){
  //look for colon or eof
  csum=0;
  ch=0;
  while(ch!=':'&&ch!=EOF){
	ch=getc(hexfile);
  }
  if(ch==EOF){
	finish=TRUE;
  }
  else     //start of a record
  {
	//get len   (2 chars)
	len=GET_BYTE;
	csum=len;
	//debug
	//printf("\nlength= %x ",len);
	//get address  (4 chars)
	addh=GET_BYTE;
	addl=GET_BYTE;
	csum+=addl+addh;
	address=addh*256+addl;
	//debug
	//printf(" address= %x ",address);
	//get type end?
	type=GET_BYTE;
	csum+=type;
	if(type==END_OF_RECORD ){ //end when len =0 ?
	 finish=TRUE;
	}
	if(type!=DATA ){
	 len=0;
	}
	//get data and fill array
	for(i=0;i<len;i++){
	 ch=GET_BYTE;
	 csum+=ch;
	 buffer[address+i]=ch;
	 if(address>chip_size){
		 printf("Error: Address %x out of range for Device\n",address+i);
		 error=TRUE;
	 }
	}
	//calc csum
	 ch=GET_BYTE;
	 csum+=ch;
	 if(csum){
	  printf("Checksum Error at address %x to %x\n",address-len,address);
	  error=TRUE;
	 }
  }  // end record
 }   //end file
 fclose(hexfile);

// //write array to file
// for(i=0;i<max_size;i++){
//  putc(buffer[i],binfile);
// }

// fclose(binfile);
 if (error==TRUE){
  printf("ERROR(S) were found while reading %s. Ignore errors y/n >\n",fname);
  gets( ans );
  *ans |= 0x20;		// convert first char to lower case
  if (*ans=='n'){
	return FALSE;
  }
 }
 return TRUE;
}    //end main


int aton(unsigned ch)      	/* ascii character to a numerical value */
{
int n;
	 if(ch<0x3A)n=ch-0x30;
	 else n=ch-0x37;
	 return n;
}



