/**************************************************************************/
/* 	GREEN HOUSE CONTROLLER 						  */
/*	SETUP Routines							  */
/**************************************************************************/

#include "green.h"
extern code char *setup_mes[];
extern code char *mess[];

void            setup()
{
    char            sel = 0;
    char            press=0xff ;
    extern signed char air_temp[];  /* current,min,max */
    extern signed char soil_temp[];
    extern char     set_soil;
    extern char     set_temp;
    extern unsigned char water_time;
    extern unsigned char enable_soil;   /* enable only */
    extern unsigned char enable_water;
    extern char bost;
    extern char bost_temp;
   // up=bost on ;down=off
   
    if (!SWSEL){
      wait(0x7F);          //wait then double check;
       if(!SWSEL){
        press=SELECT;         //could get stuck here
       }
    }
    if (!SWUP)
      bost=bost_temp;
    if (!SWDN)
      bost=0;

    if (press==SELECT) {
        while ((sel != 4) || (press != SELECT)) {   /* loop until exit is
                                                     * selected */
            lcd_wr(CMD, CLEAR); /* clear display */
          //  set_posn(0);
            lcd_print(mess[3]);   //set
            set_posn(6);
            lcd_print(setup_mes[sel]);
            set_posn(41);
            lcd_print(setup_mes[7]);
            get_rel();
            press = get_press();
            if (press == UP) {
                sel++;
                if (sel > 5)
                    sel = 0;
            }
            if (press == DOWN) {
                sel--;
                if (sel < 0)
                    sel = 4;
            }
            if (press == SELECT) {
                switch (sel) {
                case 0:         // change temp channel 1
                    set_level(&water_time, 1, 50, 0);
                    break;
                case 1:         // change temp channel 2
                    enable(&enable_soil);
                    set_level(&set_temp, -5, 35, 1);
                    break;

                case 2:         // change water 
                    enable(&enable_water);
                    set_level(&set_soil, 1, 90, 9); //1=paddy field 90=cactus
                    break;
                case 3:
                    soil_temp[1] = 40;
                    soil_temp[2] = -20;
                    air_temp[1] = 40;
                    air_temp[2] = -20;
                    break;
               
                case 5:         // change water 
                    get_rel();
                    set_level(&bost_temp, 10, 30, 5); 
                    break; 


                }               // end switch
            }                   // end if select
          get_rel();          // ensure no button press  
        }                       // end while
      
      }                           // end is press
    swen = 0;                   // disable switches

}


void            set_level(char *setting, char min, char max, char mess)
{                               /* setting,min,max,mess */
    char            press = 0x20;
    /* char set_temp=15;   /*starting temp*/
    /* clear lcd */
    get_rel();
    lcd_wr(CMD, CLEAR);
    lcd_print(setup_mes[mess]);
    set_posn(44);               /* second row +4 */
    lcd_print(setup_mes[7]);
    while (press != SELECT) {   /* not select */
        set_posn(12);
        lcd_print(num_str(*setting));
        press = get_press();
        get_rel();              /* could use a long wait instead ? */
        if (press == UP && *setting <= max) {   /*  MAX */
            (*setting)++;
        }
        if (press == DOWN && *setting >= min) { /* MIN*/
            (*setting)--;
        }
    }
    /* return set_temp; */
}



void            enable(char *chan)
{
    unsigned char   press;
    set_posn(41);
    lcd_print(setup_mes[6]);
    get_rel();                  /* ensure last key release */
    press = get_press();
    if (press == UP) {
        *chan = 1;              // enable
    }
    if (press == DOWN) {
        *chan = 0;
    }
}
