/**************************************************************************/
/* 	GREEN HOUSE CONTROLLER 						  */
/*	REV C	  							  */	
/*	Colin Meikle 24/07/96
/*	Last change  29/05/97 						  */
/**************************************************************************/
/*REV B 05/08/96 Removed busy from LCD add transmitter stuff              */

//REV C
// 11/09/96 added soil limit of 99
// removed enable air 
// water level now unsiged char
//REV D
// 22/10/96 Replaced ABS PUTCHAR & GETCHAR functions.
// 22/10/96 Included stuff for Derek, Boost control, do not show watering when not used
// 22/12/96 Added new table for Angus's controller 2C differnt from Derek


/*	GLOBAL VARRIABLE DECLARATIONS					*/
#pragma ORDER
#include "green.h"
#include "global.h"




main()
{

    unsigned char   channel = 0;/* channel number */
    unsigned char   i;
/*INITIALISE DEVICES*/
    TMIT = OFF;
    SCON = 0x50;                /* SCON: mode 1, 8-bit UART, enable rcvr    */
    TMOD = 0x20;                /* TMOD: timer 1, mode 2, 8-bit reload      */
    TH1 = 0xf3;                 /* TH1:  reload value for 2400 baud         */
    TR1 = 1;                    /* TR1:  timer 1 run                        */
    TI = 1;                     /* TI:   set TI to send first char of UART  */
    PUMP = OFF;
    HEATER = OFF;
    enable_soil=OFF;
    lcd_init();
    


/*MAIN LOOP*/

    while (1) {
       for (i = 0; i < 0x20; i++){ 
         wait(0x7f);
         setup();
       }
       
        if(!enable_water&&channel>1)
         channel=0;              //don't display waterinfo if not enabled
         display(channel);
         output();               /* turn on_off pump or heater */

        channel++;
        if (channel >= 0x08) {
            channel = 0;
            if (rwater > 0)
                rwater--;
        }
        xmit_data();
       
        
    }
}


void            display(char chan)
{
    unsigned char            i = 0;

    switch (chan) {
    case 0:
    /* channel 0 here due to longer display time */
        select(0, 0, 0);        /* channel 0 selected */
        get_temp(air_temp);     /* get air temp readings */

        lcd_print(setup_mes[8]);
        set_posn(40);
         for (i = 0; i < 3; i++) {
            lcd_print(num_str(air_temp[i]));
        }
        
        break;

        
    
    case 1:
        select(0, 0, 1);        /* channel 1 selected */
        get_temp(soil_temp);    /* get soil temp readings */

        lcd_print(setup_mes[1]);
        if(bost)
        lcd_print(setup_mes[5]);  
        set_posn(40);
        for (i = 0; i < 3; i++) {
            lcd_print(num_str(soil_temp[i]));
        }
        break;
    case 2:
       /*channel 2 here */
        select(0, 1, 0);        /* channel 2 selected */
        water = a_d();

        if (water < 80) {
            lcd_print(mess[0]);
            lcd_print(num_str(water));
        } else
            lcd_print(mess[1]);
        break;

    case 7:
        select(1, 1, 1);        /* channel 7 selected */
        soil = a_d();           /**/
         if(soil>99)
          soil=99;  //can not display > 99
        lcd_print(setup_mes[9]);
        set_posn(41);
        lcd_print(mess[2]);
        lcd_print(num_str(soil));
        break;


    }
}



void            output()
{

    if (PUMP == ON) {
        time--;
    }
    if (time == 0) {
        PUMP = OFF;
    }
    if (soil > set_soil && enable_water > 0 && PUMP == OFF && rwater == 0) {
        /* watering required */
        PUMP = ON;
        time = water_time;
        rwater = REWATER_TIME;
        /* code to prevent rewatering */
    }
    if ((soil_temp[0] < set_temp)||(soil_temp[0] < bost) && enable_soil > 0) {
        HEATER = ON;
    } else {
        HEATER = OFF;
    }
}



 /* Routimes to convert data for the lcd and temperature convertions */



void            get_temp(signed char *(temp))
{
    unsigned char   reading;

    reading = a_d();            /* channel already selected */
    *(temp) = look_up(reading); /* get actual temperature */
    if (*temp < *(temp + 1)) {  /* test for new min temp */
        *(temp + 1) = *temp;
    }
    if (*temp > *(temp + 2)) {  /* test for new max */
        *(temp + 2) = *temp;
    }
}
